defstar {
	name { Integrator }
	domain { CG96 }
	desc { Integrator }
	version { @(#)CG96Integrator.pl	1.9 12/8/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
        acknowledge { Gabriel version by Anthony Wong }
	location { CG96 nonlinear functions library }
	explanation {
The input to the star is accumulated.
The  accumulator  is initially set to the value initialValue.
        }    

	input {
		name { input }
		type { float }
 	}
	output {
		name { output }
		type { float }
	}
	state {
		name {leakage}
		type {float}
		default {"1.0"}
		desc { leakage value }
	}
 	state {
		name {initialValue}
		type {float}
		default {0.0}
		desc { value at time zero }
	}
	state {
		name {temp}
		type {float}
		default {0.0}
		desc { An internal state.}
		attributes { A_NONSETTABLE|A_YMEM|A_NONCONSTANT }
	}
        codeblock(first) {
        move    $ref(temp),d0.s
        }
        codeblock(leakageCB) {
        move    #>$val(leakage),d1.s
        fmpy.s  d0,d1,d0
        }
        codeblock(done) {
        move    $ref(input),d1.s
        fadd.s  d1,d0
        move    d0.s,$ref(temp)
        move    d0.s,$ref(output)
        }    
	setup {
		temp=initialValue;
	}
	go {
                addCode(first);
		if(leakage != 1.0) addCode(leakageCB);
		addCode(done);
	}
	execTime {
                if(double(leakage)==1.0)
	               return 5;
		else
	               return 7;
       }
}
