defstar {
	name { FixToFloat }
	domain { CG96 }
	desc { Fix to Float number star }
	version { @(#)CG96FixToFloat.pl	1.9 12/1/92 }
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 conversion library }
	explanation {
.PP
The star converts a N-bit fix-point number
to a 32-bit IEEE single-precision format floating-point number
for N <= 32.
The N-bit fix-point number is assumed to be
a two's complement number between -1 (inclusive) and +1 (exclusive).
The bits (sign bit included) for the fix-point number
should occupy the lowest N bits of a 32-bit word.
	}

        seealso { floatToFix }
	input {
		name {input}
		type {fix}
	}
	output {
		name {output}
		type {float}
	}
        state {
                name {N}
                type {int}
	        desc { N-bit fix-point }
                default { 32 }
	}
	codeblock(defaultCB) {
        move    $ref(input),d0.l
        lsl     #>32-$val(N),d0.l
        float.s d0
        move    #>4.656612873077393E-10,d1.s
        fmpy.s  d0,d1,d0
        move    d0.s,$ref(output)
        }

        codeblock(less) {
        move    $ref(input),d0.l
        float.s d0
        move    #>4.656612873077393E-10,d1.s
        fmpy.s  d0,d1,d0
        move    d0.s,$ref(output)
	}
	go {
		if (int(N)<32)
                 	addCode(defaultCB);
	       	else
	         	addCode(less);
	}
	execTime {
                if(int(N)==32)
	    		return 8;
		else
	                return 10;
	}

}
