defstar {
	name { DownSample }
	domain { CG96 }
	desc { Down sampling star }
	version { @(#)CG96DownSample.pl	1.7 12/8/92 }
	author { Chih-Tsung Huang }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 control library }
	explanation {
A decimator by "factor" (default 2).  The "phase" tells which sample to
output.  If phase = 0, the most recent sample is the output, while if
phase = factor-1 the oldest sample is the output.  Phase = 0 is the
default.
	}
	input {
		name {input}
		type {anytype}
	}
	output {
		name {output}
		type {=input}
	}
	state {
		name {factor}
		type {int}
		default {2}
		desc { Downsample factor. }
		attributes { A_SETTABLE }
	}
	state {
		name {phase}
		type {int}
		default {0}
		desc { Downsample phase. }
		attributes { A_SETTABLE }
	}
        setup {
		input.setSDFParams(int(factor),int(factor)-1);
		if (int(phase) >= int(factor))
			Error::abortRun(*this, ": phase must be < factor");
	}
	codeblock (sendsample) {
	move	$ref2(input,phase),d0.s
	move	d0.s,$ref(output)
	}
	go {
		addCode(sendsample);
	}
	execTime {
		return 2;
	}
}
