defstar {
	name { DB }
	domain { CG96 }
	desc { Converts input to dB }
	version { @(#)CG96DB.pl	1.4 11/25/92 }
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 demo library }
	explanation {
This star converts the input to dB.   If  signalSquared  is
"Yes",  the output is 10 * log10(input); otherwise, the output
is 20 * log10(input).  For inputs that are greater  than
zero, the output is either the dB value of the input or min,
whichever is larger.  For inputs that are zero or  negative,
the output is min.
	}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
        state  {
                name { signalSquared }
                type { string }
                default { "No" }
                desc { if no, then regular dB conversion. }
        }
        state  {
                name { min }
                type { float }
                default { "-100.0" }
                desc { minimum output value. }
        }

        state  {
                name { constant }
	        type {floatarray}
	        default {
"0.6681523e-02 -0.6736254e-01 0.2584541e+00 -0.3676691e+00 -0.4461204e+00 0.2740512e+01 -0.5236615e+01 0.6184454e+01 -0.3072334e+01"
                }
                attributes {A_NONSETTABLE|A_YMEM}
        }

	codeblock(squaredNo) {
        move    $ref(input),d0.s
        move    #>$val(min),d2.s
        ftst    d0.s
        fjle    $label(lab1)
        move    #8.685889638,d3.s
        move    #>$addr(constant),r0
        getexp  d0,d7
        fgetman d0,d0
        fclr    d2      y:(r0)+,d1.s
        do      #9,$label(lab2)
        fmpy.x  d2,d0,d2
        fadd.x  d1,d2   y:(r0)+,d1.s
$label(lab2)
        float.x d7
        fadd.s  d7,d2   #0.69317418055,d0.s
        fmpy.s  d2,d0,d2
        fmpy.s  d2,d3,d2
        move    #>$val(min),d3.s
        fcmp    d3.s,d2.s
        fjge    $label(lab3)
        move    d3.s,d2.s
$label(lab3)
$label(lab1)
        move    d2.s,$ref(output)
	}
        codeblock(other) {
        move    $ref(input),d0.s
        move    #>$val(min),d2.s
        ftst    d0.s
        fjle    $label(lab1)
        move    #4.342944819,d3.s
        move    #>$addr(constant),r0
        getexp  d0,d7
        fgetman d0,d0
        fclr    d2      y:(r0)+,d1.s
        do      #9,$label(lab2)
        fmpy.x  d2,d0,d2
        fadd.x  d1,d2   y:(r0)+,d1.s
$label(lab2)
        float.x d7
        fadd.s  d7,d2   #0.69317418055,d0.s
        fmpy.s  d2,d0,d2
        fmpy.s  d2,d3,d2
        move    #>$val(min),d3.s
        fcmp    d3.s,d2.s
        fjge    $label(lab3)
        move    d3.s,d2.s
$label(lab3)
$label(lab1)
        move    d2.s,$ref(output)
        }

	go {
            const char* p=signalSquared;
            
            switch(p[0]) {
            case 'N': case 'n':
	            addCode(squaredNo);
		    break;
            default:
	            addCode(other);
		    return;
	    }	    
	}
	exectime {
            return 44;
	}
}
