defstar {
	name { ASin }
	domain { CG96 }
	desc { Arc Sine function }
	version { @(#)CG96ASin.pl	1.7 12/1/92 }
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 nonlinear functions library }
	explanation {
This star takes the arc sine of the input.
Algorithm - Compute a "x" using Pythagorean theorem, then use the
arc-tangent algorithm.
	}
	execTime {
		return 45;
	}
	input {
		name {input}
		type {float}
	}
	output {
		name {output}
		type {float}
	}
	codeblock (asinblock) {
        move    $ref(input),d5.s
; Code to compute a Y component for arc-tangent to apply
        move    #1.0,d0.s
        fmpy.s  d5,d5,d6
        fsub.s  d6,d0
        fseedr  d0,d4
        fmpy.s  d4,d4,d2        #0.5,d7.s
        fmpy.s  d0,d2,d2        #3.0,d3.s
        fmpy    d4,d7,d2        fsub.s d2,d3    d3.s,d6.s
        fmpy.s  d2,d3,d4        d6.s,d3.s
        fmpy.s  d4,d4,d2
        fmpy.s  d0,d2,d2
        fmpy    d4,d7,d2        fsub.s d2,d3    d3.s,d6.s
        fmpy.s  d2,d3,d4
        fmpy.s  d0,d4,d4
; Code to compute the principle arc-tangent
        fcmpm   d4,d5
        fjge    $label(zcomp)
        fseedd  d4,d6
        fmpy.s  d4,d6,d4        #2.0,d7.s
        fsub.s  d4,d7           d7.s,d3.s
        fmpy.s  d4,d7,d4
        fmpy    d6,d7,d2        fsub.s d4,d3
        fmpy.s  d2,d3,d4
        fmpy.s  d4,d5,d3
        fclr    d2
        fneg.s  d3
        jmp     $label(zdone)
$label(zcomp)
        fseedd  d5,d6
        fmpy.s  d5,d6,d5        #2.0,d7.s
        fsub.s  d5,d7           d7.s,d3.s
        fmpy.s  d5,d7,d5
        fmpy    d6,d7,d2        fsub.s d5,d3
        fmpy.s  d2,d3,d5
        fmpy.s  d4,d5,d3
        ftst    d3.s
        fjmi    $label(aneg)
        move    #1.5707963268,d2.s
        jmp     $label(zdone)
$label(aneg)
        move    #-1.5707963268,d2.s
$label(zdone)
        move    #0.971899,d6.s
        move    #-0.191848,d7.s
        fmpy.s  d3,d3,d1
        fmpy.s  d1,d7,d0
        fadd.s  d6,d0
        fmpy.s  d0,d3,d0
        fsub.s  d0,d2
        move    d2.s,$ref(output)
	}

	go {
		addCode(asinblock);
	}
}
