static const char file_id[] = "CG96Domain.cc";
/**********************************************************************
Version identification:
@(#)CG96Domain.cc	1.6	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  J. T. Buck
 Date of creation: 7/23/92

 A device to produce the correct portholes, wormholes, event horizons,
 etc, for the CG96 domain so the interpreter can generate them dynamically.

***********************************************************************/

#include "Domain.h"
#include "CG96Target.h"
#include "SDFWormhole.h"
#include "KnownTarget.h"
#include "AsmForkNode.h"

extern const char CG96domainName[] = "CG96";

class CG96Domain : public Domain {
public:
	// cannot do a wormhole with CG96 outside yet, no newWorm

	// new fromUniversal EventHorizon
	EventHorizon& newFrom() {
		LOG_NEW; return *new SDFfromUniversal;
	}

	// new toUniversal EventHorizon
	EventHorizon& newTo() {
		LOG_NEW; return *new SDFtoUniversal;
	}

	// new node (geodesic)
	Geodesic& newNode() { LOG_NEW; return *new AsmForkNode;}

	// constructor (also allow AnyAsm stars)
	CG96Domain() : Domain("CG96") {subDomains += "AnyAsm";}
};

// declare a prototype
static CG96Domain proto;

// declare the default Target object

static CG96Target defaultCG96target("default-CG96","vanilla Motorola 96000 processor");

static KnownTarget entry(defaultCG96target,"default-CG96");
