defstar {
	name { RLattice }
	domain { CG96 }
	desc { IIR Lattice Filter }
	version { @(#)CG96RLattice.pl	1.10 12/8/92 }
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 dsp library }
	explanation {
.PP
The star implements a IIR lattice filter,
which is used to synthesize a random process
from white noise given the reflection coefficients.
The coefficients are the reflection coefficients
in the order k(1), k(2), ..., etc.
The white noise is fed into the signalIn \fIsignalIn\fR.
The signalOut \fIsignalOut\fR gives the process;
whereas the signalOut \fIbp\fR gives the
backward prediction error of the process.
.UH BUGS
Currently, there is no check on the magnitude of the
reflection coefficients.
Therefore, the user should limit the reflection coefficients
to have magnitude less than 1.
	}
        seealso { BlockRLattice }
	input {
		name {signalIn}
		type {float}
	}
	output {
		name {signalOut}
		type {float}
	}
	output {
		name {bp}
		type {float}
	}
	state {
		name {reflectionCoefs}
		type {FLOATARRAY}
		default {"0.1 0.2 0.3 0.4"}
		desc { Filter tap values. }
		attributes { A_NONCONSTANT|A_YMEM }
	}
	state {
		name {oldsample}
		type {floatarray}
		default {0}
		desc {internal}
                attributes { A_NONCONSTANT|A_NONSETTABLE|A_XMEM|A_NOINIT }
	}
        state {
                name {reflectionCoefsNum}
	        type {int}
	        default {8}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    
	codeblock(block) {
; state variable buffer for $fullname()
        org     $ref(oldsample)
        bsc     $val(reflectionCoefsNum),0
        org     p:
        }
        codeblock(one) {
        move    $ref(signalIn),d4.s
        move    $ref(oldsample),d3.s
        move    $ref(reflectionCoefs),d0.s
        fmpy.s  d3,d0,d2
        fsub.s  d2,d4
        fmpy.s  d4,d0,d1
        fadd.s  d3,d1
        move    d4.s,$ref(oldsample)
        move    d1.s,$ref(bp)
        move    d4.s,$ref(signalOut)
        }
        codeblock(two) {
        move    #>$addr(reflectionCoefs)+1,r0
        move    #<$addr(oldsample),r4
        move    $ref(signalIn),d4.s
        move    x:(r4)+,d3.s    y:(r0)-,d0.s
        fmpy.s  d3,d0,d2
        fsub.s  d2,d4
        fmpy.s  d4,d0,d1        x:(r4)-,d5.s    y:(r0)-,d6.s
        fmpy    d5,d6,d2        fadd.s  d3,d1
        move    d1.s,$ref(bp)
        fsub.s  d2,d4
        fmpy.s  d4,d6,d1
        fadd.s  d5,d1
        move    d1.s,x:(r4)+
        move    d4.s,x:(r4)+
        move    d4.s,$ref(signalOut)
        }    
        codeblock(greater) {
        move    #>$val(reflectionCoefsNum)+$addr(reflectionCoefs)-1,r0
        move    #<$addr(oldsample),r4
        move    #2,n4
        move    $ref(signalIn),d4.s
        move    x:(r4)+,d3.s    y:(r0)-,d0.s
        fmpy.s  d3,d0,d2
        fsub.s  d2,d4
        fmpy.s  d4,d0,d1
        fadd.s  d3,d1   x:(r4)-,d3.s    y:(r0)-,d0.s
        move    d1.s,$ref(bp)
        fmpy.s  d3,d0,d2
        fsub.s  d2,d4   y:(r0)-,d6.s
        do      #$val(reflectionCoefsNum)-2,$label(loop)
        fmpy.s  d4,d0,d1        x:(r4+n4),d5.s
        fmpy    d5,d6,d2        fadd.s  d3,d1   d6.s,d0.s       y:(r0)-,d6.s
        fsub.s  d2,d4   d1.s,x:(r4)+    d5.s,d3.s
$label(loop)
        fmpy.s  d4,d0,d1
        fadd.s  d3,d1
        move    d1.s,x:(r4)+
        move    d4.s,x:(r4)+
        move    d4.s,$ref(signalOut)
        }
	setup {
              reflectionCoefsNum=reflectionCoefs.size();
              oldsample.resize(reflectionCoefsNum);
        }
        initCode {
               addCode(block);
        }
       	go {
               if(reflectionCoefsNum==1) addCode(one);
	       else if(reflectionCoefsNum==2) addCode(two);
	       else addCode(greater);
        }
	execTime {
               int a;
              
               if(reflectionCoefsNum>2) a=15+3 * int(reflectionCoefsNum);
	       else if(reflectionCoefsNum==2) a=18;
	       else a=16;

	       return a;
        }
}
