defstar {
	name { Lattice }
	domain { CG96 }
	desc { FIR Lattice Filter }
	version { @(#)CG96Lattice.pl	1.10 12/8/92 }
	author { Chih-Tsung Huang }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 dsp library }
	explanation {
.PP
The star implements a FIR lattice filter.
The coefficients are the reflection coefficients
in the order k(1), k(2), ..., etc.
The process is fed into the signalIn \fIsignalIn\fR.
The output \fIfp\fR gives the
forward prediction error of the process;
whereas the output \fIbp\fR gives the
backward prediction error of the process.
.UH BUGS
Currently, there is no check on the magnitude of the
reflection coefficients.
Therefore, the user should limit the reflection coefficients
to have magnitude less than 1.
	}
        seealso { RLattice }
	input {
		name {signalIn}
		type {float}
	}
	output {
		name {fp}
		type {float}
	}
	output {
		name {bp}
		type {float}
	}
	state {
		name {reflectionCoefs}
		type {FLOATARRAY}
		default {"0.1 0.2 0.3 0.4"}
		desc { Filter tap values. }
		attributes { A_NONCONSTANT|A_YMEM }
	}
	state {
		name {oldsample}
		type {floatarray}
		default {0}
		desc {internal}
                attributes { A_NONCONSTANT|A_NONSETTABLE|A_XMEM|A_NOINIT }
	}
        state {
                name {reflectionCoefsNum}
	        type {int}
	        default {4}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }	    


	codeblock(block) {
; state variable buffer for $fullname()
        org     $ref(oldsample)
        bsc     $val(reflectionCoefsNum),0
        org     p:
        }

        codeblock(one) {
; number of reflectionCoefs: $val(reflectionCoefsNum) for $fullname()
        move    $ref(signalIn),d0.s
        move    $ref(oldsample),d1.s
        move    d0.s,$ref(oldsample)
        move    $ref(reflectionCoefs),d4.s
        fmpy.s  d0,d4,d3
        fmpy.s  d1,d4,d2
        fadd.s  d3,d1
        fadd.s  d2,d0
        move    d0.s,$ref(fp)
        move    d1.s,$ref(bp)
        }
        codeblock(greater) {
; number of reflectionCoefs: $val(reflectionCoefsNum) for $fullname()
        move    #<$addr(oldsample),r4
        move    #>$addr(reflectionCoefs),r2
        move    $ref(signalIn),d0.s
        ftfr.s  d0,d1   x:(r4),d5.s     y:(r2)+,d4.s
        do      #$val(reflectionCoefsNum),$label(loop)
        fmpy.s  d0,d4,d1        d1.s,x:(r4)+
        fmpy    d5,d4,d2        fadd.s  d5,d1
        fadd.s  d2,d0   x:(r4),d5.s     y:(r2)+,d4.s
$label(loop)
        move    d0.s,$ref(fp)
        move    d1.s,$ref(bp)
        }
	setup {
              reflectionCoefsNum=reflectionCoefs.size();
              oldsample.resize(reflectionCoefsNum);
        }


        initCode {
               addCode(block);
        }
        
	go {
               if(reflectionCoefsNum==1)
	            addCode(one);
	       else
	            addCode(greater);
        }
	execTime {
              
               if(reflectionCoefsNum>1)
	            return 9+3 * int(reflectionCoefsNum);
	       else 
                    return 10;
        }
}

