defstar {
	name { LMS }
	domain { CG96 }
	desc { Least mean square (LMS) adaptive filter. }
	version { @(#)CG96LMS.pl	1.9  12/8/92 }
	author { Chih-Tsung Huang, ported from Gabriel }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 dsp library }
        explanation {
.PP
This star implements an adaptive FIR filter using the LMS algorithm,
according to the following equations:
.EQ
delim $$
.EN
.nf
                                          $y~=~c~*~x$
                                          $e~=~(~{y hat}~-~y~)$
                                $c[n+1]~=~c[n]~+~stepSize~cdot~x~cdot~e$
.fi
.PP
where "x" is the input vector; "c", the coefficient vector;
"e", the input error; "y", the output; and
"$y hat$", the desired output.
Note that the error equation assumes a positive \fIstepSize\fR, and that
the error must be calculated outside of this star.
Be careful with the sign of the error!
.PP
Note that the number of initial coefficients determines "N",
the order of the filter.
.PP
The \fIstepSize\fR parameter specifies the rate of adaptation.
.PP
The \fIerrorDelay\fR specifies the relative delay between the output
samples and the input error samples.  There must be at least
a delay of one (you must add the delay in your system) because
the path from the output to the error forms a closed feedback loop.
You can insert more delays if you wish (you may have to decrease
the stepSize to keep the algorithm stable), but be sure to
adjust the \fIerrorDelay\fR parameter accordingly.
.PP
The \fIdecimation\fR parameter specifies how many input samples to
consume before firing the star.
Note that this downsampling could also be performed by following the
\fICG96LMS\fR star with a \fICG96Downsample\fR star.
However, the \fICG96LMS\fR star would then calculate samples, only to have
many of them immediately discarded by the \fICG96Downsample\fR star.
Using the \fIdecimation\fR ability in the complex LMS filter is
exactly equivalent, except that the discarded samples are never computed.
.PP
For decimation, the sample that is taken is controlled
by the parameter \fIdecimationPhase\fR.
If \fIdecimationPhase\fR = 0, the most recent sample is the output;
while if \fIdecimationPhase\fR = \fIdecimation\fR-1,
the oldest sample is the output.
.PP
Interpolation is not supported.
.PP
}
        seealso { Downsample, FIR }        
        output {
		name { output }
		type { float }
	}
        input  {
                name { input }
	        type { float }
	}
        input  {
                name { error }
	        type { float }
	}
        state  {
                name { stepSize }
                type { float }
                default { 0.01 }
                desc { specifies the rate of adaptation }
        }
	state {
		name { errorDelay }
		type { int }
		desc {
specifies the relative delay between the output samples and the input
error samples.
                }
		default { 1 }
	}
	state {
		name { decimation }
		type { int }
		desc { number of input samples consumed before firing. }
		default { 1 }
	}
	state {
		name { decimationPhase }
		type { int }
		desc { phase change }
		default { 0 }
	}
        state {
                name { coef }
                type { floatarray }
                desc { internal }
                default { "0.1 0.2 0.3 0.4" }
                attributes { A_NONCONSTANT|A_XMEM }
        }
        state {
                name { coefLen }
                type { int }
                desc { number of coef. }
                default { 4 }
                attributes { A_NONSETTABLE|A_NONCONSTANT }
        }        

        state {
                name { Y }
                type { int }
                desc { internal }
                default { 0 }
                attributes { A_NONSETTABLE|A_NONCONSTANT }
        }        

        state {
                name { loopVal }
                type { int }
                desc { internal }
                default { 0 }
                attributes { A_NONSETTABLE|A_NONCONSTANT }
        }            

        state {
                name { delayLine }
                type { intarray }
                desc { internal }
                default { 0 }
                attributes {A_CIRC|A_NONCONSTANT|A_NONSETTABLE|A_YMEM|A_NOINIT}
        }
        state {
                name { delayLineStart }
	        type { int }
                desc { internal }
                default { 0 }
                attributes { A_NONCONSTANT|A_NONSETTABLE|A_YMEM|A_NOINIT }
	}
        state {
                name { delayLineSize }
                type { int }
                desc { internal }
                default { 0 }
                attributes { A_NONCONSTANT|A_NONSETTABLE }
        }

        codeblock(std) {
; adapt coefficients
        move    #$val(coefLen)+$addr(coef)-1,r2
        move    $ref(delayLineStart),r6
        move    #$val(Y),m6
        move    #$val(stepSize),d0.s
        move    $ref(error),d2.s
        fmpy.s  d0,d2,d6
        move    r2,r4
        move    x:(r2)-,d0.s    y:(r6)+,d4.s
        fmpy.s  d6,d4,d2
        }

        codeblock(loop) {
        do      #$val(coefLen)-1,$label(endloop)
        fadd.s  d0,d2   x:(r2)-,d0.s    y:(r6)+,d4.s
        fmpy.s  d6,d4,d2        d2.s,x:(r4)-
$label(endloop)
        }

        codeblock(noloop) {
        fadd.s  d0,d2   x:(r2)-,d0.s    y:(r6)+,d4.s
        fmpy.s  d6,d4,d2        d2.s,x:(r4)-
        }
        codeblock(cont) {
        fadd.s  d0,d2
        move    d2.s,x:(r4)-
; move current inputs into delay_line.
        move    #$addr(input),r0
        move    $ref(delayLineStart),r6
        move    #>$val(decimationPhase)+1,n6
        }

        codeblock(decimationGreaterthanOne) {
        do      #$val(decimation),$label(decimationloop)
        move    x:(r0)+,d0.s
        move    d0.s,y:(r6)+
$label(decimationloop)
        move    r6,$ref(delayLineStart)
        }

        codeblock(decimationOne) {
        move    x:(r0)+,d0.s
        move    d0.s,y:(r6)+
        move    r6,$ref(delayLineStart)
        }

        codeblock(cont1) {
; compute output.
        move    #<$addr(coef),r2
        fclr    d0.s    y:(r6)-n6,d4.s
        fclr    d2.s    x:(r2)+,d6.s    y:(r6)-,d4.s
        }
        codeblock(reps) {
        rep     #$val(coefLen)-1
        fmpy    d4,d6,d2        fadd.s  d2,d0   x:(r2)+,d6.s    y:(r6)-,d4.s
        fmpy    d4,d6,d2        fadd.s  d2,d0
        fadd.s  d2,d0
        move    d0.s,$ref(output)
        move    #-1,m6
        }

        codeblock(noreps) {
        fmpy.s  d4,d6,d0
        move    d0.s,$ref(output)
        move    #-1,m6
        }
       
        codeblock(makeblock) {
; delayLine memory
        org     $ref(delayLine)
        bsc     $val(delayLineSize),0
        org     p:
        }
      
        codeblock(delaystart) {
; pointer to delay line into memory
        org     $ref(delayLineStart)
        dc      $addr(delayLine)
        org     p:
        }
        setup {
                coefLen=coef.size();
            	delayLineSize=coefLen+int(decimation)*int(errorDelay-1)+decimationPhase;
		delayLine.resize(delayLineSize);
                input.setSDFParams(int(decimation),int(decimation)-1);

	        if (delayLineSize == 1)
        	      Error::abortRun(*this, "One tap LMS requires more than one error delay.");

        }
        initCode  {
	        addCode(makeblock);
                addCode(delaystart);
        }
        go { 
                Y=coefLen-1+int(decimation)*int(errorDelay-1)+decimationPhase;
	        addCode(std);
	
        	if(coefLen>1) {
	            addCode(loop);
		}
		else addCode(noloop);

	        addCode(cont);
      	
		if(decimation>1)
	            addCode(decimationGreaterthanOne);
		else
	            addCode(decimationOne);
	    
	        addCode(cont1);

		if(coefLen>1)
        	     addCode(reps);
		else
        	     addCode(noreps);
        }             
	execTime { 
              int a;
              if (coefLen>1) {
                   if (int(decimation)<=1)
                         a= (27+int(coefLen)*3+int(decimation)*2);
                   else
                         a= (26+int(decimation)*2);
              }
              return a;
        }
}
