defstar {
	name { BlockRLattice }
	domain { CG96 }
	desc { Block IIR Lattice Filter }
	version { @(#)CG96BlockRLattice.pl	1.9 12/8/92 }
	author { Chih-Tsung Huang, ported from gabriel }
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 dsp library }
	explanation {
.PP
This star implements an IIR lattice filter with coefficients
that are periodically updated from the outside.
The IIR lattice filter is used to synthesize a random process
from white noise given the AR model parameters.
The \fIblockSize\fR parameter tells how often the updates occur.
It is an interger specifying how many signalIn samples
should be processed using each set of coefficients.
The \fIorder\fR parameter tells how many coefficients there are.
	}
        seealso { IIRLattice }
	input {
		name {signalIn}
		type {float}
	}
	input {
		name {coefs}
		type {float}
	}
        output {
		name {signalOut}
		type {float}
	}
	output {
		name {bp}
		type {float}
	}
	state {
		name {constant}
		type {floatarray}
		default {"0"}
		desc {internal}
                attributes { A_NONCONSTANT|A_NONSETTABLE|A_YMEM|A_NOINIT }
	}
	state {
		name {oldsample}
		type {floatarray}
		default {"0"}
		desc {internal}
                attributes { A_NONCONSTANT|A_NONSETTABLE|A_XMEM|A_NOINIT }
	}
        state {
                name {blockSize}
	        type {int}
	        default {128}
                desc { Number of inputs that use each each coefficient set. }
        }
        state {
                name {order}
	        type {int}
	        default {16}
                desc { Number of new coefficients to read each time. }
        }


	codeblock(block) {
; coefficients for $fullname()
        org     $ref(constant)
        bsc     $val(order),0
        org     p:

; state variable buffer for $fullname()
        org     $ref(oldsample)
        bsc     $val(order),0
        org     p:
        }

        codeblock(one) {
        move    #<$addr(signalIn),r1
        move    #<$addr(signalOut),r2
        move    #>$addr(bp),r3
; update coefficients
        move    $ref(coefs),d0.s
; compute signalOut
        do      #$val(blockSize),$label(blkLoop)
        move    x:(r1)+,d4.s
        move    $ref(oldsample),d3.s
        fmpy.s  d3,d0,d2
        fsub.s  d2,d4
        fmpy.s  d4,d0,d1
        fadd.s  d3,d1
        move    d4.s,$ref(oldsample)
        move    d1.s,x:(r3)+
        move    d4.s,x:(r2)+
$label(blkLoop)
        }
        codeblock(two) {
        move    #<$addr(signalIn),r1
        move    #<$addr(signalOut),r2
        move    #>$addr(bp),r3
; update coefficients
        move    $ref(coefs),d6.s
        move    $ref2(coefs,1),d0.s
; compute signalOut
        move    #>$addr(oldsample),r4
        do      #$val(blockSize),$label(blkLoop)
        move    x:(r1)+,d4.s
        move    x:(r4)+,d3.s
        fmpy.s  d3,d0,d2
        fsub.s  d2,d4
        fmpy.s  d4,d0,d1        x:(r4)-,d5.s
        fmpy    d5,d6,d2        fadd.s  d3,d1
        fsub.s  d2,d4   d1.s,x:(r3)+
        fmpy.s  d4,d6,d1
        fadd.s  d5,d1
        move    d1.s,x:(r4)+
        move    d4.s,x:(r4)-
        move    d4.s,x:(r2)+
$label(blkLoop)
        }    
        codeblock(greater) {
        move    #<$addr(signalIn),r1
        move    #<$addr(signalOut),r2
        move    #>$addr(bp),r3
; update coefficients
        move    #<$addr(constant),r0
        move    #>$addr(coefs),r5
        do      #$val(order),$label(coefLoop)
        move    x:(r5)+,d0.s
        move    d0.s,y:(r0)+
$label(coefLoop)
; compute signalOut
        do      #$val(blockSize),$label(blkLoop)
        move    #>$addr(constant)+$val(order)-1,r0
        move    #>$addr(oldsample),r4
        move    #2,n4
        move    x:(r1)+,d4.s
        move    x:(r4)+,d3.s    y:(r0)-,d0.s
        fmpy.s  d3,d0,d2
        fsub.s  d2,d4
        fmpy.s  d4,d0,d1
        fadd.s  d3,d1   x:(r4)-,d3.s    y:(r0)-,d0.s
        move    d1.s,x:(r3)+
        fmpy.s  d3,d0,d2
        fsub.s  d2,d4   y:(r0)-,d6.s
        do      #$val(order)-2,$label(loop)
        fmpy.s  d4,d0,d1        x:(r4+n4),d5.s
        fmpy    d5,d6,d2        fadd.s  d3,d1   d6.s,d0.s       y:(r0)-,d6.s
        fsub.s  d2,d4   d1.s,x:(r4)+    d5.s,d3.s
$label(loop)
        fmpy.s  d4,d0,d1
        fadd.s  d3,d1
        move    d1.s,x:(r4)+
        move    d4.s,x:(r4)+
        move    d4.s,x:(r2)+
$label(blkLoop)
        }
	setup {
              constant.resize(order);
              oldsample.resize(order);
              signalIn.setSDFParams(blockSize, blockSize-1);
              coefs.setSDFParams(order,order-1);        
              signalOut.setSDFParams(blockSize, blockSize-1);
              bp.setSDFParams(blockSize, blockSize-1);
        }

        initCode {
               addCode(block);
        }
        
	go {
               if(order==1)
	               addCode(one);
	       else if(order == 2)
	               addCode(two);
               else
	               addCode(greater);
        }    

	execTime {

               if(order>2)
	            return 7+(2*int(order))+(int(blockSize)*(15+3*int(order)));
	       else if (order==2)
	            return 12*int(blockSize) + 9;
               else
	            return 9*int(blockSize) + 6;
        }
}
