defstar {
	name { BlockFIR }
	domain { CG96 }
	desc { An FIR filter with coefficients externally supplied. }
	version { @(#)CG96BlockFIR.pl	1.8 12/8/92 }
	author { Chih-Tsung Huang, ported from Gabriel}
        acknowledge { Gabriel version by Anthony Wong }
	copyright {
Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.
See the file ~ptolemy/copyright for copyright notice,
limitation of liability, and disclaimer of warranty provisions.
	}
	location { CG96 dsp library }
	explanation {
.PP
This star implements an FIR filter with coefficients
that are periodically updated from the outside.
The \fIblockSize\fR parameter tells how often the updates occur.
It is an interger specifying how many input samples
should be processed using each set of coefficients.
The \fIorder\fR parameter tells how many coefficients there are.
.PP
The parameters \fIdecimation\fR and \fIinterpolation\fR enable this star
to perform downsampling or upsampling.
Only one of these 2 parameters can be set to greater than 1.
.PP
For decimation, the sample that is taken is controlled
by the parameter \fIdecimationPhase\fR.
If \fIdecimationPhase\fR = 0, the most recent sample is the output;
while if \fIdecimationPhase\fR = \fIdecimation\fR-1,
the oldest sample is the output.
	}
        seealso { FIR }
	input {
		name {signalIn}
		type {float}
	}
	input {
		name {coefs}
		type {float}
	}
        output {
		name {signalOut}
		type {float}
	}
        state {
                name {blockSize}
	        type {int}
	        default {128}
                desc { Number of inputs that use each each coefficient set. }
        }
        state {
                name {order}
	        type {int}
	        default {8}
                desc { Number of new coefficients to read each time. }
        }
        state {
                name {decimation}
                type {int}
                default {1}
                desc { Decimation ratio.}
        }
        state {
                name {decimationPhase}
                type {int}
                default {0}
                desc {Downsampler phase.}
        }
        state {
                name {interpolation}
                type {int}
                default {1}
                desc {Interpolation ratio.}
        }

	state {
		name {constant}
		type {floatarray}
		default {"0"}
		desc {internal}
                attributes { A_NONCONSTANT|A_NONSETTABLE|A_YMEM|A_NOINIT }
	}
	state {
		name {oldsample}
		type {floatarray}
		default {"0"}
		desc {internal}
                attributes {A_CIRC|A_NONCONSTANT|A_NONSETTABLE|A_XMEM|A_NOINIT}
	}
	state {
		name {oldsampleStart}
		type {int}
		default {0}
		desc {internal}
                attributes {A_NONCONSTANT|A_NONSETTABLE|A_XMEM|A_NOINIT}
	}
        state {
                name {index}
                type {int}
                default {0}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }
        state {
                name {modtemp}
                type {int}
                default {0}
                desc { internal }
                attributes {A_NONCONSTANT|A_NONSETTABLE}
        }
	codeblock(block) {
; state variable buffer for $fullname()
        org     $ref(oldsample)
        bsc     $val(index),0
        org     p:
    
; pointer to state variable buffer for $fullname()

        org     $ref(oldsampleStart)
        dc      $addr(oldsample)
        org     p:
        }

        codeblock(first) {
        move    #<$addr(signalOut),r6
        }
        codeblock(greater) {      
; update coefficients
        move    #<$addr(constant),r0
        move    #>$addr(coefs),r2
        do      #$val(order),$label(coefLoop)
        move    x:(r2)+,d4.s
        move    d4.s,y:(r0)+
$label(coefLoop)
; compute output
        move    #<$addr(signalIn),r2
        move    #<$val(order)-2,m4
        do      #$val(blockSize),$starSymbol(outloop)
        move    #<$addr(constant)+$val(order)-1,r0
        move    $ref(oldsampleStart),r4
        }
        codeblock(indexG) {
        do      #$val(index),$label(L1)
        move    x:(r2)+,d8.s
        move    d8.s,x:(r4)+
$label(L1)
        }
        codeblock(greaterCont) {
        move    x:(r2)+,d8.s
        fclr    d2
        fclr    d0      x:(r4)+,d4.s    y:(r0)-,d6.s
        rep     #$val(order)-2
        fmpy    d4,d6,d2        fadd.s d2,d0    x:(r4)+,d4.s    y:(r0)-,d6.s
        fmpy    d4,d6,d2        fadd.s d2,d0    y:(r0)-,d6.s
        fmpy    d8,d6,d2        fadd.s d2,d0    d8.s,x:(r4)+
        fadd.s  d2,d0
        }
        codeblock(dP) {
        do      #$val(decimationPhase),$label(L2)
        move    x:(r2)+,d8.s
        move    d8.s,x:(r4)+
$label(L2)
        }
        codeblock(greaterCont1) {
        move    r4,$ref(oldsampleStart)
        move    d0.s,x:(r6)+
$starSymbol(outloop)
        move    m7,m4
        }
        codeblock(two) {
; update coefficients
        move    $ref(coefs),d4.s
        move    d4.s,$ref(constant)
        move    $ref2(coefs,1),d4.s
        move    d4.s,$ref(constant)+1
; compute output
        }
        codeblock(d) {
        move    #<$addr(signalIn)+$val(index)+$val(decimation)-1,r2
        }
        codeblock(nod) {
        move    #<$addr(signalIn)+1,r2
        }
        codeblock(twocont) {
        move    #<$val(decimation)-1,n2
        move    #<$addr(constant)+1,r0
        move    $ref2(signalIn,index),d8.s
        }
        codeblock(indexG1) {
        move    x:$addr(signalIn)+$val(index)-1,d4.s
        }
        codeblock(indexL) {
        move    $ref(oldsample),d4.s
        }
        codeblock(d1) {
        do      #$val(blockSize),$label(outloop)
        move    y:(r0)-,d6.s
        fmpy.s  d4,d6,d2        y:(r0)+,d6.s
        fmpy.s  d8,d6,d0        x:(r2)+,d4.s
        fadd.s  d2,d0   x:(r2)+n2,d8.s
        move    d0.s,x:(r6)+
$label(outloop)
        }
        codeblock(nod1) {
        do      #$val(blockSize),$label(outloop)
        move    y:(r0)-,d6.s
        fmpy.s  d4,d6,d2        y:(r0)+,d6.s
        fmpy.s  d8,d6,d0        d8.s,d4.s
        fadd.s  d2,d0   x:(r2)+,d8.s
        move    d0.s,x:(r6)+
$label(outloop)
        }
        codeblock(indexZ) {
        move    d4.s,$ref(oldsample)
        }
        codeblock(orderOne) {
; update coefficients
        move    $ref(coefs),d6.s
; compute output
        move    #<$addr(signalIn)+$val(index),r2
        move    #<$val(decimation),n2
        do      #$val(blockSize),$label(outloop)
        move    x:(r2)+n2,d8.s
        fmpy.s  d8,d6,d0
        move    d0.s,x:(r6)+
$label(outloop)
        }
        codeblock(greaterI) {
; update coefficients
        move    #>$val(index),n0
        move    #>$addr(constant)+$val(interpolation),d0.l
        move    #>$addr(coefs),r2
        }
        codeblock(loop) {
        do      #$val(index),$label(coefLoop)
        move    d0.l,r0
        do      #$val(interpolation),$label(L1)
        move    x:(r2)+,d6.s
        move    d6.s,y:(r0)-n0
$label(L1)
        inc     d0.l
$label(coefLoop)
        }
        codeblock(loopminus) {
        do      #$val(index)-1,$label(coefLoop)
        move    d0.l,r0
        do      #$val(interpolation),$label(L1)
        move    x:(r2)+,d6.s
        move    d6.s,y:(r0)-n0
$label(L1)
        inc     d0.l
$label(coefLoop)
        }

        codeblock(modloop) {
        move    d0.l,r0
        do      #$val(modtemp),$label(L2)
        move    x:(r2)+,d6.s
        move    d6.s,y:(r0)-n0
$label(L2)
        }
        codeblock(std) {
        move    #$addr(signalIn),r2
; compute output
        move    #<$val(index)-2,m4
        do      #$val(blockSize),$label(outloop)
        move    #>$val(index)*$val(interpolation)+$addr(constant)-1,r0
        move    $ref(oldsampleStart),r4
        move    x:(r2)+,d8.s
        fclr    d2
        fclr    d0      x:(r4)+,d4.s    y:(r0)-,d6.s
        do      #$val(interpolation)-1,$label(L3)
        rep     #$val(index)-1
        fmpy    d4,d6,d2        fadd.s  d2,d0   x:(r4)+,d4.s    y:(r0)-,d6.s
        fmpy    d8,d6,d2        fadd.s  d2,d0   y:(r0)-,d6.s
        fadd.s  d2,d0
        fclr    d0      d0.s,x:(r6)+
        fclr    d2
$label(L3)
        rep     #$val(index)-2
        fmpy    d4,d6,d2        fadd.s  d2,d0   x:(r4)+,d4.s    y:(r0)-,d6.s
        fmpy    d4,d6,d2        fadd.s  d2,d0   y:(r0)-,d6.s
        fmpy    d8,d6,d2        fadd.s  d2,d0   d8.s,x:(r4)+
        fadd.s  d2,d0
        move    r4,$ref(oldsampleStart)
        move    d0.s,x:(r6)+
$label(outloop)
        move    m7,m4
        }
        codeblock(twoi) {
; update coefficients
        move    #>$val(index),n0
        move    #>$addr(constant)+$val(interpolation),r0
        move    #>$addr(coefs),r2
        }
        codeblock(loopi) {
        do      #$val(interpolation),$label(coefLoop)
        move    x:(r2)+,d6.s
        move    d6.s,y:(r0)-n0
$label(coefLoop)
        move    #>2*$val(interpolation)-1+$addr(constant),r0
        }
        codeblock(iloop) {
        do      #$val(interpolation),$label(L1)
        move    x:(r2)+,d6.s
        move    d6.s,y:(r0)-n0
$label(L1)
        }
        codeblock(mloop) {
        do      #$val(modtemp),$label(L1)
        move    x:(r2)+,d6.s
        move    d6.s,y:(r0)-n0
$label(L1)
        }
        codeblock(std1) {
        move    #>$addr(signalIn),r2
; compute output
        move    $ref(oldsample),d4.s
        do      #$val(blockSize),$starSymbol(outloop)
        move    #>2*$val(interpolation)+$addr(constant)-1,r0
        fclr    d2      x:(r2)+,d8.s
        fclr    d0      y:(r0)-,d6.s
        fmpy.s  d4,d6,d2        y:(r0)-,d6.s
        fmpy    d8,d6,d2        fadd.s  d2,d0   y:(r0)-,d6.s
        fadd.s  d2,d0
        }
        codeblock(twoiG) {
        do      #$val(interpolation)-2,$label(L2)
        fmpy.s  d4,d6,d2        d0.s,x:(r6)+    y:(r0)-,d6.s
        fclr    d0
        fmpy    d8,d6,d2        fadd.s d2,d0    y:(r0)-,d6.s
        fadd.s  d2,d0
$label(L2)
        }
        codeblock(std2) {
        fmpy.s  d4,d6,d2        d0.s,x:(r6)+    y:(r0)-,d6.s
        fclr    d0
        fmpy    d8,d6,d2        fadd.s  d2,d0
        fadd.s  d2,d0   d8.s,d4.s
        move    d0.s,x:(r6)+
$starSymbol(outloop)
        move    d4.s,$ref(oldsample)
        }
        codeblock(one) {
; update coefficients
        move    #>$addr(constant)+$val(interpolation)-1,r0
        move    #>$addr(coefs),r2
        }
        codeblock(oneI) {
        do      #$val(interpolation),$label(coefLoop)
        move    x:(r2)+,d0.s
        move    d0.s,y:(r0)-
$label(coefLoop)
        }
        codeblock(oneM) {
        do      #$val(modtemp),$label(coefLoop)
        move    x:(r2)+,d0.s
        move    d0.s,y:(r0)-
$label(coefLoop)
        }
        codeblock(oneCont) {
        move    #>$addr(signalIn),r2
; compute output
        do      #$val(blockSize),$label(outloop)
        move    #>$addr(constant)+$val(interpolation)-1,r0
        move    x:(r2)+,d8.s
        move    y:(r0)-,d6.s
        fmpy.s  d8,d6,d0        y:(r0)-,d6.s
        rep     #$val(interpolation)-2
        fmpy.s  d8,d6,d0        d0.s,x:(r6)+    y:(r0)-,d6.s
        fmpy.s  d8,d6,d0        d0.s,x:(r6)+
        move    d0.s,x:(r6)+
$label(outloop)
        }

	setup {
              int i= interpolation;
	      int d= decimation;
  
              if(decimation >1 && interpolation >1) {
                    Error::abortRun(*this,
				    "Cannot both interpolate and decimate.");
	            return;
	      }	    
              constant.resize(int(double(interpolation)*
				  double((ceil(double(order)
					       /double(interpolation)) ) )));
	      if(order!=1) 
		oldsample.resize(int(ceil((double(order)-1)/
					double(interpolation))));

              signalIn.setSDFParams(d*int(blockSize),d*int(blockSize)-1);
              coefs.setSDFParams(int(order), int(order) - 1);
              signalOut.setSDFParams(i*int(blockSize),i*int(blockSize)-1);
        }

        initCode {
              if(oldsample.size()>0) {
                    index=oldsample.size();
	            addCode(block);
	      }
        }
        
// 2 cases, each with 3 subcases
//
// 1. (interpolation = 1)
//      a. order > 2
//      b. order = 2
//      c. order = 1
// 2. (interpolation > 1)
//      a. order > 2
//      b. order = 2
//      c. order = 1
// Register usage

// d0.s total sum
// d2.s one product term
// d4.s one oldsample / oldsample-input for decimation case
// d6.s one tap value
// d8.s input

// r0   pointer to tap value
// r2   pointer to coefs_input / pointer to input
// r4   pointer to oldsample
// r6   pointer to output

// m4   circular buffer size for oldsample

	go {
		modtemp= order%interpolation;

		addCode(first);

		if(interpolation==1) {

		index=decimation -decimationPhase -1;
			if(order>2) {
				addCode(greater);
				if(index>0)
					addCode(indexG);
				addCode(greaterCont);
				if(decimationPhase>0)
					addCode(dP);
				addCode(greaterCont1);
			}
			else if(order==2) {
				addCode(two);
				if(decimation>1)
					addCode(d);
				else
					addCode(nod);
				addCode(twocont);
				if(index>0)
					addCode(indexG1);
				else
					addCode(indexL);
				if(decimation>1)
					addCode(d1);
				else
					addCode(nod1);
				if(index==0)
					addCode(indexZ);
			}
			else
				addCode(orderOne);
		}
		else {

			index=int(ceil((double(order)/double(interpolation))));
			const int temp=interpolation;
			if(index>2) {
				interpolation = int(int(index)*int(temp-1));
				addCode(greaterI);
				interpolation=temp;
				if(modtemp==0)
					addCode(loop);
				else
					addCode(loopminus);
				if(modtemp!=0)
					addCode(modloop);
				addCode(std);
			}
			else if(index==2) {
				interpolation = int(2*int(temp-1));
				addCode(twoi);
				interpolation = temp;
				addCode(loopi);

				if(modtemp==0)
					addCode(iloop);
				else
					addCode(mloop);
				addCode(std1);
				if(interpolation>2)
					addCode(twoiG);
				addCode(std2);
			}
			else {
				addCode(one);
				if(modtemp==0)
					addCode(oneI);
				else
					addCode(oneM);
				addCode(oneCont);
			}
		}
	
        }       

	execTime {
		int eftaps=int(order/interpolation);

		if(interpolation== 1) {
			if(order> 2) {
				if (decimation> 1)
					return (12+(2*int(order))+
					       (9+int(order))*int(blockSize));
				else
					return (12+(2*int(order))+
						(11+int(order)+
						2*int(decimation))*
						int(blockSize));
				} 		       
				else if (order==2) 
					return 17+5*int(blockSize);
				else
					return 7+3*int(blockSize);
		}
		else {
			if(eftaps> 2) 
				return (13+4*int(eftaps)+2*int(order)+
					((eftaps+4)*
					int(interpolation)+9)*int(blockSize));
			else if (eftaps==2)
				return (18+2*int(order)+
					(6+4*int(interpolation))*
					int(blockSize));
			else
			return  (10+2*int(order)+(6+interpolation)*
				 int(blockSize));
		}
	}
}
