static const char file_id[] = "IntArray.cc";

/*****************************************************************
Version identification:
@(#)IntArray.cc	1.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

Programmer: Soonhoi Ha
Date of last revision: 

*****************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "IntArray.h"
#include "Error.h"
#include "StringList.h"

// dynamic creation of an integer array

void IntArray::create(int n) {
	
	if (n > memSz) {
		LOG_DEL; delete data;
		LOG_NEW; data = new int[n];
		memSz = n;
	}
	sz = n;
	initialize();		// initialize the array
}

int& IntArray :: elem (int index) {
	if (index >= memSz || index < 0) {
		StringList out;
		out += "index ";
		out += index;
		out += " is out of range.";
		Error :: abortRun (out);
		return data[0];
	} 
	return data[index];
}

// destructor
IntArray::~IntArray() { 
	LOG_DEL; delete data;
	data = 0;
}
