#ifndef _CGForScheduler_h
#define _CGForScheduler_h 1
#ifdef __GNUG__
#pragma interface
#endif

#include "CGConScheduler.h"
#include "For.h"

/**************************************************************************
Version identification:
@(#)CGForScheduler.h	1.2	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha

 Scheduler for "For" construct.

**************************************************************************/

class CGDDFWormhole;

class CGForScheduler : public CGConScheduler, public For {

public:
	// read the statistics on the number of iteration steps.
	int getStatistics(Target*);

	// download the code
	void downLoadCode(int, Target*, Profile*);

	// constructor
	CGForScheduler():body(0), worm(0) { For :: createSchedule(); }

protected:
	// redefine
	int examine(Galaxy& galaxy);
	int closerExamine();
	// redefine
	void initMembers();
	int setProfile(int, int, Profile*);

	// assume execution time
	int assumeExecTime();

	// add control codes to the profile, and return the cost of the codes.
	int addControlCodes(int,Profile*);

	// virtual methods to be filled for specific targets
	virtual const char* controlCode() const;
	virtual const char* syncCode() const;

private:
	double calcCost(int, int);	  // compute the optimal total cost.
	double costInGeometric(int, int); // in Geometric dist.
	double costInUniform(int, int);   // in Uniform dist.
	double costInGeneral(int, int);   // in General dist.
	int adjustX(int,int,int,int);	  // adjust "x" value.

	Profile* body;		 // profile of the iteration body.
	CGDDFWormhole* worm;
	
};

#endif
