#ifndef _CGDDFWormhole_h
#define _CGDDFWormhole_h 1
#ifdef __GNUG__
#pragma interface
#endif

#include "CGDDFStar.h"
#include "DDFWormhole.h"
#include "MultiTarget.h"
#include "Profile.h"

/*******************************************************************
 SCCS Version identification :
 @(#)CGDDFWormhole.h	1.6	11/25/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer : Soonhoi Ha
 Date of Creation : 5/21/91
	
********************************************************************/

// CGDDFWormhole can not contain a timed-domain. It may contain another
// type of CGDDFdomain.

	//////////////////////////////
	// CGDDFWormhole
	//////////////////////////////

class CGDDFWormhole : public Wormhole, public CGDDFStar {

private:
        // number of processors devoted to the star, which is 1 for
        // atomic star, but can be > 1 for Wormholes.
        int numProcs;
	int prevNum;

        // execution profile of the wormhole, presumably a dynamic construct.
        // profiles for varying number of assigned processors.
        Profile* profile;

	// multiTarget pointer
	MultiTarget* mtarget;

public:
	void setup();
		       
	void go();
	void wrapup() { target->wrapup(); }

	CGDDFWormhole* myWormhole();

	// Constructor
	CGDDFWormhole(Galaxy& g, Target* t);
	~CGDDFWormhole();

	// return my scheduler
	Scheduler* scheduler() const { return target->scheduler() ;}

	// return my profile
	Profile* myProfile() { return profile; }

	// display schedule
	StringList displaySchedule() { return target->displaySchedule(); }

	// get the total work
	int getTotalWork() { return (mtarget)? mtarget->totalWorkLoad():0; }
	int getNumProcs()  { return numProcs; }
	void setNumProcs(int i)  { numProcs = i; }

	// print method
	StringList print(int verbose = 0) const {
		return Wormhole::print(verbose);
	}

	// clone -- allows interpreter/pigi to make copies
	Block* clone() const;

	// identify myself as a wormhole
	int isItWormhole() const { return TRUE;}

	// use statelist for inner galaxy for stateWithName
	State* stateWithName (const char* name) {
		return gal.stateWithName(name);
	}
	
	// state initialize
	void initState() { gal.initState() ;}

        // set the "numProcs" member and initialize Profiles.
        void assignProcs(int num);

	// sort the parallel schedule with finish time.
	void insideSchedule() { if(mtarget) mtarget->insideSchedule(); }

	// compute the profile
	void insideSchedule(int n, int w, IntArray* a) {
		if(mtarget) mtarget->computeProfile(n, w, a);
	}

	// download code
	void downLoadCode(int);

	// FIXME: what should this do?
	double getStopTime() { return 0.0;}
};

// for now:
#define CGDDFtoUniversal DDFtoUniversal
#define CGDDFfromUniversal DDFfromUniversal
	
#endif
