static const char file_id[] = "CGDDFStar.cc";

/******************************************************************
Version identification:
@(#)CGDDFStar.cc	1.5	12/10/92

Copyright (c) 1990, 1991, 1992 The Regents of the University of California.
All rights reserved.

Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the above
copyright notice and the following two paragraphs appear in all copies
of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY 
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES 
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF 
THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF 
SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.
							COPYRIGHTENDKEY

 Programmer:  Soonhoi Ha

*******************************************************************/

#ifdef __GNUG__
#pragma implementation
#endif

#include "CGDDFStar.h"
#include "CGDDFWormhole.h"
#include "CGTarget.h"

/*******************************************************************

	class CGDDFStar methods

********************************************************************/

// Output a text line of code, raw, to the target architecture
void CGDDFStar :: addCode (const char* code, const char* stream, 
	const char* name) {
	CodeStream* c;
	if (stream == NULL) c = myTarget()->getStream("code");
	else if (c = myTarget()->getStream(stream)) {
		c->put(code, name);
	} else {
		Error::abortRun(*this, " unknown stream: ", stream);
	}
}

CGDDFWormhole* CGDDFStar :: myWormhole() { return NULL; }

// The following is defined in CGDDFDomain.cc -- this forces that module
// to be included if any CGDDF stars are linked in.
extern const char CGDDFdomainName[];

const char* CGDDFStar :: domain () const { return CGDDFdomainName;}

// isa
ISA_FUNC(CGDDFStar, DDFStar);
