;************************************************************************
;
;       EQUATES for DSP96000 interrupts
;
;       Reference: DSP96000 User's Manual, Figure 8-6, Interrupt Sources
;
;************************************************************************
;

intequ  ident   1,0
						
i_reset	EQU	$00000000   	; Hardware RESET
i_stack	EQU	$00000002   	; Stack Error
i_ilint	EQU	$00000004	; Illegal Instruction
i_trap	EQU	$00000006   	; (F)TRAPcc (default)
i_irqa	EQU	$00000008   	; IRQA
i_irqb	EQU	$0000000A   	; IRQB
i_irqc	EQU	$0000000C   	; IRQC

i_dma1	EQU	$00000010	; DMA Channel 1
i_dma2	EQU	$00000012	; DMA Channel 2

i_hacmd	EQU	$0000001C	; Host A Command (default)
i_hbcmd	EQU	$0000001E	; Host B Command (default)

i_hard	EQU	$00000020	; Host A Receive Data
i_hatd	EQU	$00000022	; Host A Transmit Data
i_harxm EQU	$00000024	; Host A Read X Memory 
i_harym EQU	$00000026	; Host A Read Y Memory
i_harpm EQU	$00000028	; Host A Read P Memory
i_hawxm EQU	$0000002A	; Host A Write X Memory 
i_hawym EQU	$0000002C	; Host A Write Y Memory
i_hawpm EQU	$0000002E	; Host A Write P Memory

i_hbrd	EQU	$00000030	; Host B Receive Data
i_hbtd	EQU	$00000032	; Host B Transmit Data
i_hbrxm EQU	$00000034	; Host B Read X Memory 
i_hbrym EQU	$00000036	; Host B Read Y Memory
i_hbrpm EQU	$00000038	; Host B Read P Memory
i_hbwxm EQU	$0000003A	; Host B Write X Memory 
i_hbwym EQU	$0000003C	; Host B Write Y Memory
i_hbwpm EQU	$0000003E	; Host B Write P Memory
