# Configuration makefile to make on DecStation with g++2.1.
# @(#)config-mips.mk	1.9 12/1/92
# Copyright (c) 1991 The Regents of the University of California.
#                       All Rights Reserved.
#		       
# Programmer:  J. T. Buck

# Each makefile must define ROOT, the relative position of the root
# of the directory tree, and include this file.
# ARCH is assumed set to, say, "sun4", "sun3", or "vax".

# Full path to the ~ptolemy directory (you may need to change this
# for your installation)
PTOLEMY_FULL_PATH = /usr/users/ptolemy

# To enable memory logging, define the following symbol as -DMEMORYLOG.
# To disable it, define it as empty.
MEMLOG = -DMEMORYLOG

# C++ compiler to use
GNU = g++
# flags for C++ compilation.  We don't bother with -g because debugging
# still has problems.
GPPFLAGS = -G 0 $(MEMLOG)
# flags for C compilation
CFLAGS = -G 0

# command to use when getting files from SCCS (Gnu make)
GET=safe-get

# command to generate dependencies (cfront users can try CC -M)
DEPEND=g++ -MM

# where libraries are (and where to install them)
LIBDIR=$(ROOT)/lib.$(ARCH)
# where to install binaries
BINDIR=$(ROOT)/bin.$(ARCH)
# Ptolemy kernel directory
KERNDIR=$(ROOT)/src/kernel

# linker to use for pigi and interpreter.
LINKER=g++
# system libraries (libraries from the environment)
SYSLIBS=-lg++ -lm
# linker options.
# -N is needed on mips to make incremental linking work
LINKFLAGS=-L$(LIBDIR) -G 0 -N
# link flags if debugging symbols are to be left (same in this case, no -g)
LINKFLAGS_D=-L$(LIBDIR) -G 0 -N

# where help files go
HELPDIR=~ptolemy/lib

# root of Octtools
OCTTOOLS = $(ROOT)/octtools
# Oct libraries
OCTLIBDIR = $(OCTTOOLS)/lib.$(ARCH)

# default place to move documentation generated by ptlang.
STARDOCDIR = ../doc/stars

# If the X11 include directories are in /usr/include/X11, leave
# the following symbol blank.  Otherwise define it as "-Idir" where
# dir is the PARENT of the include directory, which must end in X11.
X11INCL=-I$(ROOT)/src/compat

# If the X11 libraries are not on the standard library search path,
# define the following symbol as "-Ldir" where dir is the directory
# containing them.  Otherwise leave it blank.
X11LIBDIR=


# LX11 is normally just -lX11, but some vendors (e.g. DEC) have put
# this library somewhere else, e.g. -lX11-mit.
LX11 = -lX11-mit

# LXEXT is normally just -lXext, but some vendors (e.g. DEC) have put
# this library somewhere else, e.g. -lXext-mit.
LXEXT = -lXext-mit

TCL_ROOT=$(ROOT)/tcl

# Directory containing Tcl/Tk include files
TCL_H_DIR=$(TCL_ROOT)/include

# Directory containing Tcl/Tk libraries
TCL_LIBDIR=$(TCL_ROOT)/lib.$(ARCH)
