#include "p4.h"
#include "p4_sys.h"

int create_remote_processes(pg)
struct p4_procgroup *pg;
{
    struct p4_procgroup_entry *pe;
    int i, rm_num = 1;

    for (i = 0, pe = pg->entries; i < pg->num_entries; i++, pe++)
    {
	if (strcmp(pe->host_name, "local") != 0)
	{
	    create_one_remote(pe, rm_outfile_head, rm_num++);
	}
    }

    return (0);
}

P4VOID create_one_remote(pe, outfile, rm_num)
struct p4_procgroup_entry *pe;
char *outfile;
int rm_num;
{
    int rm_fd;
    struct bm_rm_msg msg;
    P4BOOL done;
    int type;
    int status, port, remote_switch_port;
    int slave_idx, slave_pid, pidx, rm_ind;

    rm_fd = net_create_slave(pe->host_name,
			     pe->slave_full_pathname,
			     pe->username);

    msg.type = p4_i_to_n(INITIAL_INFO);
    msg.numinproctab = p4_i_to_n(p4_global->num_in_proctable);
    msg.numslaves = p4_i_to_n(pe->numslaves_in_group);
    strcpy(msg.outfile, outfile);
    msg.rm_num = p4_i_to_n(rm_num);
    msg.debug_level = p4_i_to_n(remote_debug_level);
    msg.memsize = p4_i_to_n(globmemsize);
    msg.logging_flag = p4_i_to_n(logging_flag);
    strcpy(msg.application_id, p4_global->application_id);
    strcpy(msg.version, p4_version());
    strcpy(msg.pgm, pe->slave_full_pathname);

    net_send(rm_fd, &msg, sizeof(msg), FALSE);

    port = -1;
    pidx = -1;
    for (done = FALSE; !done;)
    {
	status = net_recv(rm_fd, &msg, sizeof(msg));
	if (status == PRECV_EOF)
	{
	    p4_dprintf("OOPS! got EOF in create_one_remote\n");
	    return;
	}


	type = p4_n_to_i(msg.type);
	switch (type)
	{
	  case REMOTE_LISTENER_INFO:
	    port = p4_n_to_i(msg.port);
	    break;

	  case REMOTE_MASTER_INFO:
	  case REMOTE_SLAVE_INFO:
	    if (type == REMOTE_MASTER_INFO)
	       rm_ind = TRUE;
	    else
	       rm_ind = FALSE;
	    slave_idx = p4_n_to_i(msg.slave_idx);
	    slave_pid = p4_n_to_i(msg.slave_pid);
	    remote_switch_port = p4_n_to_i(msg.switch_port);
	    if (port == -1)
		p4_dprintf("OOPS! got slave_info w/o getting port first\n");
	    /* big master installing remote processes */
	    pidx = install_in_proctable(rm_num,port,slave_pid,
					msg.host_name,slave_idx,
					msg.machine_type,remote_switch_port);
            p4_dprintfl(90, "create_one_remote: adding connection: %d --> %d\n",
		        p4_get_my_id(), pidx);

            if (p4_local->conntab[pidx].type == CONN_REMOTE_SWITCH)
            {
	        p4_local->conntab[pidx].switch_port = remote_switch_port;
	        p4_local->conntab[pidx].port = rm_fd;
            }
            else if (p4_local->conntab[pidx].type == CONN_REMOTE_NON_EST)
            {
		if (type == REMOTE_MASTER_INFO)
		{
	            p4_local->conntab[pidx].type = CONN_REMOTE_EST;
	            p4_local->conntab[pidx].port = rm_fd;
		    p4_local->conntab[pidx].same_data_rep =
			same_data_representation(p4_local->my_id,pidx);
		}
            }
            else
            {
	        p4_error("create_one_remote: invalid conn type in conntab\n",
		         p4_local->conntab[pidx].type);
            }
	    break;

	  case REMOTE_SLAVE_INFO_END:
	    done = TRUE;
	    break;
	}
    }

}


/*
 *	Run the slave pgm on host; returns the file descriptor of the
 *	connection to the slave.
 */
int net_create_slave(host, pgm, username)
char *host;
char *pgm;
char *username;
{
    int serv_port, serv_fd;
    int slave_fd;
    int slave_pid, master_pid;
    char hostname[100];
    struct net_initial_handshake hs;
    char myhost[100];
    int connection_fd, success, rc;
    struct net_message_t msg;
    char remote_shell[64];
    char serv_port_c[64];
    char *am_slave_c = "-amp4slave";
#if defined(SYMMETRY) || defined(SUN) || \
    defined(DEC5000)  || defined(SGI) || \
    defined(RS6000)
    char *getpw();
#endif

    net_setup_anon_listener(5, &serv_port, &serv_fd);

    myhost[0] = '\0';
    get_qualified_hostname(myhost);

    /* try to connect to (secure) server */

#if defined(SYMMETRY) || defined(SUN) || \
    defined(DEC5000)  || defined(SGI) || \
    defined(RS6000)

    /*****  secure server stuff  *******/
    p4_dprintfl(20, "trying to create remote slave on %s via server\n",host);
    rc = start_slave(host, username, pgm, serv_port, am_slave_c, getpw);

    if (rc < -1)
    {
	extern char *start_prog_error;

	p4_dprintf("Error with secure server: %s\n", start_prog_error);
    }
    else if (rc == 0)
        p4_dprintfl(10, "created remote slave on %s via server\n",host);
    /*****************************************/
#else
    rc = -1;
#endif

    if (rc <= -1)
    {
	/* try to connect to (old) server */
	connection_fd = net_conn_to_listener(host, UNRESERVED_PORT, 1);

	if (connection_fd >= 0)
	{
	    p4_dprintfl(20, "creating remote slave on %s via old server\n",host);
	    msg.type = p4_i_to_n(NET_EXEC);
	    strcpy(msg.pgm, pgm);
	    strcpy(msg.host, myhost);
	    strcpy(msg.am_slave, am_slave_c);
	    msg.port = p4_i_to_n(serv_port);
	    net_send(connection_fd, &msg, sizeof(msg), FALSE);
	    net_recv(connection_fd, &msg, sizeof(msg));

	    success = p4_n_to_i(msg.success);
	    if (!success)
	    {
		p4_dprintf("create failed: %s\n", msg.message);
		return (-1);
	    }
	    close(connection_fd);
	    p4_dprintfl(10, "created remote slave on %s via old server\n",host);
	}
	else
	{
#if defined(DELTA)
	    p4_dprintf("delta cannot create remote processes\n");
#else
	    p4_dprintfl(20, "creating remote slave on %s via remote shell\n",host);
#ifdef P4BSD
	    strcpy(remote_shell, "rsh");
#endif

#ifdef P4SYSV
#    if defined(TITAN) || defined(SGI)
	    strcpy(remote_shell, "rsh");
#    else
#        if defined(SYMMETRY_PTX)
	    strcpy(remote_shell, "resh");
#        else
	    strcpy(remote_shell, "remsh");
#        endif
#    endif
#endif

	    sprintf(serv_port_c, "%d", serv_port);
	    rc = fork_p4();
	    if (rc == 0)
	    {
		rc = execlp(remote_shell, remote_shell,
			    host, "-l", username, "-n", pgm,
			    myhost, serv_port_c, am_slave_c, 0);
		/* host,"-n","cluster","5",pgm,myhost,serv_port_c,0); for butterfly */
		if (rc < 0)
		    p4_error("net_create_slave: execlp", rc);
	    }
	    p4_dprintfl(10, "created remote slave on %s via remote shell\n",host);
#endif
	}
    }
    slave_fd = net_accept(serv_fd);
    close(serv_fd);

    hs.pid = (int) htonl(getpid());
    net_send(slave_fd, &hs, sizeof(hs), FALSE);
    net_recv(slave_fd, &hs, sizeof(hs));
    slave_pid = (int) ntohl(hs.pid);

    return slave_fd;
}
