/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#ifndef _ringh_
#define _ringh_

#include "array.h"

/*--- values which may be modified, subject to certain constraints ---*/

#define LARGE_PRIME 31991

#ifdef SUN
#define NVARS   512
#else
#define NVARS	100	/* number of variables total which are allowed */
#endif

/*--- private types ---*/
#ifndef _iring_

typedef char * ring ;
typedef char * term ;

#endif
/*--- visible types ---*/

typedef int expterm[NVARS] ;
typedef int bigterm[NVARS] ;
typedef unsigned long allocterm[NVARS] ;

/*--- routines involving rings ---*/

extern rgInstall() ;
extern rgKill() ;
extern ring rgCreate() ;
extern ring rgScan() ;
extern rgDisplay() ;
extern rgPut() ;

/*--- variables defined after doing "rgInstall" ---*/

extern char **varnames ;/* names of all vars in current ring, 0..numvars-1 */
extern int numvars ;	/* number of variables in current ring */
extern int nblocks ;	/* number of variable blocks in current ring */
extern term zerodegs ;
extern dlist rgDegs ;	/* degrees of each variable 1..numvars */

extern int   charac ;
extern char *headStash ;
extern char *monStash ;
extern char *parenStash ;
extern char *pStash ;

/*--- routines involving monomials (terms) ---*/

#endif
