

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:gf2n.h>
#include <LiDIA:gf2nIO.h>
#else
#include <LiDIA/gf2n.h>
#include <LiDIA/gf2nIO.h>
#endif


ostream & operator << (ostream & out_strm, const gf2n & a)
{
  bigint h(0);
  char *s;
  int i;
  long k;

  if (a.is_reduced() == false)
    partial_reduce2[gf2n::invsel](a.element);

  for (i=gf2n::anzBI-1; i>=0; i--)  /* convert gf2n element into bigint */
    {

      shift_left(h, h, 8*sizeof(udigit));
      add(h, h, (bigint) a.element[i]);
    }
  
  if (gf2nIO::ioprefix != NULL)
    out_strm << gf2nIO::ioprefix << ':' ;

  s = new char[h.bit_length()];

  switch (gf2nIO::iobase)
    {
    case gf2nIO::Hex :
      
      if (h.is_zero())
	out_strm << '0';
      else
	{
	  i = 0;
	  while (!h.is_zero())
	    {
	      remainder(k, h, 16);
	      shift_right(h, h, 4);
	      if (k < 10)
		s[i++] = (char) ((long)'0'+ k);
	      else
		s[i++] = (char) ((long) 'a' + k - 10);
	    }
	  for(k=i-1; k>=0; k--)
	    out_strm << s[k];
	}
      break;
      
    case gf2nIO::Dec :
      if (h.is_zero())
	out_strm << '0' ;
      else
	{
	  i = 0;
	  while (!h.is_zero())
	    {
	      remainder(k, h, 10);
	      divide(h, h, 10);
	      s[i++] = (char)((long) '0' + k);
	    }
	  for(k=i-1; k>=0; k--)
	    out_strm << s[k];
	}
      break;
	 
    default: 
      lidia_error_handler("gf2n","<<(...)::wrong base");
      break;
    }
delete[] s;
return out_strm;
}






