//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995, 1996 by the LiDIA Group
//
// File        : cast_appl.cc
// Author      : Stefan Neis (SN)

/*
$Id: cast_appl.c,v 1.3 1997/01/24 09:46:58 neis Exp $
*/

#include <LiDIA/polynomial.h>

main()
{
  polynomial <bigint> A,B;

  polynomial <bigcomplex> C;

  cout << "\n input a polynomial <bigint>: "<<flush;
  cin >> A;
  cout << "\n input another polynomial <bigint>: "<<flush;
  cin >> B;

  cout <<"\n Number of real roots of "<<A<<" is "
       <<no_of_real_roots(A)<<flush;
  cout << "\n gcd is "<<gcd(A,B)<<flush;
  cout << "\n gcd over bigcomplex is "<<gcd(polynomial <bigcomplex> (A),
					    polynomial <bigcomplex> (B));
  cout <<flush;

  bigcomplex * zeros = new bigcomplex[A.degree()+1];

  roots (A, zeros);
  cout << "\n Zeros of "<< A <<"are :"<<endl;
  for (long int i = 0; i< A.degree(); i++)
    cout <<"\n\t"<<zeros[i];
  cout << "\n input a polynomial <bigcomplex>: "<<flush;
  cin >> C;
  cout << "(" << A << ") * (" << C <<") =  "<< A * C;
}
