#include <stdio.h>
#include <pixrect/pixrect_hs.h>
#include "vort.h"

#define	CMAPSIZE	256

extern	char	*rindex();


/*
 * program to read in a image and display it on the sun
 */
main(ac, av)
	int	ac;
	char	**av;
{
	char		*myname, buf[BUFSIZ], groups[PIXPG_24BIT_COLOR + 1];
	int		i, j, x, y;
	unsigned short	h, w, wreal, w2;
	int		d, line_bytes, upsidedown;
	u_char		*line, *red, *green, *blue;
	u_char		*p, *pp;
	Pixrect		*pr, *screen;
	image		*im;

        if ((myname = rindex(av[0],'/')) == NULL)
                myname = av[0];
        else
                *myname++;

	if (ac < 2 || ac > 4) {
		fprintf(stderr, "%s: usage %s [-u] file.\n", myname, myname);
		exit(1);
	}

	upsidedown = 0;

	strcat(buf, "/dev/fb");

	for (i = 1; i < ac && *av[i] == '-'; i++) {
		if (strncmp(av[i], "-d", 2) == 0) {	/* frame buffer */
			strcpy(buf, av[++i]);
		} else if (strncmp(av[i], "-u", 2) == 0) {	/* show image upside down */
			upsidedown = 1;
		}
	} 

	if ((im = openimage(av[i], "r")) == (image *)NULL) {
		fprintf(stderr, "%s: can't open file %s.\n", myname, av[i]);
		exit(1);
	}

        if ((myname = rindex(av[i],'/')) == NULL)
                myname = av[i];
        else
                *myname++;

	w = imagewidth(im);
	h = imageheight(im);

        w2 = w;
	if ((i = w % 4) != 0)
		w2 = (w / 4 + i) * 4;


	if ((screen = pr_open(buf)) == (Pixrect *)NULL) {
		fprintf(stderr, "Couldn't open %s\n", buf);
		exit(1);
	}

	pr_available_plane_groups(screen, PIXPG_24BIT_COLOR + 1, groups);

	if (groups[PIXPG_24BIT_COLOR] != 0) {
		fprintf(stderr, "Board supports 24 bit colour.\n");
		d = 32;
	} else {
		fprintf(stderr, "Board supports 8 bit colour.\n");
		d = 8;
	}
	
	if ((pr = mem_create(w2, h, d)) == (Pixrect *)NULL) {
		fprintf(stderr, "Couldn't allocate Pixrect\n");
		exit(1);
	}


	line_bytes = mpr_linebytes(w2, d);
	p = (unsigned char *)mpr_d(pr)->md_image; /* Start of Pixrect */

	x = screen->pr_size.x / 2 - w / 2;
	y = screen->pr_size.y / 2 - h / 2;

	if (d == 32) {
		red = (u_char *)malloc(w);
		green = (u_char *)malloc(w);
		blue = (u_char *)malloc(w);
		while (readrgbline(im, red, green, blue)) {
			pp = p;
			for (i = 0; i < w; i++) {
				*pp++ = 0;
				*pp++ = blue[i];
				*pp++ = green[i];
				*pp++ = red[i];
			}
			if (upsidedown)
				p -= line_bytes;
			else
				p += line_bytes;
		}

		pr_set_plane_group(screen, PIXPG_OVERLAY);
		pr_rop(screen, 0, 0, screen->pr_size.x, screen->pr_size.y, PIX_SRC | PIX_COLOR(0), 0, 0, 0);
	
		pr_set_plane_group(screen, PIXPG_24BIT_COLOR);
		pr_rop(screen, 0, 0, screen->pr_size.x, screen->pr_size.y, PIX_SRC | PIX_COLOR(0), 0, 0, 0);

		pr_set_plane_group(screen, PIXPG_OVERLAY_ENABLE);
		pr_rop(screen, 0, 0, screen->pr_size.x, screen->pr_size.y, PIX_SRC | PIX_COLOR(0), 0, 0, 0);
		pr_set_plane_group(screen, PIXPG_24BIT_COLOR);

	} else {
		if (colormapped(im)) {
			pr_putcolormap(screen, 0, cmapsize(im), redmap(im), greenmap(im), bluemap(im));
			line = (u_char *)malloc(w);

			while(readmappedline(im, line)) {
				pp = p;
				for (i = 0; i < w; i++)
					*pp++ = line[i];

				if (upsidedown)
					p -= line_bytes;
				else
					p += line_bytes;
			}
		} else {
			if (w < CMAPSIZE) {
				red = (u_char *)malloc(CMAPSIZE);
				green = (u_char *)malloc(CMAPSIZE);
				blue = (u_char *)malloc(CMAPSIZE);
			} else {
				red = (u_char *)malloc(w);
				green = (u_char *)malloc(w);
				blue = (u_char *)malloc(w);
			}

			for (i = 0; i < CMAPSIZE; i++) 
				red[i] = green[i] = blue[i] = i;

			pr_putcolormap(screen, 0, cmapsize(im), redmap(im), greenmap(im), bluemap(im));
			while(readrgbline(im, red, green, blue)) {
				pp = p;
				for (i = 0; i < w; i++)
					 *pp++ = (u_char)(red[i] * 0.3 + green[i] * 0.59 + blue[i] * 0.11);
				if (upsidedown)
					p -= line_bytes;
				else
					p += line_bytes;
			}
		}
	}

	pr_rop(screen, x, y, w, h, PIX_SRC, pr, 0, 0);

	getchar();

	exit(0);
}
