#include <stdio.h>
#include <math.h>
#ifdef VMS
#include <types.h>
#else
#include <sys/types.h>
#endif
#ifdef MSC
#include <fcntl.h>
#include <string.h>
#define rindex strrchr
#else
#ifdef SYSV
#include <fcntl.h>
#else
#ifdef VMS
#include <file.h>
#else
#include <sys/file.h>
#endif
#endif
#endif
#ifdef VMS
#include <string.h>
#define rindex strrchr
#endif
#ifdef MIPS
#include <string.h>
#define rindex strrchr
#endif
#ifdef TIME_STATS
#include <sys/times.h>
#endif
#include "art.h"
#include "objs.h"
#include "macro.h"
#include "gram.h"
#include "random.h"

extern char    *rindex();
extern hlist   *trace();
extern void     shade();
extern time_t   time();

extern object  *treeinit();

#ifndef VMS
FILE           *logfile = stdout;
#else
FILE           *logfile;
#endif

int             linecount;	/* line counter for parser */

object         *oblist;		/* object list */
object         *treeobjs, *otherobjs;	/* bsp-able and non-bsp-able objects */

light          *lights;		/* lights list */

symbol         *ostack[STACKSIZE],	/* object def stack */
              **ostackp;

attr            astack[STACKSIZE],	/* attribute stack */
		*astackp;

mats            mstack[STACKSIZE],	/* transformation stack */
        	*mstackp;

char	*title;		/* title of picture */

char	currentfile[MESLEN];	/* name of current "input" file */

int	perspective = TRUE;	/* projection - perspective or orthographic */
int	raysperpix = 1;		/* number of rays per pixel */
int	maxhitlevel = 6;	/* max number of rays traced in reflection */
long	filetype = PIX_RLE;	/* output file format */

short           raynumber = 1;	/* initial raynumber */

float           screenx = 1.0,	/* half screen width */
                screeny = 1.0;	/* half screen height */

int             maxtreedepth = 35;	/* max depth for kd tree */

int             pixelgrid = FALSE;

/*
 * ambient colour and background pixel stuff
 */
colour          ambient;
colour          backcol = {0.0, 0.0, 0.0};

/*
 * light falloff
 */
float           falloff = 0.0;

/*
 * global refractive index
 */
float           ri = 1.0;

/*
 * pointer to the free list for hit structures
 */
hlist          *fhlist;

/*
 * details for the primary rays
 */
vector          org;

vector          up = {0.0, 1.0, 0.0};

float           focallength = -1.0;

matrix          trans = {
	1.0, 0.0, 0.0, 0.0,
	0.0, 1.0, 0.0, 0.0,
	0.0, 0.0, 1.0, 0.0,
	0.0, 0.0, 0.0, 1.0
};

/* 
 * shadow ray flag
 */
int	shadow_rays = FALSE;

/*
 * shading stack
 */
shadedata      *sstack, *sstackp;

/*
 * haze stuff
 */
float           fogfactor = 0.0,/* the fog factor */
                rfactor = 0.03;	/* the mysterious "r" factor */


colour          hazecolour = {1.0, 1.0, 1.0};	/* the haze colour */

float           sourceradius;	/* For ripple texture */

/*
 * temporary file pointer
 */
char           *tmpname;

/*
 * random number pointers
 */
float          *randp = randtable, *erandp = &randtable[sizeof(randtable) / sizeof(float)];

/*
 * function pointer tables for intersections, normals, etc...
 */
hlist          *(*intersects[NUM_OBJS]) ();
void            (*normal[NUM_OBJS]) ();
void            (*tilefun[NUM_OBJS]) ();

int	checkbbox[NUM_OBJS];	/* should we check bounding box of this type */
int     selfshadowing[NUM_OBJS];        /* is this object self shadowing? */


/*
 * x, y offsets, scale, and sampleing
 */
static int      xoff, yoff;
static float    xscale, yscale;
static int      ysperpix, xsperpix;

float		tolerance;

/*
 * frame id extension
 */
char           *frameid = "000";
int		frameno = 0;

/*
 * default name
 */
char           *defname = "pic.pix";


/*
 * antialiasing stuff
 */
static int      extrarays,	/* spare rays for jittering */
                totrays;	/* total number of rays per pixel */

static float    averagefactor;	/* number to divide final samples through by */

/*
 * debuging flag.
 */
int	debug;

/*
 * statistics stuff
 */
#ifdef STATS
static int      totnodes;
static int      totleafs;
static int      neverentered;
static int      maxfinaldepth;
static int      maxinleaf;
static int      mininleaf;
static int      emptynodes;
static int      numobjptrs;
#endif

#ifdef TIME_STATS
static float    prev_time;
static time_t   start_time, rprev_time, tstart_time;
static struct tms buffer;
#endif

static int      totobjs;

#include <sys/socket.h>
#include <netinet/in.h>
#include <signal.h>
#include <netdb.h>

/*
 * Networking variables
 */
struct hostent *hp;		/* remote Host information        */
struct servent *sp;		/* Service entry in /etc/services */
struct sockaddr_in us;		/* My socket address              */
struct sockaddr_in them;	/* Client's socket address        */
int             s;		/* socket descriptor for communication             */
int             ls;		/* socket descriptor for listening                 */

#define MY_PORT 4567

/*
 * usage
 *
 *	usage message (a blank).
 */
usage()
{
}


/*
 * main driver
 */
main()
{

#ifdef TIME_STATS
	times(&buffer);
	start_time = buffer.tms_utime + buffer.tms_stime;
#endif

	SetupPortAndFork();
}

server()
{
	int             y, x, preprocess;
	char           *p, name[BUFSIZ], buf[BUFSIZ];
	image          *im;
	FILE           *infile;
	unsigned char  *red, *green, *blue, *alpha;
	int             i, xsize, ysize, xstart, xend, ystart, yend;
	object         *o, *nexto;
	float           k1, k2;
	expression     *e;
	char            talk[BUFSIZ];
	char           *hostname;
	long            linger;
	long            timevar;
	char            filename[15];


	linger = 1;

	/* Lookup information about the remote host */
	hp = gethostbyaddr((char *) &them.sin_addr, sizeof(struct in_addr), them.sin_family);

	if (hp == NULL)		/* No info available, so use inet # */
		hostname = inet_ntoa(them.sin_addr);
	else
		hostname = hp->h_name;

	time(&timevar);
	printf("Request from %s port %u at %s\n", hostname, ntohs(them.sin_port), ctime(&timevar));

	if (setsockopt(s, SOL_SOCKET, SO_LINGER, (char *) &linger, sizeof(long)) == -1) {
		printf(buf, "Connection with %s terminated.\n", hostname);
		exit(1);
	}
	getdata(s, filename, 15);
	strcpy(name, filename);

	getdata(s, &xsize, sizeof(int));
	getdata(s, &ysize, sizeof(int));

#ifndef OLDFOV
	if (xsize > ysize)
		focallength = -(float) xsize / (float) ysize;
	else
		focallength = -(float) ysize / (float) xsize;
#endif

	getdata(s, &preprocess, sizeof(int));

	sourceradius = 100.0;

	mident4(mstack[0].om);
	mident4(mstack[0].vm);
	mstack[0].maxscale = 1.0;
	mstack[0].nscales.x = mstack[0].nscales.y = mstack[0].nscales.z = 1.0;

	astack[0].s = (surface *) smalloc(sizeof(surface));
	astack[0].s->trans.r = astack[0].s->trans.g = 0.0;
	astack[0].s->refl.r = astack[0].s->refl.g = 0.0;
	astack[0].s->falloff = astack[0].s->trans.b = astack[0].s->refl.b = 0.0;
	astack[0].s->c.r = astack[0].s->c.g = astack[0].s->c.b = 1.0;
	astack[0].s->a.r = astack[0].s->a.g = astack[0].s->a.b = 0.0;
	astack[0].s->ri = astack[0].s->kd = 1.0;
	astack[0].s->ks = 0.0;
	astack[0].txtlist = (texture *) NULL;
	astack[0].shadows = TRUE;
	astack[0].slevel = 0;

	mstackp = mstack;
	astackp = astack;
	ostackp = ostack;

	linecount = 1;

	p = rindex(name, '.');

	if (preprocess) {
		strcpy(p, "XXXXXX");
		mktemp(name);

		if ((infile = fopen(name, "w")) == NULL) {
			sprintf(buf, "art: unable to open temporary file %s.\n", name);
			fatal(buf);
		}
		prepro(filename, infile);

		fclose(infile);
	}
	if ((infile = freopen(name, "r", stdin)) == NULL) {
		sprintf(buf, "art: unable to open file %s.\n", name);
		fatal(buf);
	}
	/*
	 * initialise variable symbol table
	 */
	e = (expression *) smalloc(sizeof(expression));
	e->type = EXP_INT;
	e->u.i = 'x';
	defvar("x", e);

	e = (expression *) smalloc(sizeof(expression));
	e->type = EXP_INT;
	e->u.i = 'y';
	defvar("y", e);

	e = (expression *) smalloc(sizeof(expression));
	e->type = EXP_INT;
	e->u.i = 'z';
	defvar("z", e);

	/*
	 * initialise object symbol table
	 */
	defobj("sphere", SPHERE, (details *) NULL);
	defobj("ellipsoid", ELLIPSOID, (details *) NULL);
	defobj("box", BOX, (details *) NULL);
	defobj("torus", TORUS, (details *) NULL);
	defobj("algebraic", ALGEBRAIC, (details *) NULL);
	defobj("cylinder", CYLINDER, (details *) NULL);
	defobj("cone", CONE, (details *) NULL);
	defobj("superquadric", SUPERQUADRIC, (details *) NULL);
	defobj("ring", RING, (details *) NULL);
	defobj("disk", RING, (details *) NULL);
	defobj("geometry", GEOMETRY, (details *) NULL);
	defobj("light", LIGHT, (details *)NULL);
	defobj("polygon", POLYGON, (details *) NULL);

	if (preprocess)
		tmpname = name;
	else
		tmpname = (char *) NULL;

	yyparse();		/* read in model and set oblist */

	if (preprocess)
		unlink(name);

	fclose(infile);		/* get rid of temp file (unlinked above) */

#ifdef TIME_STATS
	printtime("Preprocessing time		:");
#endif

	/*
	 * initialise shade stack
	 */
	sstack = (shadedata *) smalloc(sizeof(shadedata) * maxhitlevel);

	sstack[0].ri = ri;
	sstack[0].falloff = falloff;

	sstackp = sstack;

	treeobjs = otherobjs = (object *) NULL;

	for (o = oblist; o != (object *) NULL; o = nexto) {
		nexto = o->nxt;
		if (o->type == ALGEBRAIC) {
			o->nxt = otherobjs;
			otherobjs = o;
			totobjs++;
		} else if (o->type == NULL_OBJ)
			free(o);
		else {
			o->nxt = treeobjs;
			treeobjs = o;
			totobjs++;
		}
	}

	if (treeobjs != (object *) NULL) {
		oblist = treeinit(treeobjs);

		tolerance = sqrt(sqr(oblist->bb.max[X] - oblist->bb.min[X]) + sqr(oblist->bb.max[Y] - oblist->bb.min[Y]) + sqr(oblist->bb.max[Z] - oblist->bb.min[Z])) / 2.0 * TOLERANCE;

		oblist->nxt = otherobjs;
	} else {
		tolerance = TOLERANCE;
		oblist = otherobjs;
	}

	/*
	 * set up intersection and normal function pointers
	 */
	spheretabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	boxtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	torustabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	cyltabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	conetabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	ellipstabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	geomtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	polytabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	supertabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	ringtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	csgtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	algtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	hfieldtabinit(intersects, normal, tilefun, checkbbox, selfshadowing);
	treetabinit(intersects, normal, tilefun, checkbbox, selfshadowing);

	xoff = xsize / 2;
	yoff = ysize / 2;

	if (xsize > ysize)
		xscale = yscale = ysize / 2;
	else
		xscale = yscale = xsize / 2;

	red = (unsigned char *) smalloc(xsize);
	green = (unsigned char *) smalloc(xsize);
	blue = (unsigned char *) smalloc(xsize);
	alpha = (unsigned char *) smalloc(xsize);

	do {
		getdata(s, &y, sizeof(int));
		if (y != -9) {
			for (x = 0; x != xsize; x++)
				dotrace1(x, y, &red[x], &green[x], &blue[x], &alpha[x]);

			send(s, &y, sizeof(int), 0);
			send(s, red, xsize, 0);
			send(s, green, xsize, 0);
			send(s, blue, xsize, 0);
		}
	} while (y != -9);

#ifdef TIME_STATS
	printtime("Total time taken		:");
#endif

#ifdef STATS
	sprintf(buf, "Total number of objects		: %d\n", totobjs);
	message(buf);

	if (treeobjs != (object *) NULL) {
		mininleaf = totobjs;

		getstats(oblist->obj.tree);

		sprintf(buf, "Total number of tree nodes	: %d\n", totnodes);
		message(buf);
		sprintf(buf, "Number of leaf nodes not entered: %d\n", neverentered);
		message(buf);
		sprintf(buf, "Number of leaf nodes entered	: %d\n", totleafs);
		message(buf);
		sprintf(buf, "Number of object pointers	: %d\n", numobjptrs);
		message(buf);
		sprintf(buf, "Min number of objects in a leaf	: %d\n", mininleaf);
		message(buf);
		sprintf(buf, "Max number of objects in a leaf	: %d\n", maxinleaf);
		message(buf);
		sprintf(buf, "Max depth of a leaf node	: %d\n", maxfinaldepth);
		message(buf);
		sprintf(buf, "Number of empty nodes		: %d\n", emptynodes);
		message(buf);
	}
#endif

	exit(ALLOK);
}

/*
 * gensample
 * 
 * generate a sample value for a given ray
 */
gensample(k1, k2, sample)
	float           k1, k2;
	pixel          *sample;
{
	ray             ir;
	hlist          *hit, *lp, *p;
	float           fact;

	if (perspective) {
		ir.org.x = ir.dir.x = k1;
		ir.org.y = ir.dir.y = k2;

		ir.org.z = 0.0;
		ir.dir.z = focallength;

		normalise(ir.dir);
	} else {
		ir.org.x = k1;
		ir.org.y = k2;
		ir.org.z = 0.0;

		ir.dir.x = 0.0;
		ir.dir.y = 0.0;
		ir.dir.z = -1.0;
	}

	ir.org.x *= screenx;
	ir.org.y *= screeny;

	ir.ri = ri;
	ir.raynumber = raynumber++;

	if ((hit = trace(&ir, oblist)) != (hlist *) NULL) {
		shade(sample, &ir, hit, 0);
		fact = 1.0 / (1.0 + falloff * hit->t);
		sample->r *= fact;
		sample->g *= fact;
		sample->b *= fact;
		sample->a = 1.0;
	} else {
		sample->r = backcol.r;
		sample->g = backcol.g;
		sample->b = backcol.b;
		sample->a = 0.0;
	}

	for (lp = hit; lp != (hlist *) NULL; lp = p) {
		p = lp->nxt;
		release(lp);
	}
}

/*
 * dotrace1
 * 
 * Generate a straight no-nonsense sampling for the image, if you like weird
 * filters and postprocessing this is the one for you!
 */
dotrace1(x, y, r, g, b, a)
	int             x, y;
	unsigned char  *r, *g, *b, *a;
{
	pixel           pix;
	object         *o;

	gensample((x - xoff) / xscale, (y - yoff) / yscale, &pix);

	if (raynumber < 0) {
		for (o = treeobjs; o != (object *) NULL; o = o->nxt)
			o->lastray.raynumber = 0;
		raynumber = 1;
	}
	*r = pix.r * 255.0;
	*g = pix.g * 255.0;
	*b = pix.b * 255.0;
	*a = pix.a * 255.0;
}

#ifdef STATS
/*
 * getstats
 * 
 * calculate the statistics for the kd-tree pointed to by root.
 */
getstats(root)
	stree          *root;
{
	olist          *obs;
	int             count;

	totnodes++;

	if (root->type == SPLITABLELEAF)
		neverentered++;
	else if (root->type == LEAF) {
		if (maxfinaldepth < root->u.leaf.depth)
			maxfinaldepth = root->u.leaf.depth;
		if (root->u.leaf.oblist == (olist *) NULL)
			emptynodes++;
		else {
			count = 0;
			for (obs = root->u.leaf.oblist; obs != (olist *) NULL; obs = obs->nxt)
				count++;
			numobjptrs += count;
			if (mininleaf > count)
				mininleaf = count;
			if (maxinleaf < count)
				maxinleaf = count;
			totleafs++;
		}
	} else {
		getstats(root->u.branch.left);
		getstats(root->u.branch.right);
	}
}
#endif

#ifdef TIME_STATS
/*
 * printtime
 * 
 * print out how much time has been taken up.
 */
printtime(s)
	char           *s;
{
	float           diff;
	time_t          now, real;
	char            buf[BUFSIZ];

	times(&buffer);

	diff = buffer.tms_utime + buffer.tms_stime - start_time;

	sprintf(buf, "%s %.2f seconds.\n", s, diff / 60.0);
	message(buf);
}

#endif

SetupPortAndFork()
{
	int             addrlen;
	char            buf[BUFSIZ];

	/* Clear out for convinence */
	memset((char *) &us, 0, sizeof(struct sockaddr_in));
	memset((char *) &them, 0, sizeof(struct sockaddr_in));

	/* Listen for Internet connections */
	us.sin_family = AF_INET;

	/* Wildcard listen (i.e. any host can attach */
	us.sin_addr.s_addr = INADDR_ANY;

	/* Get port # for /etc/services */
	sp = getservbyname("art", "tcp");
	if (sp == NULL) {
		printf("Cannot find art/tcp in /etc/services. Assuming Port # = %d\n", MY_PORT);
		us.sin_port = MY_PORT;
	} else
		us.sin_port = sp->s_port;

	/* Get a socket */
	ls = socket(AF_INET, SOCK_STREAM, 0);
	if (ls == -1) {
		perror("artd");
		printf("Unable to create listen socket.\n");
		exit(1);
	}
	/* Bind listen address to the socket */
	if (bind(ls, &us, sizeof(struct sockaddr_in)) == -1) {
		perror("artd");
		printf("Unable to bind listen address to socket.\n");
		exit(1);
	}
	/*
	 * Initialize the listen on the socket so that we can accept remote
	 * requests. I used 5 because the manual said so :-)
	 */
	if (listen(ls, 5) == -1) {
		perror("artd");
		printf("Unable to listen on socket.\n");
		exit(1);
	}
	/*
	 * Everything is now setup. So fork the daemon and return to the
	 * user. The setpgrp() is used to disassociate the process from the
	 * terminal. The manual says to do this in the parent because
	 * otherwise, the child would become a process group leader, and we
	 * all know that that's a no-no :-).
	 */

	setpgrp();

	switch (fork()) {
	case -1:
		perror("artd");
		printf("Unable to fork daemon.\n");
		exit(1);
	case 0:		/* child (daemon) */
		/*
		 * Ignore SIGCLD to preven zombies as each child terminates.
		 * Thus, the wait call is not needed.
		 */
		signal(SIGCLD, SIG_IGN);

		/*
		 * Now loop forever processing the damned requests addrlen
		 * will always contain the size of the returned
		 * address...note the &addrelen later on.
		 */
		for (;;) {
			addrlen = sizeof(struct sockaddr_in);

			/* Now we wait until we get a connect request */
			s = accept(ls, &them, &addrlen);
			if (s == -1)
				fatal("Accept died.\n");
			switch (fork()) {
			case -1:
				perror("artd");
				printf("Unable to fork.\n");
				exit(1);
			case 0:/* child */
				/* process connection */
				server();
				exit(0);
			default:	/* parent (daemon) */
				/*
				 * close the connection socket that we got
				 * because only the child uses it.
				 */
				close(s);
			}	/* second fork/switch */
		}		/* infinite for-loop */
	default:		/* Parent..return to user */
		exit(0);
	}
}

getdata(s, buf, n)
	int             s;
	unsigned char  *buf;
	int             n;
{
	int             j, k;

	j = recv(s, buf, n, 0);
	while (j < n) {
		k = recv(s, &buf[j], n - j, 0);
		if (k == -1) {
			printf("Socket recv error.\n");
			exit(1);
		}
		j += k;
	}
}
