/*======================================================================
                    O B J E C T S . M 
                    doc: Fri Sep 13 13:44:22 1991
                    dlm: Wed Nov 20 16:51:55 1991
                    (c) 1991 A.M.J. Thurnherr
                    uE-Info: 99 8 FALSE 0 0 72 2 2 ofnI
======================================================================*/
/* MPL */

#include	<stdio.h>
#include	<mpl.h>
#include	"types.h"
#include	"world.h"
#include	"utilities.h"

void sTri2Tri(st,t)					/* Prepare triangle */
STri st; Tri *t;
{
	t->matId = st.matId;				/* copy common data */
	t->bounded = st.bounded;
	copy3Vec3(st.v,t->v);
	copy3Vec3(st.n,t->n);
}

#define testSet(test,dim,set,comp) \
	if (test[dim] comp set[dim]) set[dim] = test[dim]

#define	setMin(test,set) \
	testSet(test,VX,set,<); \
	testSet(test,VY,set,<); \
	testSet(test,VZ,set,<) \

#define	setMax(test,set) \
	testSet(test,VX,set,>); \
	testSet(test,VY,set,>); \
	testSet(test,VZ,set,>) \

void calcBbox()						/* compute world bBox */
{
	plural Vec3 min,max;

	if (pWorld.triSet > 0) {
		copyVec3(pWorld.t.v[PA],min);
		copyVec3(pWorld.t.v[PA],max);
		setMin(pWorld.t.v[PB],min);
		setMax(pWorld.t.v[PB],max);
		setMin(pWorld.t.v[PC],min);
		setMax(pWorld.t.v[PC],max);
		world.bBox.min[VX] = reduceMind(min[VX]);
		world.bBox.min[VY] = reduceMind(min[VY]);
		world.bBox.min[VZ] = reduceMind(min[VZ]);
		world.bBox.max[VX] = reduceMaxd(max[VX]);
		world.bBox.max[VY] = reduceMaxd(max[VY]);
		world.bBox.max[VZ] = reduceMaxd(max[VZ]);
	}
}	
		
plural void preProcTri(t)				/* Preprocess Triangle */
plural Tri *t;
{
    plural Vec3	AB,AC,tmp;
    plural Fp	dummy,lenXY,lenYZ,lenXZ,dist;

    if (pWorld.triSet > 0) {
	vec3SubVec3(t->v[PB],t->v[PA],AB);
	vec3SubVec3(t->v[PC],t->v[PA],AC);
	vec3CrossVec3(AB,AC,t->planeN);			/* plane normal */
	pNrmVec3(t->planeN,dummy);
	if (vec3Vec3(t->planeN,t->n[PA]) < 0) {		/* wrong side */
		vec3Neg(t->planeN);
	}

	t->planeD = -vec3Vec3(t->planeN,t->v[PA]);	/* distance */

	if (!t->bounded) return;			/* no triangle */

	lenXY = sLen2D(t->planeN,VX,VY);		/* select projection */
	lenYZ = sLen2D(t->planeN,VY,VZ);		/* 4 u/v calc */
	lenXZ = sLen2D(t->planeN,VX,VZ);
	if (lenXY < lenYZ) {
	    if (lenXY < lenXZ) {
	    	t->projC1 = VX;
	    	t->projC2 = VY;
	    } else {
	    	t->projC1 = VX;
	    	t->projC2 = VZ;
	    }
	} else {
	    if (lenYZ < lenXZ) {
	    	t->projC1 = VY;
	    	t->projC2 = VZ;
	    } else {
	    	t->projC1 = VX;
	    	t->projC2 = VZ;
	    }
	}

	if (p_fabs(AB[t->projC1]) < EPS) {  /* swap points */
		copyVec3(AB,tmp);
		copyVec3(AC,AB);
		copyVec3(tmp,AC);
	}
	
	t->ABx = AB[t->projC1];		  /* u/v aux vars */
	t->ABy = AB[t->projC2];
	t->ABydivABx = t->ABy/t->ABx;
	t->ACx = AC[t->projC1];
	t->ACy = AC[t->projC2];

	vec3SubVec3(t->n[PB],t->n[PA],t->dNu);
	vec3SubVec3(t->n[PC],t->n[PA],t->dNv);
    }
}

void allocTris(n)			/* alloc stuff on PEs */
int n;
{
	/*!!!FREE FIRST!!!*/
/*	world.tList = (Tri *)malloc(n*sizeof(Tri)); */
/*	world.nTri = 0; */
}

void distTri(st)			/* distribute simple Triangle */
STri st;
{
/*	sTri2Tri(st,&world.tList[world.nTri++]); */
}

void drawObj(objId)			/* display Obj by distributing it's */
int objId;				/* triangles to all processors */
{
/*	Stri	*tris;
	int	nTris,i;

	nTris = world.oList[objId].nTri;
	tris = world.oList[objId].tList;
/*	allocTris(nTris);		/* alloc PE stuff */
/*	for (i=0; i<nTris; i++)
		distTri(tris[i]);
	for (i=0; i<world.nTri; i++) 
		preProcTri(&world.tList[i]); */
	putchar('B'); fflush(stdout);
	calcBbox();
	putchar('P'); fflush(stdout);
	preProcTri(&pWorld.t);
}
