/* hf.c -- Convert GNUplot data to Heightfield format

	Program by:  Mark Maimone   31-May-92   CMU Computer Science

HISTORY
	13-Sep-92  Mark Maimone (mwm)  Removed site-specfic code.  It still
		only works on 50x50 data though...

	31-May-92  Mark Maimone (mwm)  Created.
*/

#include <stdio.h>

int show_help = 0;

/* INCLUDE PARSE STATE VARIABLES HERE */

char *this_program;

main (argc, argv)
int argc;
char **argv;
{
    this_program = argv[0] ? argv[0] : "";
    ++argv;
    show_help = *argv ? (strncmp (*argv, "-h", 2) == 0) : 0;

    if (show_help) {
	do_show_help ();
	exit (0);
    } /* if (show_help) */

    if (*argv == NULL)
	doit (50, stdin);
    else {
	FILE *fp, *fopen ();

	if ((fp = fopen (*argv, "r")) == NULL)
	    fprintf (stderr, "%s: Couldn't open '%s' for reading\n",
		    this_program, *argv);
	else {
	    doit (50, fp);
	    fclose (fp);
	} /* else*/
    } /* else */
    exit (0);
} /* main */


doit (len, infp)
int len;
FILE *infp;
{
    int i, j;
    FILE *fp, *fopen ();

    write (1, &len, sizeof (int));
    for (i = 0; i < len; i++)
	for (j = 0; j < len; j++) {
	    char s[1000];
	    float f;
	    double atof ();

	    fscanf (infp, "%*s %*s %s\n", s);
	    f = atof (s);
	    write (1, &f, sizeof (float));
	}

} /* doit */


do_show_help ()
{
    fprintf (stderr, "%s:  Convert GNUplot to heightfield\n\n", this_program);
    fprintf (stderr, "***WARNING*** The data is expected to be 50x50!!\n\n");
    fprintf (stderr, "SWITCHES [you can use any unique prefix]:\n");


    fprintf (stderr, "\t-help,?\tShow this HELP message\n");
} /* show_help */
