/*
 * atmosphere.h
 * Revision 4.0  91/07/17  14:40:06  kolb
 * Initial version.
 */
#ifndef ATMOSPHERE_H
#define ATMOSPHERE_H
 
#include "common.h"
 
typedef char * AtmosRef;
 
typedef struct Medium {
	Float	index,			/* Index of refraction */
		statten;		/* specular transmission attenuation */	
	struct Medium *next;
} Medium;
 
typedef struct Atmosphere {
	AtmosRef data;			/* Effect info */
	void	(*method)();		/* Atmosphere method */
	struct Atmosphere *next;	/* Next effect */
} Atmosphere;
 
extern Medium		*MediumPush();
extern Atmosphere	*AtmosCreate(), *AtmosphereCopy();
extern void		Atmospherics();
 
#endif /* ATMOSPHERE_H */
