/** @file html.h
 * HTML output
 * @author Marko Mkel <marko.makela@iki.fi>
 */

/* Copyright  2003,2005 Marko Mkel.

   This file is part of PHOTOMOLO, a program for generating
   thumbnail images and HTML files for browsing digital photographs.

   PHOTOMOLO is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   PHOTOMOLO is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

/** Options for HTML generation */
struct html_opts
{
  /** flag: do not display time stamps for files */
  int notim;
  /** index.html file name */
  const char* html;
  /** index.css file name or URI (optional) */
  const char* css;
  /** "icon" file name or URI (optional) */
  const char* icon;
  /** "shortcut icon" file name or URI (optional) */
  const char* msico;
  /** character set of image comments and HTML */
  const char* charset;
  /** generator information for HTML meta element */
  const char* generator;
};

/** Dump the HTML code
 * @param file	the output stream
 * @param argc	number of command-line arguments
 * @param argv	command-line arguments
 * @param tree	the directory
 * @param level	number of '/' characters in the root directory name
 * @param info	image dimensions
 * @param comm	image comments
 * @param opts	dump options
 * @param thumb	available thumbnail resolutions
 * @param spec	the thumbnail resolution
 * @param top	name of parent directory
 * @param prev	name of previous directory
 * @param next	name of next directory
 * @return	zero on success, nonzero on failure
 */
int
dumphtml (FILE* file,
	  int argc,
	  char** argv,
	  const struct dirtree* tree,
	  unsigned level,
	  const struct imageinfo* info,
	  const struct comment*const* comm,
	  const struct html_opts* opts,
	  const struct thumb_spec* thumb,
	  const struct thumb_spec* spec,
	  const char* top,
	  const char* prev,
	  const char* next);
