/** @file scale.h
 * JPEG image scaling
 * @author Marko Mkel <msmakela@nic.funet.fi>
 */

/* Copyright  2003 Marko Mkel.

   This file is part of PHOTOMOLO, a program for generating
   thumbnail images and HTML files for browsing digital photographs.

   PHOTOMOLO is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   PHOTOMOLO is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

#include "jpeglib.h"

/** Scale a JPEG image
 * @param cin		the image to be scaled
 * @param cout		the output image
 *			(image_width and image_width set to the maximum,
 *			0=unspecified)
 * @param shrink	shrink factor (0=unspecified, 1, 2, 4 or 8)
 * @return		0 on success, nonzero on failure
 */
int
scale_image (struct jpeg_decompress_struct* cin,
	     struct jpeg_compress_struct* cout,
	     unsigned shrink);
