/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgAscii.c                                                    */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:31 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Ascii"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *image;

  IFHELP
    {
      fprintf(stderr,"img%s - Convert image into ASCII format\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Any\n");
      fprintf(stderr,"  stdout: Any\n");
      exit(0);
    }
  imgStart(PRGNAME);

  do {
    image=i_read_image_file(stdin,IT_ANY,IM_FRAGMENT);
    if(image==NULL)
      ERROR("can't import image file");
    i_write_image_file(stdout,image,IF_ASCII);
    i_destroy_image(image);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
