/*
### Copy and record time series from orbit data ###

Variables:
	tser_len: length of time series
	n: variable dimension
	tser_algorithm_option: switch for collapsing algorithm
Implicit Output:
	tser[]: time series in double precision (implicit)

Note: Time series is recorded in analog.
*/

tser_copy()
{
	int i,j,n;
	double *xt,*xt2,to_1d_tser();
	extern int var_dim,tser_len,tser_algorithm_option;
	extern double *tser,**data1_x;

	tser_set_len();
	tser_malloc();

	n = var_dim;
	xt = (double *) dvector(0,n-1);
	xt2 = (double *) dvector(0,n-1);
	for(i=0;i<tser_len;i++){
		for(j=0;j<n;j++)
			xt[j] = data1_x[j][i];
		make_periodic(xt2,xt,n);	
		tser[i] = to_1d_tser(xt2,n,tser_algorithm_option);
	}
	(void) free_dvector(xt,0,n-1);
	(void) free_dvector(xt2,0,n-1);
}
