/*
### Save current window configuration parameters to a header ###

Note: Exist two data formats (new and old) depending on new_data_format
*/


#include <stdio.h>

save_param(ffp)
FILE *ffp;
{
	int i,j;
	extern int big_length,new_data_format,func_on,clipping,more_digits_on,symbol_size,symbol_type,cur_color;

	extern int aux_max,*aux_on,*aux_win_mode,**aux_cur_index;
	extern double **aux_x_min,**aux_x_max;

	extern int var_dim,func_dim,param_dim,full_dim;
	extern int param_dim,var_dim,func_dim;
	extern int i_start,i_max,i_step;
	extern int n_poincare,n_displayed_data1,n_displayed_data0,n_stored_data1,n_stored_data0;
	extern int var_cur_index[],param_cur_index[];
	extern int model,ds_class,int_algorithm,polar_coord,draw_all,show_transient,dot_size,invert_background;
	extern int save_option,polar_section,linear_interpolation,section_index,colormap_option,colorcode_depth_index;
	extern double *param;
	extern double *win_var_i,*win_var_f,*all_min,*all_max,*all_min_top,*all_max_top;
	extern double time_step,average_return_time,*func_i,*func_f;
	extern double colorcode_min,colorcode_max,section_constant;
	extern char dir_name[],file_name[];
	extern char *title_label;

	fprintf(ffp, "%%T Title: ");
	fprintf(ffp, " %s\n", title_label);

	fprintf(ffp, "%%TN Dim:(Class,Var,Param,Func) %d %d %d %d\n", ds_class, var_dim, param_dim,func_dim);

	fprintf(ffp, "%%T Opt:(model,int_algorithm,polar_coord,draw_all,show_transient,dot_size,invert_background,colormap_option,colorcode_depth_index) %d %d %d %d %d %d %d %d %d\n", model, int_algorithm, polar_coord, draw_all, show_transient, dot_size, invert_background, colormap_option, colorcode_depth_index);
	fprintf(ffp, "%%T Opt:(color_code_min,colorcode_max) %lg %lg\n", colorcode_min, colorcode_max);

	/* START: new data format */
	/* save all the other options */
	if(new_data_format){
		fprintf(ffp, "%%T Misc.Options:(func_on,clipping,more_digits_on,symbol_type,symbol_size,cur_color)");
		fprintf(ffp, " %d %d %d %d %d %d\n",func_on,clipping,more_digits_on,symbol_type,symbol_size,cur_color);
	}
	/* END: new data format */

	fprintf(ffp, "%%T Main:(param)");
	for (i = 0; i < param_dim; i++) {
		fprintf(ffp, " %lg", param[i]);
	}
	fprintf(ffp, "\n");
	fprintf(ffp, "%%T Main:(win_var_i)");
	for (i = 0; i < var_dim; i++) {
		fprintf(ffp, " %lg", win_var_i[i]);
	}
	fprintf(ffp, "\n");
	fprintf(ffp, "%%T Main:(i_start,i_max,i_step) %d %d %d\n", i_start, i_max, i_step);
	fprintf(ffp, "%%T Main:(time_step) %lg\n", time_step);
	fprintf(ffp, "%%T Main:(win_var_f)");
	for (i = 0; i < var_dim; i++) {
		fprintf(ffp, " %lg", win_var_f[i]);
	}
	fprintf(ffp, "\n");

	fprintf(ffp, "%%T Win:(var_cur_index(2),param_cur_index(2)) %d %d %d %d\n", var_cur_index[0], var_cur_index[1], param_cur_index[0], param_cur_index[1]);

	/* save the bounds */
	fprintf(ffp, "%%T Win:(var_min,var_max)");
	if(new_data_format){
		for (i = 0; i < full_dim; i++)
			fprintf(ffp, " %lg %lg", all_min[i], all_max[i]);
	}
	else {
		for (i = 0; i < var_dim; i++)
			fprintf(ffp, " %lg %lg", all_min[i], all_max[i]);		}
	fprintf(ffp, "\n");

	fprintf(ffp, "%%T Win:(param_min,param_max)");
	for (i = full_dim; i < full_dim+param_dim; i++)
		fprintf(ffp, " %lg %lg", all_min[i], all_max[i]);
	fprintf(ffp, "\n");

	fprintf(ffp, "%%T Save:(save_option) %d\n", save_option);

	fprintf(ffp, "%%T Sect:(polar_section,linear_interpolation,section_index,n_poincare,section_constant) %d %d %d %d %lg\n", polar_section, linear_interpolation, section_index, n_poincare, section_constant);

	fprintf(ffp, "%%T Syst:(n_displayed_data1,average_return_time,func_i[0],func_f[0],func_i[1],func_f[1]) %d %lg %lg %lg %lg %lg\n", n_displayed_data1, average_return_time, func_i[0], func_f[0], func_i[1], func_f[1]);

	if(new_data_format){
		fprintf(ffp, "%%T Top:(all_min_top,all_max_top)");
		for (i = 0; i < full_dim+param_dim; i++)
			fprintf(ffp, " %lg %lg", all_min_top[i], all_max_top[i]);
		fprintf(ffp, "\n");

	}
}
