/*
### load window parameters from a header of a given file ###

Note:	If installed and loaded dynamical system classes are different,
	it complains and exit.
	If installed and loaded dimensions (phase space and parameter space)
	are different for a given model, it complains and exit.
	If installed and loaded function dimensions are different,
	it complains but proceeds with the larger function dimension as long
	as it is less than func_dim_max.

Bug:	Have to handle old data files whose function dimension was fixed to 2.
	Now that function dimension can vary, it resets function dimension to
	the larger of loaded function dimension (2 for old data)
	and installed function dimension.
*/

#include <stdio.h>

load_param(ffp)
FILE *ffp;
{
	int i,j,aux_max_new,ds_class_loaded,model_loaded,var_dim_loaded,param_dim_loaded,func_dim_loaded;
	extern int stop,polar_coord_old,func_on_old;
	extern int new_data_format,big_length,func_on,clipping,more_digits_on,symbol_size,symbol_type,cur_color;

	extern int aux_max,*aux_on,*aux_win_mode,**aux_cur_index;
	extern double **aux_x_min,**aux_x_max;

	extern int var_dim,func_dim,param_dim,full_dim,func_dim_max;
	extern int n_displayed_data1,n_displayed_data0,ds_class,var_dim,param_dim;
	extern int model,int_algorithm,polar_coord,draw_all,show_transient,dot_size,invert_background,colormap_option,colorcode_depth_index;
	extern int i_start,i_step,i_max;
	extern int var_cur_index[],param_cur_index[];
	extern int save_option,polar_section,linear_interpolation,section_index,n_poincare;
	extern double colorcode_min,colorcode_max,time_step,section_constant;
	extern double *param,*win_var_i,*win_var_f,*all_min,*all_max;
	extern double *all_min_top,*all_max_top,*func_min_top,*func_max_top;
	extern double average_return_time,*func_i,*func_f;
	extern char lstring[],string[];

	fgets(lstring,big_length,ffp);
	/* Temporarily determine the existence of func_dim by looking
	at the header for backward compatibility */
	fscanf(ffp, "%s",string);
	fscanf(ffp,"%*s %d",&ds_class_loaded);
	if(ds_class != ds_class_loaded){
		sprintf(lstring,"Inconsistency in Loading! Installed DS Class=%d, Loaded DS Class=%d",ds_class,ds_class_loaded);
		system_mess_proc(1,lstring);
		sprintf(lstring,"Either reinstall new DS class or edit the header of DS being loaded DS");
		system_mess_proc(0,lstring);
		stop = 1;
		return;
	}
	/* New Compact format */
	if(strncmp(string,"%TN",3) == 0){
		fscanf(ffp,"%d %d %d", &var_dim_loaded, &param_dim_loaded,&func_dim_loaded);
	}
	/* Old Compact format - No longer used for writing. Only for reading
	old data */
	else {
		fscanf(ffp,"%d %d", &var_dim_loaded, &param_dim_loaded);
		func_dim_loaded = 2;
		sprintf(string,"Old data: func dim is set to %d",func_dim_max);
		system_mess_proc(1,string);
	}

	fscanf(ffp, "%*s %*s %d %d %d %d %d %d %d %d %d",
		&model_loaded, &int_algorithm, &polar_coord, &draw_all, &show_transient, &dot_size, &invert_background, &colormap_option, &colorcode_depth_index);
	fscanf(ffp, "%*s %*s %lg %lg", &colorcode_min, &colorcode_max);

	/* Problem: save_option used here is an old one */
	/* START: new data format */
	if(new_data_format)
		fscanf(ffp,"%*s %*s %d %d %d %d %d %d",&func_on,&clipping,&more_digits_on,&symbol_type,&symbol_size,&cur_color);
	/* END: new data format */

	/* check model and install a new one if necessary */
	if(model != model_loaded){
		sprintf(string,"A NEW model is being loaded...");
		system_mess_proc(0,string);
		model = model_loaded;
		(void) model_init();
	}
	/* take care of function feature */
	else if(func_on_old!= func_on){
		(void) func_init();
	}
	/* take care of polar coordinate feature */
	else if(polar_coord_old != polar_coord){
		(void) reset_params();
	}
		
	/* check if the loaded dimensions are consistent with installed
	ones */
	if(var_dim != var_dim_loaded){
		sprintf(string,"Error: model=%d installed phase space dim=%d, loaded phase space dim=%d",model,var_dim,var_dim_loaded);
		system_mess_proc(1,string);
		stop = 1;
		return;
	}
	else if(param_dim != param_dim_loaded){
		sprintf(string,"Error: model=%d installed param space dim=%d, loaded param space dim=%d",model,param_dim,param_dim_loaded);
		system_mess_proc(1,string);
		stop = 1;
		return;
	}
	else if(func_dim != func_dim_loaded){
		sprintf(string,"Warning: model=%d, installed func space dim=%d, loaded func space dim=%d",model,func_dim,func_dim_loaded);
		system_mess_proc(1,string);
		stop = 1;
		return;
	}

	fscanf(ffp, "%*s %*s");
	for (i = 0; i < param_dim; i++)
		fscanf(ffp, "%lg", &param[i]);
	fscanf(ffp, "%*s %*s");
	for (i = 0; i < var_dim; i++)
		fscanf(ffp, "%lg", &win_var_i[i]);
	fscanf(ffp, "%*s %*s %d %d %d", &i_start, &i_max, &i_step);
	fscanf(ffp, "%*s %*s %lg", &time_step);
	fscanf(ffp, "%*s %*s");
	for (i = 0; i < var_dim; i++)
		fscanf(ffp, "%lg", &win_var_f[i]);

	fscanf(ffp, "%*s %*s %d %d %d %d", &var_cur_index[0], &var_cur_index[1], &param_cur_index[0], &param_cur_index[1]);

	fscanf(ffp, "%*s %*s");
	if(new_data_format){
		for (i = 0; i < full_dim;i++) fscanf(ffp, "%lg %lg", &all_min[i], &all_max[i]);
	}
	else {
		for (i = 0; i < var_dim; i++) fscanf(ffp, "%lg %lg", &all_min[i], &all_max[i]);
	}
	fscanf(ffp, "%*s %*s");
	for (i = full_dim; i < full_dim+param_dim; i++) fscanf(ffp, "%lg %lg", &all_min[i], &all_max[i]);

	fscanf(ffp, "%*s %*s %d", &save_option);

	fscanf(ffp, "%*s %*s %d %d %d %d %lg", &polar_section, &linear_interpolation, &section_index, &n_poincare, &section_constant);

	fscanf(ffp, "%*s %*s %d %lg %lg %lg %lg %lg", &n_displayed_data1, &average_return_time, &func_i[0], &func_f[0], &func_i[1], &func_f[1]);

	/* START: new data format */
	if(new_data_format){
		fscanf(ffp, "%*s %*s");
		for (i = 0; i < full_dim+param_dim; i++)
			fscanf(ffp, "%lg %lg", &all_min_top[i], &all_max_top[i]);
	}
}
