/*
### create panel for window resizing and projection ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>
#include "../modellib/class_kaos_def.h"

void create_window_size_panel()
{
	int i,ipanel_row = 0,px,py;
	void window_size_panel_quit_proc();
	void clear_last_proc(), redisplay_proc();
	void proj_var_0_proc(), proj_var_1_proc(), proj_param_0_proc(), proj_param_1_proc();
	extern Frame frame,window_size_frame,main_frame;
	extern Panel panel,window_size_panel;
	extern Pixfont *boldfont;
	extern Panel_item window_size_panel_quit_item,redisplay_item,clear_last_item;
	extern Panel_item n_stored_data0_item,n_stored_data1_item,*all_min_item,*all_max_item;
	extern Panel_item proj_var_item[],proj_param_item[];
	extern short window_size_panel_show,main_panel_show;
	extern int panel_colormap_on;
	extern int polar_coord,more_digits_on,var_dim,func_dim,full_dim,param_dim;
	extern int p_l_margin,n_stored_data1,n_stored_data0,model,var_cur_index[],param_cur_index[];
	extern double *all_min,*all_max;
	extern char string[],string2[],**var_label,**var_polar_label,**all_label,**param_label,**win_var_label;

	if(window_size_panel_show){
		window_set(window_size_frame,WIN_SHOW,TRUE,0);
		return;
	}
	else
		window_size_panel_show = 1;
	if(main_panel_show){
		px =  (int) window_get(main_frame,WIN_X);
		py =  (int) window_get(main_frame,WIN_Y) + (int) window_get(main_frame,WIN_HEIGHT);
	}
	else {
		px =  (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH);
		py =  (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT);
	}
	if(px > 1152 - 200)
		px = 1152 - 200;
	if(py > 950 - 200)
		py = 950 - 200;
	window_size_frame = window_create(frame, FRAME,
		FRAME_LABEL, "projection",
		FRAME_NO_CONFIRM, TRUE,
		FRAME_SHOW_LABEL, TRUE,
		WIN_SHOW, TRUE,
		WIN_X, px,
		WIN_Y, py,
		WIN_FONT, boldfont,
		0);
	if(window_size_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		window_size_panel_show = 0;
		return;
	}
	window_size_panel = window_create(window_size_frame, PANEL,
		WIN_FONT, boldfont,
		0);
	if(window_size_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_window_size_panel();
		return;
	}
	window_size_panel_quit_item = panel_create_item(window_size_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(window_size_panel, "Quit", 4, boldfont),
		PANEL_NOTIFY_PROC, window_size_panel_quit_proc,
		0);
	redisplay_item = panel_create_item(window_size_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(window_size_panel, "Redisplay", 9, boldfont),
		PANEL_NOTIFY_PROC, redisplay_proc,
		0);
	clear_last_item = panel_create_item(window_size_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(window_size_panel, "Clear last", 10, boldfont),
		PANEL_NOTIFY_PROC, clear_last_proc,
		0);
	sprintf(string, "%d", n_stored_data1);
	n_stored_data1_item = panel_create_item(window_size_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_LABEL_STRING, "Stored Var:",
		0);
	sprintf(string, "%d", n_stored_data0);
	n_stored_data0_item = panel_create_item(window_size_panel, PANEL_TEXT,
		PANEL_LABEL_X, ATTR_COL(28),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 10,
		PANEL_LABEL_STRING, "Stored Par:",
		0);
	if(polar_coord)
		for(i=0;i<var_dim;i++) win_var_label[i] = var_polar_label[i];
	else
		for(i=0;i<var_dim;i++) win_var_label[i] = var_label[i];
	proj_var_item[0] = panel_create_item(window_size_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Var Plane:",
		PANEL_VALUE, var_cur_index[0],
		PANEL_NOTIFY_PROC, proj_var_0_proc,
		PANEL_CHOICE_STRINGS, WIN_VAR_LABELS,0,
		0);
	proj_var_item[1] = panel_create_item(window_size_panel, PANEL_CYCLE,
		PANEL_LABEL_X, ATTR_COL(28),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, ":",
		PANEL_VALUE, var_cur_index[1],
		PANEL_NOTIFY_PROC, proj_var_1_proc,
		PANEL_CHOICE_STRINGS, WIN_VAR_LABELS,0,
		0);
	proj_param_item[0] = panel_create_item(window_size_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Par Plane:",
		PANEL_VALUE, param_cur_index[0],
		PANEL_NOTIFY_PROC, proj_param_0_proc,
		PANEL_CHOICE_STRINGS, PARAM_LABELS, 0,
		0);
	proj_param_item[1] = panel_create_item(window_size_panel, PANEL_CYCLE,
		PANEL_LABEL_X, ATTR_COL(28),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, ":",
		PANEL_VALUE, param_cur_index[1],
		PANEL_NOTIFY_PROC, proj_param_1_proc,
		PANEL_CHOICE_STRINGS, PARAM_LABELS, 0,
		0);
	for (i = 0; i < full_dim+param_dim; i++) {
		if(more_digits_on)
			sprintf(string, "%.12lg", all_min[i]);
		else
			sprintf(string, "%lg", all_min[i]);
		sprintf(string2, "[%s]:", all_label[i]);
		all_min_item[i] = panel_create_item(window_size_panel, PANEL_TEXT,
			PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
			PANEL_LABEL_X, ATTR_COL(0),
			PANEL_VALUE, string,
			PANEL_VALUE_DISPLAY_LENGTH, 10,
			PANEL_LABEL_STRING, string2,
			0);
		if(more_digits_on)
			sprintf(string, "%.12lg", all_max[i]);
		else
			sprintf(string, "%lg", all_max[i]);
		sprintf(string2, ":");
		all_max_item[i] = panel_create_item(window_size_panel, PANEL_TEXT,
			PANEL_LABEL_X, ATTR_COL(28),
			PANEL_VALUE, string,
			PANEL_VALUE_DISPLAY_LENGTH, 10,
			PANEL_LABEL_STRING, string2,
			0);
	}
	
	window_fit(window_size_panel);
	window_fit(window_size_frame);
	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(window_size_panel,WIN_PIXWIN),"window_size_panel_cms");
}
