/*
### a procedure for printing a raster file ###
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <stdio.h>

void print_raster_proc(print_region)
int print_region;
{
	static print_count = 0;
	int i, j,xp,yp,wp,hp;
	char string[500],string2[500];
	Pixrect *pixrect;
	extern short param_window_show;
	extern int pixel_depth,*aux_on,aux_win_i,ycanvas,ywidth,xwidth,l_margin,b_margin;
	extern char source_dir[],raster_label[],lpr_label[];
	extern Frame frame,param_frame,*aux_frame;
	FILE *fp,*fopen();

	print_count++;
	all_reset();

	/*
	fp = fopen(stdout,"w");
	*/

	switch(print_region){
		case 0:
			/* parameter space image */
			/*
  			*pixrect=pr_region(pw->pw_pixrect,
                         pw->pw_clipdata->pwcd_screen_x,
			 pw->pw_clipdata->pwcd_screen_y,
			 (int) window_get(param_frame,WIN_WIDTH),
			 (int) window_get(param_frame,WIN_HEIGHT));
			*/
			if(!param_window_show){
				system_mess_proc(1,"Parameter space not open!");
				return;
			}
			xp = (int) window_get(param_frame,WIN_X);
			yp = (int) window_get(param_frame,WIN_Y);
			wp = (int) window_get(param_frame,WIN_WIDTH);
			hp = (int) window_get(param_frame,WIN_HEIGHT);
			system_mess_proc(0,"dumping param space image to printer");						
			break;
		case 1:
			/* phase space image */
			/*
  			*pixrect=pr_region(pw->pw_pixrect,
                         pw->pw_clipdata->pwcd_screen_x,
			 pw->pw_clipdata->pwcd_screen_y,
			 (int) window_get(frame,WIN_WIDTH),
			 (int) window_get(frame,WIN_HEIGHT));
			 */
			xp = (int) window_get(frame,WIN_X);
			yp = (int) window_get(frame,WIN_Y) + ycanvas - ywidth - b_margin;
			wp = (int) xwidth + 2 * l_margin;
			hp = (int) ywidth + 2 * b_margin;
			system_mess_proc(0,"dumping phase space image to printer");						
			sleep(2);
			break;
		case 2:
			/* aux space image */
			/*
  			*pixrect=pr_region(pw->pw_pixrect,
                         pw->pw_clipdata->pwcd_screen_x,
			 pw->pw_clipdata->pwcd_screen_y,
			 (int) window_get(aux_frame[aux_win_i],WIN_WIDTH),
			 (int) window_get(aux_frame[aux_win_i],WIN_HEIGHT));
			 */
			if(!aux_on[aux_win_i]){
				system_mess_proc(1,"Aux space not open!");
				return;
			}
			xp = (int) window_get(aux_frame[aux_win_i],WIN_X);
			yp = (int) window_get(aux_frame[aux_win_i],WIN_Y);
			wp = (int) window_get(aux_frame[aux_win_i],WIN_WIDTH);
			hp = (int) window_get(aux_frame[aux_win_i],WIN_HEIGHT);
			system_mess_proc(0,"dumping aux space image to printer");						
			break;
		case 3:
			/* full screen */
			xp = 0;
			yp = 0;
			wp = 1150;
			hp = 950;
			system_mess_proc(0,"dumping full screen image to printer");						
			sleep(1);
			clear_region(3);
			break;
		case 4:
			/* base frame image */
			xp = (int) window_get(frame,WIN_X);
			yp = (int) window_get(frame,WIN_Y);
			wp = (int) window_get(frame,WIN_WIDTH);
			hp = (int) window_get(frame,WIN_HEIGHT);
			system_mess_proc(0,"dumping base frame image to printer");						
			sleep(1);
			clear_region(3);
			break;
		default:
			break;
	}

	/*
  	if(pr_dump(pixr,fp,NULL))
  	else
  	fclose(fp);
	*/
					
	/* 8 to 1 bit conversion using dithering (no threshold) */
	if(pixel_depth==8){
		sprintf(string, "(screendump -x %d -y %d -X %d -Y %d | rasfilter8to1 -d | %s | %s; echo Print queued!)",
		xp,yp,wp,hp,raster_label,lpr_label);
	}
	else if(pixel_depth==1){
		sprintf(string, "(screendump -x %d -y %d -X %d -Y %d | %s| %s; echo Print queued!)",
		xp,yp,wp,hp,raster_label,lpr_label);
	}
	else {
		system_mess_proc(1,"This pixel depth is not supported for rasterfile printing!");
		return;
	}
	/*
	sprintf(string, "(screendump -x %d -y %d -X %d -Y %d > tmp.ras)",
		xp,yp,wp,hp);
	*/
	sleep(2);
	if(system(string) == 127){
		strncpy(string2,string,20);
		sprintf(string,"Shell (%s...) cannot be executed!",string2);
		system_mess_proc(1,string);
	}
	else
		if(print_region==0 || print_region==1 || print_region==2)
			system_mess_proc(0,"Print job queued!");
	sleep(2);
}
