/*
This is a martyd3 subroutine. "martyd3" should be
substituted with the proper string for a dynamical system
to be installed. Define all initialization parameters
here. Parameters are assigned to the default values before this program is
called.
*/
int martyd3_init()
{
	title_label = "Marty's D3 Map";

	mapping_on = 1;
	inverse_on = 0;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;

	var_dim = 2;
	param_dim = 4;
	func_dim = 2;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	param_label[0] = "alpha";
	param_label[1] = "lambda";
	param_label[2] = "beta";
	param_label[3] = "gamma";
	func_label[0] = "Modulus";
	func_label[1] = "Re(Z^3)";

	param[0] = -1;
	param[1] = 1.52;
	param[2] = .1;
	param[3] = -.8;
	var_i[0] = 0.01;
	var_i[1] = 0.057;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;
	param_min[3]= -5; param_max[3]= 5;
	var_min[0]= -1.5; var_max[0]= 1.5;
	var_min[1]= -1.5; var_max[1]= 1.5;

	f_p = martyd3_f;
	func_p = martyd3_func;
}
/*
second user dynamical system 
*/
	
int martyd3_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double z2r,z2i,z3r,z3i,iv;
        cmul(&z2r,&z2i,x[0],x[1],x[0],x[1]);
	cmul(&z3r,&z3i,z2r,z2i,x[0],x[1]);
	iv = p[0] * (x[0]*x[0] + x[1]*x[1]) + p[1] + p[2] * z3r; 
	if(index ==1) {
		f[0] = iv * x[0] + p[3] * z2r;
		f[1] = iv * x[1] - p[3] * z2i;
	}
}

cmul(x,y,x1,y1,x2,y2)
double *x,*y,x1,y1,x2,y2;
{
	*x = x1 * x2 - y1 * y2; 
	*y = x1 * y2 + x2 * y1; 
}
/* cmul() is a subroutine local for this model */
int martyd3_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	double z2r,z2i,z3r,z3i,iv;
        cmul(&z2r,&z2i,x[0],x[1],x[0],x[1]);
	cmul(&z3r,&z3i,z2r,z2i,x[0],x[1]);
	f[0] = x[0]*x[0] + x[1]*x[1];
	f[1] = z3r;
}
