
int henonheiles_init()
{
	title_label = "Henon-Heiles";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 0;
	enable_period = 0;
	var_dim = 4;
	param_dim = 1;
	func_dim = 3;

	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "px";
	var_label[2] = "y";
	var_label[3] = "py";
	param_label[0] = "epsilon";
	func_label[0] = "Energy";
	func_label[1] = "Ang Mon";
	func_label[2] = "t";

	param[0] = 1;

	var_i[0] = 0.1;
	var_i[1] = 0.1;
	var_i[2] = 0.1;
	var_i[3] = 0.1;

	/* stating values of parameter window box */
	param_min[0]= 0; param_max[0]= 5;

	var_min[0]= -1; var_max[0]= 1;
	var_min[1]= -1; var_max[1]= 1;
	var_min[2]= -1; var_max[3]= 1;
	var_min[3]= -1; var_max[2]= 1;
	func_min[0]= -1; func_max[0]= 1;
	func_min[1]= -1; func_max[1]= 1;
	func_min[2]= 0; func_max[2]= 10000;

	f_p = henonheiles_f;
	func_p = henonheiles_func;
}

int henonheiles_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	if(index!=2){
		f[0] = x[1];
		f[2] = x[3];
	}
	if(index!=1){
		f[1] = - x[0] - p[0]*2.*x[0]*x[2];
		f[3] = - x[2] - p[0]*(x[0]*x[0]-x[2]*x[2]);
	}
}

int henonheiles_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
	double x0sq,x2sq;
	x0sq = x[0]*x[0];
	x2sq = x[2]*x[2];
	f[0] = 0.5 * (x[1]*x[1] + x[3]*x[3] + x0sq + x2sq) + p[0]*(x0sq*x[2] - x2sq*x[2]/3.);
	f[1] = x[0]*x[3] - x[1]*x[2];
	f[2] = t;
}
