/*
### Compute an inverse of f ^ r with an offset "xoffset" by secant method ###
(Solve F(x)=f^r(x)-x-xoffset = x0)
------------------------------------------------------
Note:	x[0...n-1] convention 
	All computation in Euclidean coords
	
Input:	x[n] = current guess, n= phase space dimension, r= period
	x0[n] = current point 
	tolx= tolerated error in x (sum), tolf= tolerated error in F(x) (sum)
	ntrial = # of maximum secant step
Output:	x[n]=new guessed solution, *ndid= acutal # of secant step done,
	*err= actual error in x (sum)
*/

#define DELTAX 1.e-6
#define DELFRAC 0.2
#define FREERETURN {*ndid = k;free_dmatrix(alpha,0,n-1,0,n-1);free_dvector(xt,0,n-1);free_dvector(beta,0,n-1);\
	free_ivector(indx,0,n-1);return;}

void fmapi_user(x,x2,x0,ntrial,n,r,tolx,tolf,err,ndid)
int ntrial,n,r,*ndid;
double *x,*x2,*x0,tolx,tolf,*err;
{
	int i,j,k,*indx,*ivector();
	double tolx10,fabs(),errf,d,*xt,*beta,**alpha,*dvector(),**dmatrix();
	void usrfuni(),ludcmp(),lubksb(),free_dmatrix(),free_ivector(),free_dvector();
	extern int stop,cur_color;
	extern int model,mapping_on,fderiv_on;
	extern double cutoff,*t_vf;

	tolx10 = tolx /10;
	indx = ivector(0,n-1);
	xt = dvector(0,n-1);
	beta = dvector(0,n-1);
	alpha = dmatrix(0,n-1,0,n-1);

	for(k=0;k<ntrial;k++){
		for(i=0;i<n;i++){
			if(x[i] > cutoff || x[i] < -cutoff) {

				system_mess_proc(1,"inverse appears to blow up! Stop!");
				stop = 1;
				FREERETURN;
			}
		}
		/* compute Jacobian by finite difference only */
		(void) usrfuni(x,x2,x0,alpha,beta,r,n);
		/*
		printf("NTRIAL=%d\n",k);
		printf("usrfun x: ");
		for(i=0;i<n;i++) printf("%g ",x[i]);	
		printf("\n");
		printf("usrfun f: ");
		for(i=0;i<n;i++) printf("%g ",beta[i]);	
		printf("\n");
		printf("usrfun alpha:");
		for(j=0;j<n;j++){
			for(i=0;i<n;i++) printf("%g ",alpha[j][i]);	
			printf("\n");
		}
		*/

		errf = 0.0;
		for(i=0;i<n;i++) errf += fabs(beta[i]);
		if(errf <= tolf) FREERETURN

		ludcmp(alpha,n,indx,&d);
		/* should be placed here not to proceed further
		in case of singular matrix (singular matrix often
		arise when all the machine accuracy was lost in
		computing alpha. This happens in case of good
		convergence,too) */
		if(stop){
			/* do not reset stop=0 since it is passed down to
			another routine */
			FREERETURN
		}
		/*
		for(j=0;j<n;j++){
			for(i=0;i<n;i++) printf("%g ",alpha[j][i]);	
			printf("\n");
		}
		*/
		lubksb(alpha,n,indx,beta);

		/*
		printf("new beta:");
		for(i=0;i<n;i++) printf("%g ",beta[i]);	
		printf("\n");
		*/
		*err = 0.0;
		for(i=0;i<n;i++){
			*err += fabs(beta[i]);
			x2[i] = x[i];
			x[i] -= beta[i];
		}
		if(*err <= tolx) FREERETURN
		for(i=0;i<n;i++) if(fabs(beta[i]) < tolx10) x[i] -= tolx10;

		/* draw intermediate steps */
		/*
		(void) draw_record_pwf(x,cur_color,1,3,1,0);
		*/
	}
	FREERETURN
}
