/*
### create a lyapunov window ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>

void create_fft_windows()
{
	void fft_quit_proc(),fft_go_proc(),fft_show_proc();
	void fft_algorithm_option_proc();
	int i,ipanel_row=0,px,py;
	extern Frame frame,fft_frame,tser_frame;
	extern Panel fft_panel;
	extern Pixfont *boldfont;
	extern Panel_item fft_quit_item,fft_go_item,fft_show_item;
	extern Panel_item fft_algorithm_option_item;
	extern short fft_panel_show,tser_panel_show;
	extern int panel_colormap_on;
	extern int fft_algorithm_option;
	extern char string[];
	
	/* Turn on the flag */	
	if(fft_panel_show){
		window_set(fft_frame,WIN_SHOW,TRUE,0);	
		return;
	}
	else
		fft_panel_show = 1;

	if(tser_panel_show){
		px = (int) window_get(tser_frame,WIN_X);
		py = (int) window_get(tser_frame,WIN_Y) + (int) window_get(tser_frame,WIN_HEIGHT);
	}
	else {
		px = (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH)/2;
		py = (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT) /2;
	}
	/* Create tser frame */
	fft_frame = window_create(frame,FRAME,
		FRAME_NO_CONFIRM,       TRUE,
		FRAME_LABEL,    "Fourier",
		FRAME_SHOW_LABEL,       TRUE,
		WIN_SHOW,       TRUE,
		WIN_X,  px,
		WIN_Y,  py,
		WIN_FONT, boldfont,
		0);
	if(fft_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		fft_panel_show = 0;
		return;
	}
	/* Create Panel */
	fft_panel = window_create(fft_frame, PANEL,
		WIN_X, 0,
		WIN_Y, 0,
		WIN_FONT, boldfont,
		0);
	if(fft_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_fft_windows();
		return;
	}
	/* Create panel items */
	fft_quit_item= panel_create_item(fft_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(fft_panel, "Quit", 5, boldfont),
		PANEL_NOTIFY_PROC, fft_quit_proc,
		0);
	fft_go_item= panel_create_item(fft_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(fft_panel, "Go", 5, boldfont),
		PANEL_NOTIFY_PROC, fft_go_proc,
		0);
	fft_show_item= panel_create_item(fft_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(fft_panel, "Show", 5, boldfont),
		PANEL_NOTIFY_PROC, fft_show_proc,
		0);
	fft_algorithm_option_item= panel_create_item(fft_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Algorithm: ",
		PANEL_CHOICE_STRINGS,
			"Danielson-Lanczos",
			"User algorithm A",
			"User algorithm B",
			0,
		PANEL_VALUE, fft_algorithm_option,
		PANEL_NOTIFY_PROC, fft_algorithm_option_proc,
		0);

	window_fit(fft_panel);
	window_fit(fft_frame);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(fft_panel,WIN_PIXWIN),"fft_panel_cms");
}
