/*
### Forest-Berz integrator one-stepper ###
*/

symp_forberz_int_one(vy,vx,ptime,time_step,dim)
double vy[],vx[],*ptime,time_step;
int dim;
{
	int i;
	double ts,beta,s1,s2,d1,d2,exp(),log();
	extern double *t_vf,*param;
	extern int (*f_p)();


	beta = exp(log(2.)/3.);
	ts = time_step/(2.-beta);
	s1 = ts/2.;
	s2 = ts*(1.-beta)/2.;
	d1 = ts;
	d2 = -ts*beta;
	
	/* m1(s1) */
	(int) f_p(vy,1,vx,param,*ptime,dim);
	for(i=0;i<dim;i += 2) vy[i] = vx[i] + s1 * vy[i];
	for(i=1;i<dim;i += 2) vy[i] = vx[i];

	/* m2(d1) . m1(s1) */
	(int) f_p(t_vf,2,vy,param,*ptime,dim);
	for(i=1;i<dim;i += 2) vy[i]  += d1 * t_vf[i];

	/* m1(s2) ... */
	(int) f_p(t_vf,1,vy,param,*ptime,dim);
	for(i=0;i<dim;i += 2) vy[i]  += s2 * t_vf[i];

	/* m2(d2) ... */
	(int) f_p(t_vf,2,vy,param,*ptime,dim);
	for(i=1;i<dim;i += 2) vy[i] += d2 * t_vf[i];

	/* m1(s2) ... */
	(int) f_p(t_vf,1,vy,param,*ptime,dim);
	for(i=0;i<dim;i += 2) vy[i] += s2 * t_vf[i];

	/* m1(d1) ... */
	(int) f_p(t_vf,2,vy,param,*ptime,dim);
	for(i=1;i<dim;i  += 2) vy[i] += d1 * t_vf[i];

	/* m1(s1) ... */
	(int) f_p(t_vf,1,vy,param,*ptime,dim);
	for(i=0;i<dim;i  += 2) vy[i] += s1 * t_vf[i];

	*ptime  += time_step;
}
