/*
### My Runge-Kutta one stepper ###
*/

rungekutta_int_one(vx1,vx,ptime,time_step,dim)
double vx1[],vx[],*ptime, time_step;
int dim;
{
	static int icnt=0;
	int i;
	static double *v1,*v2,*sum,*dvector();
	double time_step0,time_step2;
	extern int model;
	extern int var_dim;
	extern double *param;
	extern int (*f_p)();

	
	icnt++;
	if(icnt==1){
		v1 = dvector(0,var_dim-1);
		v2 = dvector(0,var_dim-1);
		sum = dvector(0,var_dim-1);
	}
	time_step0 = time_step * 2;
	time_step2 = time_step/2;
	(int) f_p(v1,0,vx,param,*ptime,dim);
	for(i=0;i<dim;i++){
		sum[i] = time_step * v1[i];
		v1[i] = vx[i] + time_step2 * v1[i];
	}
	*ptime += time_step2;
	(int) f_p(v2,0,v1,param,*ptime,dim);
	for(i=0;i<dim;i++) {
		sum[i] += time_step0 * v2[i];
		v2[i] = vx[i] + time_step2 * v2[i];
	}
	(int) f_p(v1,0,v2,param,*ptime,dim);
	for(i=0;i<dim;i++){
		sum[i] += time_step0 * v1[i];
		v1[i] = vx[i] + time_step * v1[i];
	}
	*ptime += time_step2;
	(int) f_p(v2,0,v1,param,*ptime,dim);
	for(i=0;i<dim;i++){
		sum[i] += time_step * v2[i];
		vx1[i] = vx[i] + sum[i]/6.;
	}
}
