/*
### Redisplay data in combined space ###

Note: 	aux_win_mode: determines the mode of data display

	bombined space(data2) if aun_win_mode>0 (always true if auto_option>0)
	parameter space (data0) if aux_win_mode<=0 and region_index=0
	phase space (data1) if aux_win_mode<=0 and region_index=1
	do nothing:	otherwise
--------------------------------------------------------------------------------
*/

#include <suntool/sunview.h>
aux_redisplay_data(aux_i)
int aux_i;
{
        int i,j,color,s_type,s_size;
	extern Pixwin **aux_pw;
	extern int var_dim,param_dim,func_dim,full_dim;
        extern int aux_max,*aux_on,**aux_cur_index,*aux_win_mode;
        extern int stop,region_index,pix_type,symbol_size,dot_size;
        extern int n_displayed_data0,n_displayed_data1,n_displayed_data2,n_stored_data0,n_stored_data1,n_stored_data2;
	extern double *t_va;
        extern int *data0_color,*data1_color,*data2_color;
        extern double **data0_x,**data1_x,**data2_x;

	stop = 0;
	/* aux window all purpose mode (data2) */
        if(aux_on[aux_i] && aux_win_mode[aux_i] >0){
        	aux_reset(aux_i);
        	(void) aux_clear_region(aux_i);
		n_displayed_data2 = 0;
        	for (i = 0; i < n_stored_data2; i++) {
			decode_color_symbol(data2_color[i],&color,&s_type);
			s_size = (s_type>=0) ? symbol_size : dot_size;
			for(j=0;j<full_dim+param_dim;j++)t_va[j]=data2_x[j][i];
			pen_down(2,aux_pw[aux_i],t_va,color,s_type,s_size,pix_type);
                        n_displayed_data2++;
                }
		if(stop){
			return;
		}
	}
	/* simulcast mode */
        else if(aux_on[aux_i]){
        	aux_reset(aux_i);
        	(void) aux_clear_region(aux_i);
		/* Exclusive data1 mode */
		if(aux_cur_index[aux_i][0] <
		full_dim && aux_cur_index[aux_i][1] < full_dim){
                	n_displayed_data1 = 0;
                	for (i = 0; i < n_stored_data1; i++) {
				for(j=0;j<full_dim;j++) t_va[j] = data1_x[j][i];
				decode_color_symbol(data1_color[i],&color,&s_type);
				s_size = (s_type>=0) ? symbol_size : dot_size;
				pen_down(2,aux_pw[aux_i],t_va,color,s_type,s_size,pix_type);
                        	n_displayed_data1++;
				if(stop){
					return;
				}
			}
		}
		/* Exclusive data0 mode */
        	else if ( aux_cur_index[aux_i][0] >=
		full_dim && aux_cur_index[aux_i][1] >= full_dim){
               		n_displayed_data0 = 0;
               		for (i = 0; i < n_stored_data0; i++) {
				for(j=0;j<param_dim;j++) t_va[j+full_dim] = data0_x[j][i];
				decode_color_symbol(data0_color[i],&color,&s_type);
				s_size = (s_type>=0) ? symbol_size : dot_size;
				pen_down(2,aux_pw[aux_i],t_va,color,s_type,s_size,pix_type);
                                n_displayed_data0++;
				if(stop){
					return;
				}
			}
		}
	}
}
