/*
### procedure for writing an user initialization file for auto execution ###
*/

#include <stdio.h>
#include "../include/auto_kaos_def.h"

void
auto_panel_write_init_proc()
{
	int i,lock_interval_old;
	FILE *fp,*fopen();
	extern int region_index,lock_interval;
	extern char string[],lstring[],auto_dir_name[],auto_file_name[],auto_input_name[];
	/* AUTO86 declerations */
	extern int auto_ndim,auto_ips,auto_irs,auto_ilp;
	extern int auto_ntst,auto_ncol,auto_iad,auto_isp,auto_isw,auto_iplt;
	extern int auto_nbc,auto_nint,auto_nmx,auto_npr,auto_mxbf,auto_iid;
	extern int auto_itmx,auto_itnw,auto_nwtn,auto_jac,auto_nuzr;
	extern int auto_n1,auto_n2,auto_nfpar,auto_icp[];
	extern double auto_rl0,auto_rl1,auto_a0,auto_a1,auto_par[];
	extern double auto_epsu,auto_epss,auto_epsl[],auto_ds,auto_dsmin,auto_dsmax;
	extern double auto_thetau,auto_thetal[];
	
	all_reset();

        sprintf(string,"%s/%s",auto_dir_name,auto_input_name);
	fp = fopen(string,"w");
	if(fp == NULL){
		fclose(fp);
		return;
	}
	fprintf(fp,"      subroutine init\n");
	fprintf(fp,"c     ---------- ----\n");
	fprintf(fp,"c\n");
	fprintf(fp,"c in this subroutine the user should set those constants that require\n");
	fprintf(fp,"c values that differ from the default values assigned in dfinit.\n");
	fprintf(fp,"c (see the main documentation for the default assignments).\n");
	fprintf(fp,"c\n");
	fprintf(fp,"      implicit double precision (a-h,o-z)\n");
	fprintf(fp,"CSGLE implicit real (a-h,o-z)\n");
	fprintf(fp,"c\n");
	fprintf(fp,"      common /blbcn/ ndim,ips,irs,ilp,icp(20),par(20)\n");
	fprintf(fp,"      common /blcde/ ntst,ncol,iad,isp,isw,iplt,nbc,nint\n");
	fprintf(fp,"      common /bldls/ ds,dsmin,dsmax,iads\n");
	fprintf(fp,"      common /bllim/ nmx,nuzr,rl0,rl1,a0,a1\n");
	fprintf(fp,"      common /blmax/ npr,mxbf,iid,itmx,itnw,nwtn,jac\n");
	fprintf(fp,"c\n");

	fprintf(fp,"       ndim=%d\n",auto_ndim);
	fprintf(fp,"       ips=%d\n",auto_ips);
	fprintf(fp,"       irs=%d\n",auto_irs);
	fprintf(fp,"       ilp=%d\n",auto_ilp);
	fprintf(fp,"c\n");
	fprintf(fp,"c set the principal bifurcation parameter to be par(1).\n");
	fprintf(fp,"c\n");
	fprintf(fp,"       icp(1)=%d\n",auto_icp[0]);
	fprintf(fp,"c\n");
	fprintf(fp,"c set the second free parameter to be par(2).\n");
	fprintf(fp,"c (for 2-parameter continuation).\n");
	fprintf(fp,"c\n");
	for(i=1;i<auto_nfpar;i++){ 
		fprintf(fp,"       icp(%d)=%d\n",i+1,auto_icp[i]);
	}
	fprintf(fp,"c\n");
	fprintf(fp,"       rl0=%lg\n",auto_rl0);
	fprintf(fp,"       rl1=%lg\n",auto_rl1);
	fprintf(fp,"       a0=%lg\n",auto_a0);
	fprintf(fp,"       a1=%lg\n",auto_a1);
	fprintf(fp,"       ds=%lg\n",auto_ds);
	fprintf(fp,"	dsmin = %lg\n",auto_dsmin);
	fprintf(fp,"	dsmax = %lg\n",auto_dsmax);
	fprintf(fp,"c\n");
	fprintf(fp,"       ntst=%d\n",auto_ntst);
	fprintf(fp,"       iad=%d\n",auto_iad);
	fprintf(fp,"       isp=%d\n",auto_isp);
	fprintf(fp,"       ncol=%d\n",auto_ncol);
	fprintf(fp,"       isw=%d\n",auto_isw);
	fprintf(fp,"       iplt=%d\n",auto_iplt);
	fprintf(fp,"       nbc=%d\n",auto_nbc);
	fprintf(fp,"       nint=%d\n",auto_nint);
	fprintf(fp,"c\n");
	fprintf(fp,"       nmx=%d\n",auto_nmx);
	fprintf(fp,"       nuzr=%d\n",auto_nuzr);
	fprintf(fp,"       npr=%d\n",auto_npr);
	fprintf(fp,"       mxbf=%d\n",auto_mxbf);
	fprintf(fp,"       iid=%d\n",auto_iid);
	fprintf(fp,"       itmx=%d\n",auto_itmx);
	fprintf(fp,"       itnw=%d\n",auto_itnw);
	fprintf(fp,"       nwtn=%d\n",auto_nwtn);
	fprintf(fp,"       jac=%d\n",auto_jac);
	fprintf(fp,"c\n");
	for(i=0;i<AUTO_ALL_PARAM_DIM;i++){
		fprintf(fp,"      par(%d)=%lg\n",i+1,auto_par[i]);
	}
	fprintf(fp,"      return\n");
	fprintf(fp,"      end\n");
	fclose(fp);

	auto_panel_load_proc();
}

