/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  sub_draw.c: Functions to draw shadow.                        */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <math.h>
#include "source/Hcad.h"

#include "source/Hcadext.h"

#define ZERO1 10.0E-12
#define ZERO2  10.0E-8

int cut_number;

/*------------------------------------------------------------

  Function : draw_plane(FILE *)

-------------------------------------------------------------*/
draw_plane(fp)
FILE *fp;
{
	HPlane *pln;
	int i;
	pln = &plane[0];

	for(i = 0;i<total_plane;i++){
		show_plane(pln,fp);
		pln++;
	}
	if(fp!=0){
		fprintf(fp,"0 setgray\n");
	}
	else{
		set_gray(0);
	}

}


/*------------------------------------------------------------

  Function : show_plane(HPlane *,FILE *)

-------------------------------------------------------------*/
show_plane(pln,fp)
HPlane *pln;
FILE *fp;

{
	HPoint base_point[6],unx,uny,center,center2;
	double s1,rc,rc2,k,h,p,d1,k1;
	int i;

	set_gray(0);
	s1 = 1.0 + pow(pln->r,2.0);
	if(pln->r > 1.0){
		rc = pln->r/sqrt(s1);
		rc2 = 2.0*rc/sqrt(3.0);
		k = 1.0 - sqrt(pow(pln->r,2.0)-pow(rc2,2.0))/sqrt(s1);
		center2.x = k*pln->x;
		center2.y = k*pln->y;
		center2.z = k*pln->z;
	}
	else{
		rc2 = pln->r;
		center2.x = pln->x;
		center2.y = pln->y;
		center2.z = pln->z;
	} 
	p = pow(pln->x,2.0)+pow(pln->y,2.0);
	if(p!=0.0){
		k = rc2/sqrt(p);
		h = rc2/sqrt(p*s1);
		unx.x = k*pln->y;
		unx.y = (-1.0)*k*pln->x;
		unx.z = 0.0;
		uny.x = h*pln->x*pln->z;
		uny.y = h*pln->y*pln->z;
		uny.z = (-1.0)*h*(pow(pln->x,2.0)+pow(pln->y,2.0));
	}
	else{
		p = pow(pln->x,2.0)+pow(pln->z,2.0);
		k = rc2/sqrt(p);
		h = rc2/sqrt(p*s1);
		unx.x = k*pln->z;
		unx.y = 0.0;
		unx.z = (-1.0)*k*pln->x;
		uny.x = h*pln->x*pln->y;
		uny.y = (-1.0)*h*(pow(pln->x,2.0)+pow(pln->z,2.0));
		uny.z = h*pln->y*pln->z;
	}
	for(i=0;i<3;i++){
		base_point[i].x = center2.x + cosin[4*i]*unx.x + sine[4*i]*uny.x;
		base_point[i].y = center2.y + cosin[4*i]*unx.y + sine[4*i]*uny.y;
		base_point[i].z = center2.z + cosin[4*i]*unx.z + sine[4*i]*uny.z;
		base_point[i+3].x = 2*center2.x - base_point[i].x;
		base_point[i+3].y = 2*center2.y - base_point[i].y;
		base_point[i+3].z = 2*center2.z - base_point[i].z;
	}
	d1 = pow(pln->x,2.0)+pow(pln->y,2.0)+pow(pln->z,2.0);
	k1 = 1.0-sqrt(1.0-1.0/d1);
	center.x = k1 * pln->x;
	center.y = k1 * pln->y;
	center.z = k1 * pln->z;

	if(pln->r * magnification <0.1){
		cut_number = 1;
	}
	else{
		cut_number = 3;
	}          
	for(i=0;i<5;i++){
		show_triangle(center,base_point[i],base_point[i+1],pln->id,1,fp);
	}
	show_triangle(center,base_point[5],base_point[0],pln->id,1,fp);
}

/*------------------------------------------------------------

  Function : set_gray()

-------------------------------------------------------------*/
set_gray(num)
int num;
{
	XSetStipple(disp,dragc,gray[num]);
	XSetFillStyle(disp,dragc,FillStippled);
}



/*------------------------------------------------------------

  Function : show_triangle(HPoint,HPoint,HPoint,int,int,FILE *)

-------------------------------------------------------------*/
show_triangle(p1,p2,p3,id,times,fp)
HPoint p1;
HPoint p2;
HPoint p3;
int id;
int times;
FILE *fp;
{
	HPoint sp[3];

	if(!check_hide(&p1) && !check_hide(&p2) && !check_hide(&p3) ){
		return;
	}
	center(&p1,&p2,&sp[0],id);
	center(&p2,&p3,&sp[1],id);
	center(&p3,&p1,&sp[2],id);

	if(times <= cut_number){
		times++;
		show_triangle(p1,sp[0],sp[2],id,times,fp);
		show_triangle(p2,sp[0],sp[1],id,times,fp);
		show_triangle(p3,sp[1],sp[2],id,times,fp);
		show_triangle(sp[0],sp[1],sp[2],id,times,fp);
	}
	else{
		show_subtgl(p1,sp[0],sp[2],id,fp,1);
		show_subtgl(p2,sp[0],sp[1],id,fp,1);
		show_subtgl(p3,sp[1],sp[2],id,fp,1);
		show_subtgl(sp[0],sp[1],sp[2],id,fp,1);
	}
}

/*------------------------------------------------------------

  Function : center(HPoint *,HPoint *,HPoint *,int)

-------------------------------------------------------------*/
center(p1,p2,p3,id)
HPoint *p1;
HPoint *p2;
HPoint *p3;
int id;
{
	double x1,y1,z1,k;

	x1 = (p1->x + p2->x)/2.0 - plane[id].x;
	y1 = (p1->y + p2->y)/2.0 - plane[id].y;
	z1 = (p1->z + p2->z)/2.0 - plane[id].z;

	k = plane[id].r / sqrt(pow(x1,2.0) + pow(y1,2.0) + pow(z1,2.0));

	p3->x = plane[id].x + k*x1;
	p3->y = plane[id].y + k*y1;
	p3->z = plane[id].z + k*z1;
}


/*------------------------------------------------------------

  Function : shadow_tri(HPoint,HPoint,HPoint,int,FILE *,int)

-------------------------------------------------------------*/
int shadow_tri(p1,p2,p3,id,fp)
HPoint p1;
HPoint p2;
HPoint p3;
int id;
FILE *fp;
{
	HPoint g;
	double seki,b1;
	int p1x,p1y,p2x,p2y,p3x,p3y;
	XPoint pnts[4];
	int dera;
	double light;  

	if(!check_hide(&p1) || !check_hide(&p2) || !check_hide(&p3) ){
		return(FALSE);
	}
	if(plane[id].side == OUTSIDE){
		g.x = plane[id].x - (p1.x + p2.x + p3.x)/3.0;
		g.y = plane[id].y - (p1.y + p2.y + p3.y)/3.0;
		g.z = plane[id].z - (p1.z + p2.z + p3.z)/3.0;
	}
	else{
		g.x = (p1.x + p2.x + p3.x)/3.0 - plane[id].x;
		g.y = (p1.y + p2.y + p3.y)/3.0 - plane[id].y;
		g.z = (p1.z + p2.z + p3.z)/3.0 - plane[id].z;
	}
	seki =g.x * view_vect.x + g.y * view_vect.y + g.z * view_vect.z;
	if(seki>0.0){
		b1 = sqrt(g.x * g.x + g.y * g.y + g.z * g.z);
		dera = (int)(acos(seki/(b1)) * 18.0 /PIE);
		if((dera<0)||(dera>8)){
			return;
		}
		if(fp==0){
			set_gray(dera);
			p1x = (int)(DR*magnification*(p1.x * coord[0].x + p1.y * coord[1].x + p1.z * coord[2].x));
			p1y = (int)(DR*magnification*(p1.x * coord[0].y + p1.y * coord[1].y + p1.z * coord[2].y));
			p2x = (int)(DR*magnification*(p2.x * coord[0].x + p2.y * coord[1].x + p2.z * coord[2].x));
			p2y = (int)(DR*magnification*(p2.x * coord[0].y + p2.y * coord[1].y + p2.z * coord[2].y));
			p3x = (int)(DR*magnification*(p3.x * coord[0].x + p3.y * coord[1].x + p3.z * coord[2].x));
			p3y = (int)(DR*magnification*(p3.x * coord[0].y + p3.y * coord[1].y + p3.z * coord[2].y));
			pnts[0].x = p1x + DX;
			pnts[1].x = p2x + DX;
			pnts[2].x = p3x + DX;
			pnts[0].y = DY - p1y;
			pnts[1].y = DY - p2y;
			pnts[2].y = DY - p3y;
			XFillPolygon(disp,drawin,dragc,pnts,3,Convex,CoordModeOrigin);
		}
		else{
			light = acos(seki/(b1)) * 2.0 /PIE;
			if((light >= 0.0)&&(light <= 1.0)){
				p1x = (int)(PDR*magnification*(p1.x * coord[0].x + p1.y * coord[1].x + p1.z * coord[2].x));
				p1y = (int)(PDR*magnification*(p1.x * coord[0].y + p1.y * coord[1].y + p1.z * coord[2].y));
				p2x = (int)(PDR*magnification*(p2.x * coord[0].x + p2.y * coord[1].x + p2.z * coord[2].x));
				p2y = (int)(PDR*magnification*(p2.x * coord[0].y + p2.y * coord[1].y + p2.z * coord[2].y));
				p3x = (int)(PDR*magnification*(p3.x * coord[0].x + p3.y * coord[1].x + p3.z * coord[2].x));
				p3y = (int)(PDR*magnification*(p3.x * coord[0].y + p3.y * coord[1].y + p3.z * coord[2].y));
				pnts[0].x = p1x  + PDX;
				pnts[1].x = p2x  + PDX;
				pnts[2].x = p3x  + PDX;
				pnts[0].y = p1y  + PDY;
				pnts[1].y = p2y  + PDY;
				pnts[2].y = p3y  + PDY;
				fprintf(fp,"%4.2f setgray\n",light);
				fprintf(fp,"newpath %d %d moveto %d %d lineto %d %d lineto closepath\n"
				    ,pnts[0].x,pnts[0].y,pnts[1].x,pnts[1].y,pnts[2].x,pnts[2].y); 
				fprintf(fp,"fill\n");
			}
		}
	}
	return(TRUE);
}


/*------------------------------------------------------------

  Function : show_subtgl(HPoint,HPoint,HPoint,int,FILE *,int)

-------------------------------------------------------------*/
show_subtgl(p1,p2,p3,id,fp,lcnt)
HPoint p1;
HPoint p2;
HPoint p3;
int id;
FILE *fp;
int lcnt;
{
	HPoint pnt[6],tpnt[6];
	int i,j,flg,cnt,bool[6],bcnt,bnum[6],nbnum[6],icd;
	int noside;
	HPoint sp[3];

	/*  if(!check_point(p1) && !check_point(p2) && !check_point(p3) ){
	     return;
	   }  */
	input_pnt(p1,&pnt[0]);
	input_pnt(p2,&pnt[1]);
	input_pnt(p3,&pnt[2]);
	cnt = 3;
	flg = 0;

	/*  search cross with unit ball */
	bool[0] = in_out_ball(&pnt[0],&unit_ball);  
	bool[1] = in_out_ball(&pnt[1],&unit_ball);
	bool[2] = in_out_ball(&pnt[2],&unit_ball);
	bcnt = 0;

	/* count inside point */
	for(i = 0;i<3;i++){
		if(bool[i] == 2){
			bnum[bcnt] = i;
			bcnt++;
		}
		else{
			nbnum[i-bcnt] = i;
		}
	}

	switch(bcnt){
	case 0:
		flg = 2;
		return;
		break;

	case 1:
		flg = 1;
		cnt = 3;

		input_pnt(pnt[bnum[0]],&tpnt[0]);
		cross_point(pnt[bnum[0]],pnt[nbnum[0]],&tpnt[1],&unit_ball,INSIDE);
		cross_point(pnt[bnum[0]],pnt[nbnum[1]],&tpnt[2],&unit_ball,INSIDE);
		input_pnt(tpnt[0],&pnt[0]);
		input_pnt(tpnt[1],&pnt[1]);
		input_pnt(tpnt[2],&pnt[2]);
		break;
	case 2:
		if(bool[nbnum[0]]!=1){
			flg = 1;
			cnt = 4;
			input_pnt(pnt[bnum[0]],&tpnt[0]);
			input_pnt(pnt[bnum[1]],&tpnt[1]);
			cross_point(pnt[bnum[1]],pnt[nbnum[0]],&tpnt[2],&unit_ball,INSIDE);
			cross_point(pnt[bnum[0]],pnt[nbnum[0]],&tpnt[3],&unit_ball,INSIDE);
			input_pnt(tpnt[0],&pnt[0]);
			input_pnt(tpnt[1],&pnt[1]);
			input_pnt(tpnt[2],&pnt[2]);
			input_pnt(tpnt[3],&pnt[3]);
		}
		break;

	default: 
		break;
	}
	if(cnt == 4){
		if(lcnt == 3){   
			return;
		}
		show_subtgl(pnt[0],pnt[1],pnt[2],id,fp,lcnt+1);
		show_subtgl(pnt[0],pnt[2],pnt[3],id,fp,lcnt+1);
		return;
	}
	else{
		j = 0;
		/******** search cross with other********/
		while((cnt == 3)&&(flg != 2)&&(plane[id].cross[j] != -1)){
			icd = plane[id].cross[j];
			bool[0] = in_out_ball(&pnt[0],&plane[icd]);
			bool[1] = in_out_ball(&pnt[1],&plane[icd]);
			bool[2] = in_out_ball(&pnt[2],&plane[icd]);
			if(plane[icd].side == INSIDE){
				noside = OUTSIDE;
			}
			else{
				noside = INSIDE;
			}
			bcnt = 0;
			for(i = 0;i < 3;i++){
				if(bool[i] == plane[icd].side){
					bnum[bcnt] = i;
					bcnt++;
				}
				else{
					nbnum[i - bcnt] = i;
				}
			}
			switch(bcnt){
			case 0:
				flg = 2;
				return;
				break;

			case 1:
				flg = 1;
				cnt = 3;
				input_pnt(pnt[bnum[0]],&tpnt[0]);
				cross_point(pnt[bnum[0]],pnt[nbnum[0]],&tpnt[1],&plane[icd],noside);
				cross_point(pnt[bnum[0]],pnt[nbnum[1]],&tpnt[2],&plane[icd],noside);
				input_pnt(tpnt[0],&pnt[0]);
				input_pnt(tpnt[1],&pnt[1]);
				input_pnt(tpnt[2],&pnt[2]);
				break;

			case 2:
				if(bool[nbnum[0]]!=1){
					flg = 1;
					cnt = 4;
					input_pnt(pnt[bnum[0]],&tpnt[0]);
					input_pnt(pnt[bnum[1]],&tpnt[1]);
					cross_point(pnt[bnum[1]],pnt[nbnum[0]],&tpnt[2],&plane[icd],noside);
					cross_point(pnt[bnum[0]],pnt[nbnum[0]],&tpnt[3],&plane[icd],noside);
					input_pnt(tpnt[0],&pnt[0]);
					input_pnt(tpnt[1],&pnt[1]);
					input_pnt(tpnt[2],&pnt[2]);
					input_pnt(tpnt[3],&pnt[3]);
				}
				break;

			default: 
				break;
			} 
			if(cnt == 4){
				if(lcnt == 3){   
					return;
				}
				show_subtgl(pnt[0],pnt[1],pnt[2],id,fp,lcnt+1);
				show_subtgl(pnt[0],pnt[2],pnt[3],id,fp,lcnt+1);
				return;
			}
			j++;
		} 
		if((shadow_tri(pnt[0],pnt[1],pnt[2],id,fp) == FALSE) && (lcnt < 3)){

			center(&pnt[0],&pnt[1],&sp[0],id);
			center(&pnt[1],&pnt[2],&sp[1],id);
			center(&pnt[2],&pnt[0],&sp[2],id);
			show_subtgl(p1,sp[0],sp[2],id,fp,lcnt+1);
			show_subtgl(p2,sp[0],sp[1],id,fp,lcnt+1);
			show_subtgl(p3,sp[1],sp[2],id,fp,lcnt+1);
			show_subtgl(sp[0],sp[1],sp[2],id,fp,lcnt+1);
		}
	}
}


/*------------------------------------------------------------

  Function : input_pnt(HPoint,HPoint *)

-------------------------------------------------------------*/
input_pnt(p1,p2)
HPoint p1;
HPoint *p2;
{
	p2->x = p1.x;
	p2->y = p1.y;
	p2->z = p1.z;
}

/*------------------------------------------------------------

  Function : in_out_ball(HPoint *,HPlane)

-------------------------------------------------------------*/
int in_out_ball(p,crs_ball)

HPoint *p;
HPlane *crs_ball;

{
	double r1;

	r1 = pow(p->x - crs_ball->x,2.0) + pow(p->y - crs_ball->y,2.0) + pow(p->z - crs_ball->z,2.0);
	r1 = sqrt(r1);

	if(r1 >  crs_ball->r + ZERO1){    
		return(OUTSIDE);   
	} /* outside */
	else{
		if(r1 <  crs_ball->r - ZERO1){    
			return(INSIDE);   
		} /* inside */
		else{
			return(1); /* on line */
		}
	}
}

/*------------------------------------------------------------

  Function : cross_point(HPoint,HPoint,HPoint *,HPlane *,int)

-------------------------------------------------------------*/
cross_point(p1,p2,p3,crs_ball,side)
HPoint p1;
HPoint p2;
HPoint *p3;
HPlane    *crs_ball;
int side;
{
	double x1,x2,y1,y2,z1,z2,l,m,n,k1,k2;
	int b1,b2;

	b1 = in_out_ball(&p1,crs_ball);
	b2 = in_out_ball(&p2,crs_ball);

	if((b1 == 1)&&(b2 == side)){
		p3->x = p1.x;
		p3->y = p1.y;
		p3->z = p1.z;
	}
	else{
		if((b1 == side)&&(b2 == 1)){
			p3->x = p2.x;
			p3->y = p2.y;
			p3->z = p2.z;
		}
		else{
			x1 = p1.x - p2.x;
			y1 = p1.y - p2.y;
			z1 = p1.z - p2.z;
			x2 = p2.x - crs_ball->x;
			y2 = p2.y - crs_ball->y;
			z2 = p2.z - crs_ball->z;

			l = x1*x1 + y1*y1 + z1*z1;
			m = 2.0*(x1*x2 + y1*y2 + z1*z2);
			n = x2*x2 + y2*y2 + z2*z2 - crs_ball->r*crs_ball->r;

			k1 = ((-1.0)*m + sqrt(m*m - 4.0*l*n))/(2.0*l);
			k2 = ((-1.0)*m - sqrt(m*m - 4.0*l*n))/(2.0*l);
			if((k1>=-1.0*ZERO2)&&(k1<=1.0+ZERO2)){
				p3->x = k1*x1 + p2.x;
				p3->y = k1*y1 + p2.y;
				p3->z = k1*z1 + p2.z;
			}
			else{
				if((k2>=-1.0*ZERO2)&&(k2<=1.0+ZERO2)){
					p3->x = k2*x1 + p2.x;
					p3->y = k2*y1 + p2.y;
					p3->z = k2*z1 + p2.z;
				}
				else{
					/*          printf("k1 %30.15f b1 %d p1.x %f \nk2 %30.15f b2 %d p2.x %f\n",k1,b1,p1.x,k2,b2,p2.x);
					          printf("ERROR NOT CROSS\n");*/
					;
				}
			}
		}
	}
}

