/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  select_menu.c: Functions for select menu.                    */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <stdio.h>   
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include "source/Hcad.h"

#include "Hcadext.h"

/*------------------------------------------------------------

  Function : select_menu(int)

-------------------------------------------------------------*/
select_menu(invert_num)
int invert_num;
{

	int looping,i,cnt;
	char text_buffer[40], s[5];
	int text_width;
	XSetWindowAttributes  atr;

	sub_menuhint.x = 400;
	sub_menuhint.y = 35 + 20*invert_num;
	sub_menuhint.width = 0;
	sub_menuhint.height = 0;
	sub_menuhint.flags = PPosition | PSize;

	/*  Select menu */
	switch(invert_num){
	case 0:
		/* select plane */
		sub_menuhint.width = 340;
		sub_menuhint.height = 150;
		break;
	case 1:
		/* select line*/
		sub_menuhint.width = 340;
		sub_menuhint.height = 190;
		break;
	default:
		return;
		break;
	}

	sub_menuwin = XCreateSimpleWindow(disp,basewin,sub_menuhint.x,sub_menuhint.y,
	sub_menuhint.width,sub_menuhint.height,
	2,black,white);
	sub_menugc = XCreateGC(disp,sub_menuwin,0,0);
	XSetBackground(disp,sub_menugc,white);
	XSetForeground(disp,sub_menugc,black);
	XSetFunction(disp,sub_menugc,GXcopy);
        if(font_flg == TRUE){
          XSetFont(disp,sub_menugc,font);
        }
	atr.save_under = True;
	XChangeWindowAttributes(disp,sub_menuwin,CWSaveUnder,&atr);
	XMapRaised(disp,sub_menuwin);
	looping = 0;
	init_select_menu(invert_num);
	XWarpPointer(disp,None,sub_menuwin,0,0,0,0,100,40);
	cnt = 0;
	while(looping == 0){
		if(XEventsQueued(disp,QueuedAfterReading)==0){
			XFlush(disp);
		}
		XNextEvent(disp,&ev);

		switch(ev.type){
		case MotionNotify:
			if(ev.xmotion.subwindow != sub_menuwin){
				looping = 1;
			}
			break; 
		case ButtonPress:
			select_menu_act(invert_num);        
			break;

		default:
			break;
		}
	}
	XFreeGC(disp,sub_menugc);
	XDestroyWindow(disp,sub_menuwin);
}      

/*------------------------------------------------------------

  Function : init_select_menu(int)

-------------------------------------------------------------*/
init_select_menu(invert_num)
int invert_num;
{
	int i;
	char text_buffer[50];

	switch(invert_num){
	case 0:
		XClearWindow(disp,sub_menuwin);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,336,146);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,332,142);
		XDrawString(disp,sub_menuwin,sub_menugc,100,25,"<< SELECT PLANE >>",
		strlen("<< SELECT PLANE >>"));
		sprintf(text_buffer,"  Total Plane         --- %d",total_plane);
		XDrawString(disp,sub_menuwin,sub_menugc,40,45,text_buffer,strlen(text_buffer));
		if(select_plane == -1){
			sprintf(text_buffer,"  Selected Plane ID   --- None");
		}
		else{
			sprintf(text_buffer,"  Selected Plane ID   --- %d",select_plane);
		}
		XDrawString(disp,sub_menuwin,sub_menugc,40,65,text_buffer,strlen(text_buffer));
		if(select_flg == ON){
			sprintf(text_buffer,"  Select flag         --- [ ON ]");
		}
		else{
			sprintf(text_buffer,"  Select flag         --- [ OFF ]");
		}
		XDrawString(disp,sub_menuwin,sub_menugc,40,85,text_buffer,strlen(text_buffer));

		draw_button(sub_menuwin,sub_menugc,10,110,70,30,
		30,130,"Next");
		draw_button(sub_menuwin,sub_menugc,90,110,70,30,
		110,130,"Pre");
		draw_button(sub_menuwin,sub_menugc,170,110,70,30,
		180,130,"Select");
		draw_button(sub_menuwin,sub_menugc,250,110,70,30,
		255,130,"Not Select");
		break;

	case 1:
		XClearWindow(disp,sub_menuwin);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,336,186);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,332,182);
		XDrawString(disp,sub_menuwin,sub_menugc,100,25,"<< SELECT LINE >>",
		strlen("<< SELECT LINE >>"));
		sprintf(text_buffer,"  Total Line          --- %d",total_line);
		XDrawString(disp,sub_menuwin,sub_menugc,40,45,text_buffer,strlen(text_buffer));
		if(select_line == -1){
			sprintf(text_buffer,"  Selected Line ID    --- None");
		}
		else{
			sprintf(text_buffer,"  Selected Line ID    --- %d",select_line);
		}
		XDrawString(disp,sub_menuwin,sub_menugc,40,65,text_buffer,strlen(text_buffer));
		if(select_l_flg == ON){
			sprintf(text_buffer,"  Select flag         --- [ ON ]");
		}
		else{
			sprintf(text_buffer,"  Select flag         --- [ OFF ]");
		}
		XDrawString(disp,sub_menuwin,sub_menugc,40,85,text_buffer,strlen(text_buffer));
		if(select_line != -1){
			sprintf(text_buffer,"  component plane ID  --- [%d],[%d]",line1[select_line].id1,
			line1[select_line].id2);
			XDrawString(disp,sub_menuwin,sub_menugc,40,105,text_buffer,
			strlen(text_buffer));
		}
		if(select_line != -1){
			sprintf(text_buffer,"  Angle               --- [%6.2f]"
			    ,line1[select_line].angle);
			XDrawString(disp,sub_menuwin,sub_menugc,40,125,text_buffer
			    ,strlen(text_buffer));
			if(line1[select_line].length == -1.0){
				sprintf(text_buffer,"  Hyperbolic distance --- [     Infinity ]");
			}
			else{
				sprintf(text_buffer,"  Hyperbolic distance --- [ %12.6f ]"
				    ,line1[select_line].length);
			}
			XDrawString(disp,sub_menuwin,sub_menugc,40,145,text_buffer
			    ,strlen(text_buffer));
		}
		draw_button(sub_menuwin,sub_menugc,10,150,70,30,
		30,170,"Next");
		draw_button(sub_menuwin,sub_menugc,90,150,70,30,
		110,170,"Pre");
		draw_button(sub_menuwin,sub_menugc,170,150,70,30,
		180,170,"Select");
		draw_button(sub_menuwin,sub_menugc,250,150,70,30,
		255,170,"Not Select");
		break;
	default:
		break;
	}
}

/*------------------------------------------------------------

  Function : select_menu_act(int)

-------------------------------------------------------------*/
select_menu_act(invert_num)
int invert_num;
{
	int i;
	char text_buffer[10];
	switch(invert_num){
	case 0:
		if(ev.xbutton.y > sub_menuhint.y+100){
			if((ev.xbutton.x>sub_menuhint.x+10)&&(ev.xbutton.x<sub_menuhint.x+80)){
				select_plane++;
				if(select_plane == total_plane){
					select_plane--;
				} 
				else{
					if(select_flg == ON){
						XClearWindow(disp,drawin);
						show_object(0);
					}
				}       
				init_select_menu(invert_num);
				return;
			}
			if((ev.xbutton.x>sub_menuhint.x+90)&&(ev.xbutton.x<sub_menuhint.x+160)){
				select_plane--;
				if(select_plane < -1){
					select_plane = -1;
				}
				else{
					if(select_flg == ON){
						XClearWindow(disp,drawin);
						show_object(0);
					}
				}       
				init_select_menu(invert_num);
				return;
			}
			if((ev.xbutton.x>sub_menuhint.x+170)&&(ev.xbutton.x<sub_menuhint.x+240)){
				select_flg = ON;
				init_select_menu(invert_num);
				XClearWindow(disp,drawin);
				show_object(0);
				return;
			}
			if((ev.xbutton.x>sub_menuhint.x+250)&&(ev.xbutton.x<sub_menuhint.x+320)){
				select_flg = OFF;
				init_select_menu(invert_num);
				XClearWindow(disp,drawin);
				show_object(0);
				return;
			}
		}
		break;

	case 1:
		if(ev.xbutton.y > sub_menuhint.y+150){
			if((ev.xbutton.x>sub_menuhint.x+10)&&(ev.xbutton.x<sub_menuhint.x+80)){
				select_line++;
				if(select_line == total_line){
					select_line--;
				}
				else{
					if(select_l_flg == ON){
						XClearWindow(disp,drawin);
						show_object(0);
					}
				}       
				init_select_menu(invert_num);
				return;
			}
			if((ev.xbutton.x>sub_menuhint.x+90)&&(ev.xbutton.x<sub_menuhint.x+160)){
				select_line--;
				if(select_line < -1){
					select_line = -1;
				}
				else{
					if(select_l_flg == ON){
						XClearWindow(disp,drawin);
						show_object(0);
					}
				}       
				init_select_menu(invert_num);
				return;
			}
			if((ev.xbutton.x>sub_menuhint.x+170)&&(ev.xbutton.x<sub_menuhint.x+240)){
				select_l_flg = ON;
				init_select_menu(invert_num);
				XClearWindow(disp,drawin);
				show_object(0);
				return;
			}
			if((ev.xbutton.x>sub_menuhint.x+250)&&(ev.xbutton.x<sub_menuhint.x+320)){
				select_l_flg = OFF;
				init_select_menu(invert_num);
				XClearWindow(disp,drawin);
				show_object(0);
				return;
			}
		}
		break;

	default:
		break;
	}
}


