/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  print_menu.c: Functions for print menu window.               */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <stdio.h>   
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include "source/Hcad.h"

#include "source/Hcadext.h"


/*------------------------------------------------------------

  Function : print_menu(int)

-------------------------------------------------------------*/
print_menu(invert_num)
int invert_num;
{
	FILE *fp;  
	int looping,i,cnt;
	char text_buffer[40], s[5],sys_com[40],file_tmp[40];
	int text_width;
	XSetWindowAttributes  atr;

	sub_menuhint.x = 170;
	sub_menuhint.y = 35 + 20*invert_num;
	sub_menuhint.width = 300;
	sub_menuhint.height =100;
	sub_menuhint.flags = PPosition | PSize;

	/*  File menu */
	if(invert_num == 0){
		/* print out menu */
		sprintf(file_tmp,"%shyper.ps",work_path);
		if((fp = fopen(file_tmp,"w"))!=0){
			fprintf(fp,"0 setlinewidth\n");
			show_object(fp);
			fprintf(fp,"showpage\n");
			fclose(fp);
			sprintf(sys_com,"%s %s",print_com,file_tmp);
			system(sys_com);
			sprintf(sys_com,"rm %s",file_tmp);
			system(sys_com);
			XWarpPointer(disp,None,basewin,0,0,0,0,200,200);
			return;
		}
	}
	if(invert_num > 3){
		XWarpPointer(disp,None,basewin,0,0,0,0,200,200);
		return;
	}

	if(invert_num == 3){
		sub_menuhint.width = 350;
		sub_menuhint.height =280;
	}
	sub_menuwin = XCreateSimpleWindow(disp,basewin,sub_menuhint.x,sub_menuhint.y,
	sub_menuhint.width,sub_menuhint.height,
	2,black,white);
	sub_menugc = XCreateGC(disp,sub_menuwin,0,0);
	XSetBackground(disp,sub_menugc,white);
	XSetForeground(disp,sub_menugc,black);
	XSetFunction(disp,sub_menugc,GXcopy);
        if(font_flg == TRUE){
          XSetFont(disp,sub_menugc,font);
        }
	atr.save_under = True;
	XChangeWindowAttributes(disp,sub_menuwin,CWSaveUnder,&atr);
	XMapRaised(disp,sub_menuwin);
	looping = 0;
	show_print_menu(invert_num,0);
	XWarpPointer(disp,None,sub_menuwin,0,0,0,0,40,20);
	cnt = 0;
	while(looping == 0){
		if(XEventsQueued(disp,QueuedAfterReading)==0){
			XFlush(disp);
		}
		XNextEvent(disp,&ev);

		switch(ev.type){
		case MotionNotify:
			if(ev.xmotion.subwindow != sub_menuwin){
				looping = 1;
			}
			break; 
		case ButtonPress:
			print_button_act(invert_num); 
			break;

		case KeyPress:
			i=XLookupString(&ev,s,20,&mykey,0);
			if((i == 1)&&((invert_num == 1)||(invert_num == 2))){
				switch(s[0]){
				case '\b':
					if(cnt>0){
						cnt--;
						text_buffer[cnt] = '\0';
						draw_inv_str(sub_menuwin,sub_menugc,ON,10,50,200,25,
						13,65,text_buffer);
					}
					break;
				case '\n':
				case 13:
					if(strlen(text_buffer)!=0){
						if(invert_num == 2){
							text_buffer[cnt]=' ';
							text_buffer[cnt+1] = '\0';
						}
						if(print_menu_act(text_buffer,invert_num)==FALSE){
							show_print_menu(invert_num,1);
						}
					}
					break;

				default:
					if (isprint(s[0]) != 0){
						if(cnt<20){
							text_buffer[cnt] = s[0];
							text_buffer[cnt+1] = '\0';
							if(cnt==0){
								text_buffer[1] = '\0';
							}    
							draw_inv_str(sub_menuwin,sub_menugc,ON,10,50,200,25,
							13,65,text_buffer);
							cnt++;
						}
					}
				}
			}
		default:
			break;
		}
	}
	XFreeGC(disp,sub_menugc);
	XDestroyWindow(disp,sub_menuwin);
}      

/*------------------------------------------------------------

  Function : show_print_menu(int,int)

-------------------------------------------------------------*/
show_print_menu(invert_num,flg)
int invert_num;
int flg;
{

	char text_buffer[40];
	int i;

	switch(invert_num){
	case 0:
		XClearWindow(disp,sub_menuwin);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,296,96);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,292,92);
		if(flg == 0){        
			XDrawImageString(disp,sub_menuwin,sub_menugc,30,40,
			"*** Bad work directory ***",strlen("*** Bad work directory ***"));
		}
		break;

	case 1:
		strcpy(text_buffer,work_path);
		strcat(text_buffer,ps_file);
		XClearWindow(disp,sub_menuwin);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,296,96);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,292,92);
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,20
		    ,"--Input Postscript file  Name--",
		strlen("--Input Postscript file Name--"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,10,40,text_buffer
		    ,strlen(text_buffer));
		XDrawLine(disp,sub_menuwin,sub_menugc,10,45,200,45);
		draw_inv_str(sub_menuwin,sub_menugc,ON,10,50,200,25,
		13,65," ");
		if(flg == 1){        
			XDrawImageString(disp,sub_menuwin,sub_menugc,10,90,
			"*** Bad work directory ***",strlen("*** Bad work directory ***"));
		}
		if(flg == 2){        
			XDrawImageString(disp,sub_menuwin,sub_menugc,10,90,
			"*** Making file ***",strlen("*** Making file ***"));
		}
		break;
	case 2:
		XClearWindow(disp,sub_menuwin);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,296,96);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,292,92);
		XDrawImageString(disp,sub_menuwin,sub_menugc,50,20,"--- print command ---",
		strlen("--- print command ---"));
		XDrawImageString(disp,sub_menuwin,sub_menugc,30,40,print_com,
		strlen(print_com));
		XDrawLine(disp,sub_menuwin,sub_menugc,10,45,250,45);
		draw_inv_str(sub_menuwin,sub_menugc,ON,10,50,200,25,
		13,65," ");
		break;
	case 3:
		XClearWindow(disp,sub_menuwin);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,2,2,346,276);
		XDrawRectangle(disp,sub_menuwin,sub_menugc,4,4,342,272);
		XDrawString(disp,sub_menuwin,sub_menugc,10,30,"* print coordinate",
		strlen("* print coordinate"));
		XDrawString(disp,sub_menuwin,sub_menugc,10,60,"* print unit ball",
		strlen("* print unit ball"));
		XDrawString(disp,sub_menuwin,sub_menugc,10,90,"* render",
		strlen("* render"));
		XDrawString(disp,sub_menuwin,sub_menugc,10,120,"* print header",
		strlen("* print header"));
		XDrawString(disp,sub_menuwin,sub_menugc,10,150,"* print line pattern",
		strlen("* print line pattern"));
		XDrawString(disp,sub_menuwin,sub_menugc,20,180,
		"1:Hidden lines are printed by solid lines",
		strlen("1:Hidden lines are printed by solid line"));
		XDrawString(disp,sub_menuwin,sub_menugc,20,205,
		"2:Hidden lines are printed by dotted lines",
		strlen("2:Hidden lines are printed by dotted lines"));
		XDrawString(disp,sub_menuwin,sub_menugc,20,230,
		"3:Hidden lines are not printed",
		strlen("3:Hidden lines are not printed"));

		XDrawString(disp,sub_menuwin,sub_menugc,20,255,
		"4:Every lines are not printed",
		strlen("4:Every lines are not printed"));

		for(i=0;i<4;i++){
			draw_button(sub_menuwin,sub_menugc,190,10+30*i,45,21,
			200,28+30*i,"YES");
			draw_button(sub_menuwin,sub_menugc,265,10+30*i,45,21,
			275,28+30*i,"N O");
		}

		if(pr_coord_flg == TRUE){
			draw_inv_str(sub_menuwin,sub_menugc,ON,192,12,42,18,
			200,28,"YES");
		}
		else{
			draw_inv_str(sub_menuwin,sub_menugc,ON,267,12,42,18,
			275,28,"N O");
		}
		if(pr_unit_flg == TRUE){
			draw_inv_str(sub_menuwin,sub_menugc,ON,192,42,42,18,
			200,58,"YES");
		}
		else{
			draw_inv_str(sub_menuwin,sub_menugc,ON,267,42,42,18,
			275,58,"N O");
		}
		if(pr_shadow_flg == ON){
			draw_inv_str(sub_menuwin,sub_menugc,ON,192,72,42,18,
			200,88,"YES");
		}
		else{
			draw_inv_str(sub_menuwin,sub_menugc,ON,267,72,42,18,
			275,88,"N O");
		}
		if(pr_header == TRUE){
			draw_inv_str(sub_menuwin,sub_menugc,ON,192,102,42,18,
			200,118,"YES");
		}
		else{
			draw_inv_str(sub_menuwin,sub_menugc,ON,267,102,42,18,
			275,118,"N O");
		}
		for(i = 0;i<4;i++){
			draw_button(sub_menuwin,sub_menugc,190+35*i,135,27,25,
			200+35*i,150," ");
		}
		draw_inv_str(sub_menuwin,sub_menugc,print_pattern == 1,192,137,24,22,
		200,150,"1");
		draw_inv_str(sub_menuwin,sub_menugc,print_pattern == 2,227,137,24,22,
		235,150,"2");
		draw_inv_str(sub_menuwin,sub_menugc,print_pattern == 3,262,137,24,22,
		270,150,"3");
		draw_inv_str(sub_menuwin,sub_menugc,print_pattern == 4,297,137,24,22,
		305,150,"4");
		break;
	default:
		break;
	}
}

/*------------------------------------------------------------

  Function : print_button_act(char *,int)

-------------------------------------------------------------*/
print_button_act(invert_num)
int invert_num;
{
	int i;
	char text_buffer[10];
	switch(invert_num){
	case 3:
		if((ev.xbutton.y > sub_menuhint.y+10)&&(ev.xbutton.y<sub_menuhint.y+35)){
			if((ev.xbutton.x>sub_menuhint.x+190)&&(ev.xbutton.x<sub_menuhint.x+235)
			    &&(pr_coord_flg == FALSE)){
				pr_coord_flg = TRUE;
				draw_inv_str(sub_menuwin,sub_menugc,ON,192,12,42,18,
				200,28,"YES");
				draw_inv_str(sub_menuwin,sub_menugc,OFF,267,12,42,18,
				275,28,"N O");
			}
			else{
				if((ev.xbutton.x>sub_menuhint.x+265)&&(ev.xbutton.x<sub_menuhint.x+310)
				    &&(pr_coord_flg == TRUE)){
					pr_coord_flg = FALSE;
					draw_inv_str(sub_menuwin,sub_menugc,OFF,192,12,42,18,
					200,28,"YES");
					draw_inv_str(sub_menuwin,sub_menugc,ON,267,12,42,18,
					275,28,"N O");
				}
			}
			return;
		}
		if((ev.xbutton.y > sub_menuhint.y+40)&&(ev.xbutton.y<sub_menuhint.y+65)){
			if((ev.xbutton.x>sub_menuhint.x+190)&&(ev.xbutton.x<sub_menuhint.x+235)
			    &&(pr_unit_flg == FALSE)){
				pr_unit_flg = TRUE;
				draw_inv_str(sub_menuwin,sub_menugc,ON,192,42,42,18,
				200,58,"YES");
				draw_inv_str(sub_menuwin,sub_menugc,OFF,267,42,42,18,
				275,58,"N O");
			}
			else{
				if((ev.xbutton.x>sub_menuhint.x+265)&&(ev.xbutton.x<sub_menuhint.x+310)
				    &&(pr_unit_flg == TRUE)){
					pr_unit_flg = FALSE;
					draw_inv_str(sub_menuwin,sub_menugc,OFF,192,42,42,18,
					200,58,"YES");
					draw_inv_str(sub_menuwin,sub_menugc,ON,267,42,42,18,
					275,58,"N O");
				}
			}
			return;
		}
		if((ev.xbutton.y > sub_menuhint.y+70)&&(ev.xbutton.y<sub_menuhint.y+95)){
			if((ev.xbutton.x>sub_menuhint.x+190)&&(ev.xbutton.x<sub_menuhint.x+235)
			    &&(pr_shadow_flg == OFF)){
				pr_shadow_flg = ON;
				draw_inv_str(sub_menuwin,sub_menugc,ON,192,72,42,18,
				200,88,"YES");
				draw_inv_str(sub_menuwin,sub_menugc,OFF,267,72,42,18,
				275,88,"N O");
			}
			else{
				if((ev.xbutton.x>sub_menuhint.x+265)&&(ev.xbutton.x<sub_menuhint.x+310)
				    &&(pr_shadow_flg == ON)){
					pr_shadow_flg = OFF;
					draw_inv_str(sub_menuwin,sub_menugc,OFF,192,72,42,18,
					200,88,"YES");
					draw_inv_str(sub_menuwin,sub_menugc,ON,267,72,42,18,
					275,88,"N O");
				}
			}
			return;
		}
		if((ev.xbutton.y > sub_menuhint.y+100)&&(ev.xbutton.y<sub_menuhint.y+125)){
			if((ev.xbutton.x>sub_menuhint.x+190)&&(ev.xbutton.x<sub_menuhint.x+235)
			    &&(pr_header == FALSE)){
				pr_header = TRUE;
				draw_inv_str(sub_menuwin,sub_menugc,ON,192,102,42,18,
				200,118,"YES");
				draw_inv_str(sub_menuwin,sub_menugc,OFF,267,102,42,18,
				275,118,"N O");
			}
			else{
				if((ev.xbutton.x>sub_menuhint.x+265)&&(ev.xbutton.x<sub_menuhint.x+310)
				    &&(pr_header == TRUE)){
					pr_header = FALSE;
					draw_inv_str(sub_menuwin,sub_menugc,OFF,192,102,42,18,
					200,118,"YES");
					draw_inv_str(sub_menuwin,sub_menugc,ON,267,102,42,18,
					275,118,"N O");
				}
			}
			return;
		}
		if((ev.xbutton.y > sub_menuhint.y+130)&&(ev.xbutton.y<sub_menuhint.y+155)){
			if((ev.xbutton.x>sub_menuhint.x+190)&&(ev.xbutton.x<sub_menuhint.x+220)
			    &&(print_pattern!=1)){
				print_pattern = 1;
			}
			if((ev.xbutton.x>sub_menuhint.x+225)&&(ev.xbutton.x<sub_menuhint.x+255)
			    &&(print_pattern!=2)){
				print_pattern = 2;
			}
			if((ev.xbutton.x>sub_menuhint.x+260)&&(ev.xbutton.x<sub_menuhint.x+290)
			    &&(print_pattern!=3)){
				print_pattern = 3;
			}
			if((ev.xbutton.x>sub_menuhint.x+295)&&(ev.xbutton.x<sub_menuhint.x+325)
			    &&(print_pattern!=4)){
				print_pattern = 4;
			}
			draw_inv_str(sub_menuwin,sub_menugc,print_pattern == 1,192,137,24,22,
			200,150,"1");
			draw_inv_str(sub_menuwin,sub_menugc,print_pattern == 2,227,137,24,22,
			235,150,"2");
			draw_inv_str(sub_menuwin,sub_menugc,print_pattern == 3,262,137,24,22,
			270,150,"3");
			draw_inv_str(sub_menuwin,sub_menugc,print_pattern == 4,297,137,24,22,
			305,150,"4");
		}
		break;

	default:
		break;
	}
}

/*------------------------------------------------------------

  Function : print_menu_act(char *,int)

-------------------------------------------------------------*/
int print_menu_act(text_buffer,invert_num)
char *text_buffer;
int invert_num;
{
	FILE *fp;
	char text_tmp[40],sys_com[50];

	switch(invert_num){
	case 1:
		strcpy(ps_file,text_buffer);
		sprintf(text_tmp,"%s%s",work_path,ps_file);
		show_print_menu(invert_num,2);
		if((fp = fopen(text_tmp,"w"))!=0){
			fprintf(fp,"0 setlinewidth\n");
			show_object(fp);
			fprintf(fp,"showpage\n");
			fclose(fp);
			show_print_menu(invert_num,0);
		}
		else{
			return(FALSE);
		}
		break;
	case 2:
		strcpy(print_com,text_buffer);
		show_print_menu(invert_num,0);
		break;
	default:
		break;
	}
	return(TRUE);
}            

