/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  demo_menu.c: Functions for demo menu window.                 */
/*                                                               */
/*                                                               */
/*****************************************************************/

#include <stdio.h>   
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
#include "source/Hcad.h"

#include "source/Hcadext.h"

/*------------------------------------------------------------

  Function : demo_menu(int)

-------------------------------------------------------------*/
demo_menu(invert_num)
int invert_num;
{

	int looping,i,cnt;
	char text_buffer[40];
	int text_width;
	int okbutton_flg,okbutton_x,okbutton_y;
	apollo_data demo_data;

	sub_menuhint.x = 170;
	sub_menuhint.y = 35 + 20*invert_num;
	sub_menuhint.width = 0;
	sub_menuhint.height = 0;
	sub_menuhint.flags = PPosition | PSize;

	/*  File menu */
	switch(invert_num){
	case 0:
		/* tetrahedron */
		strcpy(file_name,"tetra");
		strcpy(text_buffer,demo_path);
		strcat(text_buffer,file_name);
		get_data_demo(text_buffer);
		break;
	case 1:
		/* octahedron */
		strcpy(file_name,"octa");
		strcpy(text_buffer,demo_path);
		strcat(text_buffer,file_name);
		get_data_demo(text_buffer);
		break;
	case 2:
		/* truncated tetrahedron */
		strcpy(file_name,"trunc");
		strcpy(text_buffer,demo_path);
		strcat(text_buffer,file_name);
		get_data_demo(text_buffer);
		break;
	case 3:
		/* dodecahedron */
		strcpy(file_name,"dodeca");
		strcpy(text_buffer,demo_path);
		strcat(text_buffer,file_name);
		get_data_demo(text_buffer);
		break;
	case 4:
		/* icosahedron */
		strcpy(file_name,"icosa");
		strcpy(text_buffer,demo_path);
		strcat(text_buffer,file_name);
		get_data_demo(text_buffer);
		break;
	case 5:
		/* hexahedron */
		strcpy(file_name,"hexa");
		strcpy(text_buffer,demo_path);
		strcat(text_buffer,file_name);
		get_data_demo(text_buffer);
		break;
	default:
		return;
		break;
	}
}      

/*------------------------------------------------------------

  Function : get_data_demo(char *)

-------------------------------------------------------------*/
get_data_demo(text_buffer)
char *text_buffer;
{

	FILE *fp;
	double r1;
	float x,y,z;
	int side,ret;
	HPlane *pln_pt;
	char buf[100];

	total_plane = 0;
	fp = fopen(text_buffer,"r");
	if(fp != 0){
		init_plane();
		pln_pt = &plane[0];
		while(fgets(buf,100,fp)!=NULL){
			if((buf[0] == '0')||(buf[0] == '2')){
				ret = sscanf(buf,"%d (%f,%f,%f)",&side,&x,&y,&z);
				if(ret == 4){
					r1 = pow(x,2.0)+pow(y,2.0)+pow(z,2.0) - 1.0;
					if(r1>0.0){
						total_plane++;
						pln_pt->x = (double)x;
						pln_pt->y = (double)y;
						pln_pt->z = (double)z;
						pln_pt->side = side;
						pln_pt->r = sqrt(r1);
						pln_pt++;
					}
				}
			}
		}
		fclose(fp);
		clear_task();
		search_cross();
		show_object(0);
	}
}            

