/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  connect.c: Functions to connect Mathematica.                 */
/*                                                               */
/*                                                               */
/*****************************************************************/
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>

#include "source/Hcad.h"

#include "source/Hcadext.h"

int str_to_command(text)

char text[ ];
{
	int i,num;
	double x[3],r,s;
	float  xf,yf,zf;
	char com[3];

	sscanf(text,"%s %d %f %f %f\n",com,&num,&xf,&yf,&zf);
	switch(text[0]){
	case 'c': /* Clear all data */
		clear_task();
		init_plane();
		search_cross();
		show_object(0);
		return(1);
		break;
	case 'd': /* Delete a plane. */
		while(plane[num].r != 0.0){
			plane[num].x = plane[num+1].x;
			plane[num].y = plane[num+1].y;
			plane[num].z = plane[num+1].z;
			plane[num].r = plane[num+1].r;
			num++;
		}
		total_plane--;
		search_cross();
		show_object(0);
		return(1);
		break;
	case 'p': /* Add a plane. */
		x[0] = (double)xf;
		x[1] = (double)yf;
		x[2] = (double)zf;
		i=0;
		while(plane[i].r!=0.0){
			i++;
		}
		r = x[0]*x[0]+x[1]*x[1]+x[2]*x[2]-1.0;
		if(r>0.0){
			plane[i].side = num;
			plane[i].x = x[0];
			plane[i].y = x[1];
			plane[i].z = x[2];
			plane[i].r = sqrt(r);
			total_plane++;
			clear_task();
			search_cross();
			show_object(0);
			return(i);
		}
		break;
	default:
		return(-2);

	}
}








