/*****************************************************************/
/*                                                               */
/*          Copyright (c) 1991-1992 by J.Nisimoto                */
/*                                                               */
/*                   H  c  a  d  3  D  - Ver 2.0                 */
/*                                                               */
/*  Permission to use,copy,modify,and distribute this software.  */
/*                                                               */
/*  Hcad_sub.c: Functions to classify inputs and change          */
/*             coordinate.                                       */
/*                                                               */
/*****************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include "source/Hcad.h"

#include "source/Hcadext.h"

/*------------------------------------------------------------

  Function : check_button()

-------------------------------------------------------------*/
check_button(){

	/* Button is pressed in butt1 */
	if(ev.xbutton.subwindow==drawin){
		XClearWindow(disp,drawin);
		if(ev.xbutton.x<250){
			if(ev.xbutton.y<220){
				XDefineCursor(disp,drawin,cur[5]);
				change_unit(8,rotation_angle);
				show_object(0);
			}
			else{
				if(ev.xbutton.y>440){
					XDefineCursor(disp,drawin,cur[7]);
					change_unit(6,rotation_angle);
					show_object(0);
				}
				else{
					XDefineCursor(disp,drawin,cur[1]);
					change_unit(2,rotation_angle);
					show_object(0);
				}
			}
		}
		else{
			if(ev.xbutton.x>500){
				if(ev.xbutton.y<220){
					XDefineCursor(disp,drawin,cur[4]);
					change_unit(5,rotation_angle);
					show_object(0);
				}
				else{
					if(ev.xbutton.y>440){
						XDefineCursor(disp,drawin,cur[6]);
						change_unit(7,rotation_angle);
						show_object(0);
					}
					else{
						XDefineCursor(disp,drawin,cur[0]);
						change_unit(1,rotation_angle);
						show_object(0);
					}
				}
			}
			else{
				if(ev.xbutton.y<220){
					XDefineCursor(disp,drawin,cur[2]);
					change_unit(3,rotation_angle);
					show_object(0);
				}
				else{
					if(ev.xbutton.y>440){
						XDefineCursor(disp,drawin,cur[3]);
						change_unit(4,rotation_angle);
						show_object(0);
					}
					else{
						clear_task();
						show_object(0);
					}
				}
			}
		}
	}

	if(ev.xbutton.subwindow == menubar){
		menu_task(ev.xbutton.x / 100);
	}        
}


/*------------------------------------------------------------

  Function : clear_task()

-------------------------------------------------------------*/
clear_task(){
	XClearWindow(disp,drawin);
	coord[0].x = 1.0;
	coord[0].y = 0.0;
	coord[0].z = 0.0;
	coord[1].x = 0.0;
	coord[1].y = 1.0;
	coord[1].z = 0.0;
	coord[2].x = 0.0;
	coord[2].y = 0.0;
	coord[2].z = 1.0;
	view_vect.x = 0.0;
	view_vect.y = 0.0;
	view_vect.z = 1.0;

}

/*------------------------------------------------------------

  Function : make_view()

-------------------------------------------------------------*/
make_view(){
	double k1,k2,d1,d2,d3;
	int pat;

	d1 = coord[1].x * coord[2].y - coord[1].y * coord[2].x;
	d2 = coord[0].y * coord[2].x - coord[0].x * coord[2].y;
	d3 = coord[0].x * coord[1].y - coord[0].y * coord[1].x;

	if(fabs(d1) >= 0.00001){
		pat = 1;
	}
	else{
		if(fabs(d2) >= 0.00001){
			pat = 2;
		}
		else{
			pat = 3;
		}
	}
	switch(pat){
	case 1:
		k1 = (coord[0].y * coord[2].x - coord[0].x * coord[2].y)/d1;
		k2 = (coord[0].x * coord[1].y - coord[0].y * coord[1].x)/d1;
		view_vect.x = 1.0/(coord[0].z + coord[1].z * k1 + coord[2].z * k2);
		view_vect.y = k1 * view_vect.x;
		view_vect.z = k2 * view_vect.x;
		break;

	case 2:
		k1 = (coord[1].x * coord[2].y - coord[1].y * coord[2].x)/d2;
		k2 = (coord[0].x * coord[1].y - coord[0].y * coord[1].x)/d2;
		view_vect.y = 1.0/(coord[0].z * k1 + coord[1].z + coord[2].z * k2);
		view_vect.x = k1 * view_vect.y;
		view_vect.z = k2 * view_vect.y;
		break;

	case 3:
		k1 = (coord[1].x * coord[2].y - coord[1].y * coord[2].x)/d3;
		k2 = (coord[0].y * coord[2].x - coord[0].x * coord[2].y)/d3;
		view_vect.z = 1.0/(coord[0].z * k1 + coord[1].z * k2 + coord[2].z);
		view_vect.x = k1 * view_vect.z;
		view_vect.y = k2 * view_vect.z;
		break;

	}
}



/*------------------------------------------------------------

  Function : change_unit(int,double)

-------------------------------------------------------------*/
change_unit(direc,angle)
int direc;
double angle;
{
	double ang;
	double c1,s1;
	double px,py,pz;
	int i;

	ang = angle*PIE/180;
	c1 = cos(ang);
	s1 = sin(ang);
	switch(direc){
	case 1:/* RIGHT */
		for(i=0;i<3;i++){
			px = c1*coord[i].x + s1*coord[i].z;
			py = coord[i].y;
			pz = -s1*coord[i].x+ c1*coord[i].z;
			coord[i].x = px;
			coord[i].y = py;
			coord[i].z = pz;
		}
		break;
	case 2:/* LEFT */
		for(i=0;i<3;i++){
			px = c1*coord[i].x - s1*coord[i].z;
			py = coord[i].y;
			pz = s1*coord[i].x + c1*coord[i].z;
			coord[i].x = px;
			coord[i].y = py;
			coord[i].z = pz;
		}
		break;
	case 3:/* upward */
		for(i=0;i<3;i++){
			px = coord[i].x;
			py = c1*coord[i].y + s1*coord[i].z;
			pz = -s1*coord[i].y+ c1*coord[i].z;
			coord[i].x = px;
			coord[i].y = py;
			coord[i].z = pz;
		}
		break;
	case 4:/* downward */
		for(i=0;i<3;i++){
			px = coord[i].x;
			py = c1*coord[i].y - s1*coord[i].z;
			pz = s1*coord[i].y + c1*coord[i].z;
			coord[i].x = px;
			coord[i].y = py;
			coord[i].z = pz;
		}
		break;

	case 5:/* upward to the right*/
		for(i=0;i<3;i++){
			px = (c1+1.0)*coord[i].x+(c1-1.0)*coord[i].y 
			    + sqrt(2.0)*s1*coord[i].z;
			py = (c1-1.0)*coord[i].x+(c1+1.0)*coord[i].y 
			    + sqrt(2.0)*s1*coord[i].z;
			pz = -sqrt(2.0)*s1*(coord[i].x + coord[i].y)
				+ 2.0*c1*coord[i].z;
			coord[i].x = px/2.0;
			coord[i].y = py/2.0;
			coord[i].z = pz/2.0;
		}
		break;

	case 6:/* downward to the left*/
		for(i=0;i<3;i++){
			px = (c1+1.0)*coord[i].x+(c1-1.0)*coord[i].y 
			    - sqrt(2.0)*s1*coord[i].z;
			py = (c1-1.0)*coord[i].x+(c1+1.0)*coord[i].y 
			    - sqrt(2.0)*s1*coord[i].z;
			pz = sqrt(2.0)*s1*(coord[i].x + coord[i].y)
				+ 2.0*c1*coord[i].z;
			coord[i].x = px/2.0;
			coord[i].y = py/2.0;
			coord[i].z = pz/2.0;
		}
		break;

	case 7:/* downward to the right*/
		for(i=0;i<3;i++){
			px = (c1+1.0)*coord[i].x+(-c1+1.0)*coord[i].y 
			    + sqrt(2.0)*s1*coord[i].z;
			py = (-c1+1.0)*coord[i].x+(c1+1.0)*coord[i].y 
			    - sqrt(2.0)*s1*coord[i].z;
			pz = -sqrt(2.0)*s1*(coord[i].x - coord[i].y)
				+ 2.0*c1*coord[i].z;
			coord[i].x = px/2.0;
			coord[i].y = py/2.0;
			coord[i].z = pz/2.0;
		}
		break;

	case 8:/* upward to the left*/
		for(i=0;i<3;i++){
			px = (c1+1.0)*coord[i].x+(-c1+1.0)*coord[i].y 
			    - sqrt(2.0)*s1*coord[i].z;
			py = (-c1+1.0)*coord[i].x+(c1+1.0)*coord[i].y 
			    + sqrt(2.0)*s1*coord[i].z;
			pz = sqrt(2.0)*s1*(coord[i].x - coord[i].y)
				+ 2.0*c1*coord[i].z;
			coord[i].x = px/2.0;
			coord[i].y = py/2.0;
			coord[i].z = pz/2.0;
		}
		break;
	}
	make_view();
}


/*------------------------------------------------------------

  Function : draw_button()

-------------------------------------------------------------*/
draw_button(win1,gc1,x1,y1,w1,h1,x2,y2,str)
Window win1;
GC gc1;
int x1,y1,w1,h1,x2,y2;
char *str;
{
	XDrawRectangle(disp,win1,gc1,x1,y1,w1,h1);
	XDrawRectangle(disp,win1,gc1,x1-2,y1-2,w1+4,h1+4);
	XDrawLine(disp,win1,gc1,x1-1,y1+h1+1,x1+w1,y1+h1+1);
	XDrawLine(disp,win1,gc1,x1+w1+1,y1-1,x1+w1+1,y1+h1+1);
	XDrawString(disp,win1,gc1,x2,y2,str,strlen(str));
}













