(***************************************************************************)
(*      Copyright (c)  1992 by J.Nisimoto                                  *)
(*            Library for Hcad3D.                                          *)
(***************************************************************************)

(**********************  ChangeForm[pnt] ***************************************)
(* $@%U%!%$%k$K=PNO$9$k$?$a$K%G!<%?$rJQ7A$9$k!#(J                                  *)
(*******************************************************************************)

ChangeForm[pnt_] :=
	Block[{str,ap},
		ap = pnt;
		If[N[Abs[ap[[1]]]]<0.000001,ap[[1]] = 0];
		If[N[Abs[ap[[2]]]]<0.000001,ap[[2]] = 0];
		If[N[Abs[ap[[3]]]]<0.000001,ap[[3]] = 0];

		If[Length[ap] == 4,
			If[N[Abs[ap[[4]]]]<0.000001,ap[[4]] = 0];
			str = StringJoin[ToString[ap[[1]]]," (",
				ToString[ap[[2]]],",",ToString[ap[[3]]],
				",",ToString[ap[[4]]],")"],
			str = StringJoin["0 (",
				ToString[ap[[1]]],",",ToString[ap[[2]]],
				",",ToString[ap[[3]]],")"]];
		Return[str];
	]
(*******************  MatA[x,y]   **********************************************)
(* $@#2$D$N0l<!J,?tJQ49(J x,y $@$r3]$1$k!#(J                                           *)
(*******************************************************************************)
MatA[x_,y_] :=
	Block[{ans},
		ans = N[{x[[1]] y[[1]] + x[[2]] y[[3]],x[[1]] y[[2]] + x[[2]] y[[4]],
                       x[[3]] y[[1]] + x[[4]] y[[3]],x[[3]] y[[2]] + x[[4]] y[[4]]}];
		Return[ans];
	]

(*******************  Makefourth[comp1,p1,p2,p3]  ******************************)
(* $@$3$N4X?t$O(J $@<!$N$h$&$J>r7o$,M?$($i$l$?;~!"%]%"%s%+%l%G%#%9%/>e$K;MLLBN$r(J     *)
(* $@7h$a$k4X?t$G$9!#(J                                                            *)
(* $@!c>r7o!d(J  $@;MLLBN$N3FLL3Q$r7h$a$kJ#AG?t$r(Jcomp1$@$KM?$($k!#(J                     *)
(*           $@G$0U$K7h$a$k$3$H$,=PMh$k#3E@$r$9$Y$F(Jz$@!a#0$NJ?LL>e$K<h$j!"(J         *)
(*           $@$=$N%f!<%/%j%C%I:BI8!J;0<!85!K$r(Jp1,p2,p3$@$KM?$($k!#(J                *)
(* $@!cJVCM!d(J  $@#4E@L\$N%f!<%/%j%C%I:BI8!#!J$?$@$7(Jz$@!d#0!K(J                         *)
(*******************************************************************************)

Makefourth[comp1_,p1_,p2_,p3_]:=
	Block[{a,b,cos1,cos2,cos3,s,t,u,q1,q2,q3,x,y,z,ans,siki1},
		q1 = {p1[[2]]-p2[[2]],p2[[1]]-p1[[1]]}/
			(p1[[2]] p2[[1]] - p1[[1]] p2[[2]]);
		q2 = {p2[[2]]-p3[[2]],p3[[1]]-p2[[1]]}/
			(p2[[2]] p3[[1]] - p2[[1]] p3[[2]]);
		q3 = {p3[[2]]-p1[[2]],p1[[1]]-p3[[1]]}/
			(p3[[2]] p1[[1]] - p3[[1]] p1[[2]]);
		a = Re[comp1];
		b = Im[comp1];
		cos1 = a/Sqrt[a^2 + b^2];
		cos2 = (1-a)/Sqrt[(a-1)^2 + b^2];
		cos3 = (a^2 + b^2 - a)/Sqrt[((a^2 + b^2)((1-a)^2 + b^2))];
                ans = {x,y,z} /. 
			Solve[{q1[[1]] x + q1[[2]] y + s z,
			       q2[[1]] x + q2[[2]] y + t z,
			       q3[[1]] x + q3[[2]] y + u z} == {1,1,1},{x,y,z}][[1]];
		s = Sqrt[((q1[[1]]^2 + q1[[2]]^2 - 1) cos1^2)/(1-cos1^2)];
		t = Sqrt[((q2[[1]]^2 + q2[[2]]^2 - 1) cos2^2)/(1-cos2^2)];
		u = Sqrt[((q3[[1]]^2 + q3[[2]]^2 - 1) cos3^2)/(1-cos3^2)];
		s = If[N[cos1]<0.0,-s,s];
		t = If[N[cos2]<0.0,-t,t];
		u = If[N[cos3]<0.0,-u,u];
		Return[N[ans]];
	]


(*******************  Makew[comp1]  ********************************************)
(* $@$3$N4X?t$O(J z $@$,M?$($i$l$?;~(J w $@$r5a$a$k4X?t!#(J                                *)
(*******************************************************************************)

Makew[comp1_] :=
	Block[{comp2},
		comp2 = N[(1 + Sqrt[1 + 4/(comp1 (comp1 - 1))])/2];
		comp2 = If[Im[comp2]<0,N[(1 - Sqrt[1 + 4/(comp1 (comp1 - 1))])/2]
					,comp2];
		Return[comp2];
	]

(*******************  PointToComp[p1]  *****************************************)
(* $@$3$N4X?t$O%]%"%s%+%l5e>e$N%f!<%/%j%C%I:BI8$,(Jp1$@$KM?$($i$l$?;~(J                *)
(* $@%9%F%l%*%0%i%U%#%C%/%W%m%8%'%/%7%g%s$K$h$j$=$NE@$rJ#AG?t$K(J                  *)
(* $@JQ49$9$k!#(J                                                                  *)
(*******************************************************************************)

PointToComp[p1_] :=
	Block[{a,b},
		If[p1[[3]] == 1,Return[Infinity]];
		a = p1[[1]]/(1-p1[[3]]);
		b = p1[[2]]/(1-p1[[3]]); 
		Return[N[a + b I]];
	]

(************************** CompToPoint[comp1] *********************************)
(* $@$3$N4X?t$OJ#AG?t(Jcomp1$@$,M?$($i$l$?;~$=$l$r>e$N5U$G%]%"%s%+%l5e>e$N(J           *)
(* $@;0<!85:BI8$KJQ49$9$k4X?t$G$"$k!#(J                                            *)
(*******************************************************************************)

CompToPoint[comp1_] :=
	Block[{comp2,k},
		If[comp1 == Infinity,Return[{0,0,1}]];
		comp2 = Conjugate[comp1];
		k = Abs[comp1]^2 + 1;
		Return[{Re[comp1 + comp2],Im[comp1 - comp2],Abs[comp1]^2-1}/k];
	]

(**********************  FracFunc[z1,z2,z3,w1,w2,w3] ***************************)
(* $@$3$N4X?t$O%]%"%s%+%l5e>e!J5eFb$G$O$$$1$J$$!K$N#3E@(J($@:BI8$OJ#AG?t(Jz1,z2,z3$@!K$r(J *)
(* $@F1$8$/%]%"%s%+%l5e>e$N#3E@(J(w1,w2,w3)$@$K0\$90l<!J,?tJQ49$r5a$a$k4X?t$G$"$k!#(J  *)
(* $@!cJVCM!d(J  {a,b,c,d}                                                         *)
(*                              az + b                                         *)
(*               $@JVCM$N0UL#(J     ------                                         *)
(*                              cz + d                                         *)
(*******************************************************************************)

FracFunc[z1_,z2_,z3_,w1_,w2_,w3_] := 
	Block[{a,b,c,d,ans,ans2,ans3,ans4,s1,s2,s3,flg},
		s1 = a z1 + b - w1 (c z1 + d);
		If[(z1 == Infinity) && (w1 == Infinity),s1 = c];
 		If[(z1 == Infinity) && (N[Abs[w1]] < Infinity),s1 = a - c w1];
		If[(N[Abs[z1]] < Infinity) && (w1 == Infinity),s1 = c z1 + d];

		s2 = a z2 + b - w2 (c z2 + d);
		If[(z2 == Infinity) && (w2 == Infinity),s2 = c];
		If[(z2 == Infinity) && (N[Abs[w2]] < Infinity),s2 = a - c w2];
		If[(N[Abs[z2]] < Infinity) && (w2 == Infinity),s2 = c z2 + d];

		s3 = a z3 + b - w3 (c z3 + d);
		If[(z3 == Infinity) && (w3 == Infinity),s3 = c];
		If[(z3 == Infinity) && (N[Abs[w3]] < Infinity),s3 = a - c w3];
		If[(N[Abs[z3]] < Infinity) && (w3== Infinity),s3 = c z3 + d];

                ans2=Solve[{s1,s2,s3} == {0,0,0},{b,c,d}];
		b = b /. ans2[[1]];
		c = c /. ans2[[1]];
		d = d /. ans2[[1]];

                a = N[a] /. Solve[a d - b c == 1,{a}][[1]];
		ans = N[{a,b,c,d}];
		Return[ans];
	]
(**********************  FracFuncSub[z1,z2,w1,w2,num] **************************)
(* $@$3$N4X?t$O%]%"%s%+%l5e>e!J5eFb$G$O$$$1$J$$!K$N#2E@(J($@:BI8$OJ#AG?t(Jz1,z2$@!K$r(J    *)
(* $@F1$8$/%]%"%s%+%l5e>e$N#2E@(J(w1,w2)$@$K0\$90l<!J,?tJQ49$r5a$a$k4X?t$G$"$k!#(J     *)
(* $@$?$@$7$3$N>l9g(J a $@!a(J num $@$H$$$&>r7o$r;O$a$K$D$1$k!#(J                          *)
(* $@!cJVCM!d(J  {a,b,c,d}                                                         *)
(*                              az + b                                         *)
(*               $@JVCM$N0UL#(J     ------                                         *)
(*                              cz + d                                         *)
(*******************************************************************************)

FracFuncSub[z1_,z2_,w1_,w2_,num_] := 
	Block[{a,b,c,d,ans,ans2,ans3,ans4,s1,s2,s3,flg},
		If[(N[Abs[z1]] >= Infinity) && (N[Abs[w1]] >= Infinity),s1 = c];
 		If[(N[Abs[z1]] >= Infinity) && (N[Abs[w1]] < Infinity),s1 = a - c w1];
		If[(N[Abs[z1]] < Infinity) && (N[Abs[w1]] >= Infinity),s1 = c z1 + d];
                If[(N[Abs[z1]] < Infinity) && (N[Abs[w1]] < Infinity)
							,s1 = a z1 + b - w1 (c z1 + d)];

		If[N[Abs[z2]] >= Infinity && N[Abs[w2]] >= Infinity,s2 = c];
		If[N[Abs[z2]] >= Infinity && N[Abs[w2]] < Infinity,s2 = a - c w2];
		If[N[Abs[z2]] < Infinity && N[Abs[w2]] >= Infinity,s2 = c z2 + d];
		If[N[Abs[z2]] < Infinity && N[Abs[w2]] < Infinity
							,s2 = a z2 + b - w2 (c z2 + d)];
		c = num;
                ans2=Solve[{s1,s2} == {0,0},{b,d}];
		b = b /. ans2[[1]];
		d = d /. ans2[[1]];
                a = N[a] /. Solve[a d - b c == 1,{a}][[1]];
		ans = N[{a,b,c,d}];
		Return[ans];
	]

(**********************  FracFuncLast[z1,z2,w1,w2] *****************************)
(* $@$3$N4X?t$O%]%"%s%+%l5e>e!J5eFb$G$O$$$1$J$$!K$N#2E@(J($@:BI8$OJ#AG?t(Jz1,z2$@!K$r(J    *)
(* $@F1$8$/%]%"%s%+%l5e>e$N#2E@(J(w1,w2)$@$K0\$90l<!J,?tJQ49$r5a$a$k4X?t$G$"$k!#(J     *)
(* $@$?$@$7$3$N>l9g(J a + d = 0 $@$H$$$&>r7o$r;O$a$K$D$1$k!#(J                         *)
(* $@!cJVCM!d(J  {a,b,c,d}                                                         *)
(*                              az + b                                         *)
(*               $@JVCM$N0UL#(J     ------                                         *)
(*                              cz + d                                         *)
(*******************************************************************************)

FracFuncLast[z1_,z2_,w1_,w2_] := 
	Block[{a,b,c,d,ans,ans2,ans3,ans4,s1,s2,s3,flg},
		If[(N[Abs[z1]] >= Infinity) && (N[Abs[w1]] >= Infinity),s1 = c];
 		If[(N[Abs[z1]] >= Infinity) && (N[Abs[w1]] < Infinity),s1 = a - c w1];
		If[(N[Abs[z1]] < Infinity) && (N[Abs[w1]] >= Infinity),s1 = c z1 + d];
                If[(N[Abs[z1]] < Infinity) && (N[Abs[w1]] < Infinity)
							,s1 = a z1 + b - w1 (c z1 + d)];

		If[N[Abs[z2]] >= Infinity && N[Abs[w2]] >= Infinity,s2 = c];
		If[N[Abs[z2]] >= Infinity && N[Abs[w2]] < Infinity,s2 = a - c w2];
		If[N[Abs[z2]] < Infinity && N[Abs[w2]] >= Infinity,s2 = c z2 + d];
		If[N[Abs[z2]] < Infinity && N[Abs[w2]] < Infinity
							,s2 = a z2 + b - w2 (c z2 + d)];
		s3 = a + d;
                ans2=Solve[{s1,s2,s3} == {0,0,0},{b,c,d}];
		If[Length[ans2] == 0,Return[False],
			b = b /. ans2[[1]];
			c = c /. ans2[[1]];
			d = d /. ans2[[1]];
                	a = N[a] /. Solve[a d - b c == 1,{a}][[1]];
			ans = N[{a,b,c,d}];
			Return[ans]]
	]

(**********************  PointToUp[p1]******************************************)
(*  $@$3$N4X?t$O%]%"%s%+%l5eFb$NE@(J p1 $@$r(J upper half space $@%b%G%k>e$NE@$X(J         *)
(*  $@JQ49$9$k4X?t!#(J                                                             *)
(*******************************************************************************)
PointToUp[p1_] :=
	Block[{x,y,z,k},
		If[p1[[3]] == 1,Return[Infinity]];
		k = p1[[1]]^2 + p1[[2]]^2 + (1-p1[[3]])^2;
		x = 2 p1[[1]]/k;
		y = 2 p1[[2]]/k;
		z = (1-p1[[1]]^2-p1[[2]]^2-p1[[3]]^2)/k;
		Return[{x,y,z}];
	]

(**********************  UPToPoint[p1]******************************************)
(*  $@$3$N4X?t$O(Jupper half space $@%b%G%k>e$NE@$r%]%"%s%+%l5e$J$$$NE@$X(J            *)
(*  $@JQ49$9$k4X?t!#(J                                                             *)
(*******************************************************************************)
UpToPoint[p1_]:=
	Block[{x,y,z,k},
		If[p1 == Infinity,Return[{0,0,1}]];
		k = p1[[1]]^2 + p1[[2]]^2 + (1+p1[[3]])^2;
		x = 2 p1[[1]]/k;
		y = 2 p1[[2]]/k;
		z = (p1[[1]]^2 + p1[[2]]^2 + p1[[3]]^2 -1)/k;
		Return[{x,y,z}];
	]


(**********************  TakeCenter[p1,q1]**************************************)
(*  $@$3$N4X?t$O%]%"%s%+%l5eFb$N#2E@(Jp1,q1 ($@%f!<%/%j%C%I$N#3<!85:BI8(J)$@$N(J           *)
(*  $@?bD>#2EyJ,LL$r5a$a$k4X?t$G$"$k!#(J                                           *)
(*  $@?bD>FsEyJ,LL$,%]%"%s%+%l5e$NCf?4$rDL$i$J$$;~(J $@!<!<!d?bD>FsEyJ,LL$r$"$i$o$9(J  *)
(*                                                     $@5e$NCf?4:BI8$rJV$9!#(J    *)
(*  $@?bD>FsEyJ,LL$,%]%"%s%+%l5e$NCf?4$rDL$k;~(J     $@!<!<!d?bD>FsEyJ,LL$r$"$i$o$9(J  *)
(*                                                     $@J?LL$N(Jp1$@J}8~$NK!@~%Y%/(J  *)
(*                                                     $@%H%k$rJV$9!#(J            *)
(*******************************************************************************)
TakeCenter[p1_,q1_] :=
	Block[{k,r,c0,c1,s0,s1,p2,p3,q2,q3,w1,w2,w3,d1,d2},
		d1 = p1[[1]]^2 + p1[[2]]^2 + p1[[3]]^2;
		d2 = q1[[1]]^2 + q1[[2]]^2 + q1[[3]]^2;
		If[N[Abs[d1-d2]]<0.00000001
			,vec = N[{p1[[1]]-q1[[1]],p1[[2]]-q1[[2]],p1[[3]]-q1[[3]]}];
			Return[-100 vec],
			If[p1[[1]]!=0 || p1[[2]]!=0,
				c0 = N[p1[[2]]/Sqrt[p1[[1]]^2 + p1[[2]]^2]];
				s0 = N[p1[[1]]/Sqrt[p1[[1]]^2 + p1[[2]]^2]];
				p2 = N[{0,s0 p1[[1]] + c0 p1[[2]],p1[[3]]}];
				c1 = N[p2[[3]]/Sqrt[p2[[2]]^2 + p2[[3]]^2]];
				s1 = N[p2[[2]]/Sqrt[p2[[2]]^2 + p2[[3]]^2]];
				p3 = N[{0,0,s1 p2[[2]] + c1 p2[[3]]}];
				q2 = N[{c0 q1[[1]] - s0 q1[[2]],s0 q1[[1]] 
						+ c0 q1[[2]],q1[[3]]}];
				q3 = N[{q2[[1]],c1 q2[[2]] - s1 q2[[3]],s1 q2[[2]]
						 + c1 q2[[3]]}];
				,p3 = p1;q3 = q1];
			w1 = TakeZCenter[p3,q3];
			If[p1[[1]]!=0 || p1[[2]]!=0,
				w2 = N[{w1[[1]],c1 w1[[2]] + s1 w1[[3]]
					,-s1 w1[[2]] + c1 w1[[3]]}];
				w3 = N[{c0 w2[[1]] + s0 w2[[2]],-s0 w2[[1]] 
					+ c0 w2[[2]],w2[[3]]}];
				,w3 = w1];
			Return[w3];
		]
	]

(**********************  TakeZCenter[p1,q1]*************************************)
(*  $@$3$N4X?t$O(JTakeCenter $@$NJd=u4X?t!#(J                                          *)
(*******************************************************************************)

TakeZCenter[p1_,q1_] :=
	Block[{p2,q2,q3,q4,r,k,c0,c1,c2,c3,d0,e0,dis1,dis2,dis3,s,t,m,n,anse,ansd,dmy,siki1,siki2},

		p2 = PointToUp[p1];
		q2 = PointToUp[q1];
		q3 = N[q2 / p2[[3]]];
		q4 = UpToPoint[q3];
		r = Sqrt[q4[[1]]^2 + q4[[2]]^2 + q4[[3]]^2];
		k = N[(1-Sqrt[1-r^2])/(r^2)];
		c0 = N[k q4];
		c1 = PointToUp[c0];
		c2 = N[p2[[3]] c1];
		c3 = N[UpToPoint[c2]];
		If[c3[[1]] == 0 && c3[[2]] == 0,Return[{0,0,(c3[[3]]^2+1)/(2 c3[[3]])}]];
		dis1 = q1[[1]]^2 + q1[[2]]^2 + q1[[3]]^2;
		siki1 = 2 (dis1 - p1[[3]] q1[[3]]) t 
			+ 2 (p1[[3]] q1[[3]] - p1[[3]]^2) s + p1[[3]]^2 - dis1;
		siki2 = 2 p1[[3]]^2 s + 2 p1[[3]] q1[[3]] t - 1 - p1[[3]]^2;
		ansd = {s,t} /. Solve[{siki1,siki2}=={0,0},{s,t}][[1]];
		d0 = N[{ansd[[2]] q1[[1]],ansd[[2]] q1[[2]],ansd[[1]] p1[[3]] + ansd[[2]] q1[[3]]}];
		dis1 = d0[[1]]^2 + d0[[2]]^2 + d0[[3]]^2;
		dis1 = c3[[1]]^2 + c3[[2]]^2 + c3[[3]]^2;
		dis2 = d0[[1]]^2 + d0[[2]]^2 + d0[[3]]^2;
		dis3 = (c3[[1]] - d0[[1]])^2 + (c3[[2]] - d0[[2]])^2 + (c3[[3]] - d0[[3]])^2;
		siki1 = 2 n ((d0[[1]] - c3[[1]]) q1[[1]] + (d0[[2]] - c3[[2]]) q1[[2]] +
			     (d0[[3]] - c3[[3]]) q1[[3]]) + 2 m p1[[3]] (d0[[3]] - c3[[3]]) +
				dis1 - dis2 + dis3;
		siki2 = 2 n (c3[[1]] q1[[1]] + c3[[2]] q1[[2]] + c3[[3]] q1[[3]]) + 
			2 m c3[[3]] p1[[3]] - 1 - dis1; 
		anse = {m,n} /. Solve[{siki1,siki2}=={0,0},{m,n}][[1]];
		e0 = N[{anse[[2]] q1[[1]],anse[[2]] q1[[2]],anse[[1]] p1[[3]] + anse[[2]] q1[[3]]}];
		Return[e0];
	]



(**********************  MoveByFruc[pt,frac]************************************)
(*  $@$3$N4X?t$O(Jupper half space $@>e$NE@(J pt = (x,y,z) {= x + y I + z J}           *)
(*  $@$r0l<!J,?tJQ49(J             (a1 + a2 I) pt + (b1 + b2 I)                    *)
(*                 frac =    ------------------------------                    *)
(*                             (c1 + c2 I) pt + (d1 + d2 I)                    *)
(*  $@$G0\$7$?@h$NE@$r5a$a$k4X?t!#(J                                               *)
(*******************************************************************************)

MoveByFruc[pt_,frac_] :=
	Block[{a1,a2,b1,b2,c1,c2,d1,d2,s1,s2,t1,t2,u1,u2,v1,v2,k,ans},
		
		a1 = Re[frac[[1]]];
		a2 = Im[frac[[1]]];
		b1 = Re[frac[[2]]];
		b2 = Im[frac[[2]]];
		c1 = Re[frac[[3]]];
		c2 = Im[frac[[3]]];
		d1 = Re[frac[[4]]];
		d2 = Im[frac[[4]]];
		s1 = a1 pt[[1]] - a2 pt[[2]] + b1;
		t1 = a1 pt[[2]] + a2 pt[[1]] + b2;
		u1 = a1 pt[[3]];
		v1 = a2 pt[[3]];
		s2 = c1 pt[[1]] - c2 pt[[2]] + d1;
		t2 = -(c1 pt[[2]] + c2 pt[[1]] + d2);
		u2 = -(c1 pt[[3]]);
		v2 = -(c2 pt[[3]]);
		k = s2^2 + t2^2 + u2^2 + v2^2;

		Return[N[{s1 s2 - t1 t2 - u1 u2 - v1 v2,
			 s1 t2 + s2 t1 + u1 v2 - u2 v1,
			 s1 u2 - t1 v2 + s2 u1 + t2 v1}/k]];
		
	]

(**********************  CheckIn[c1,p1]   **************************************)
(*  $@$3$N4X?t$O(Jc1$@$rCf?4$H;W$($k%]%"%s%+%l5e>e$NJ?LL!J5e!K$K$*$$$F!"$=$N5eFb$K(J   *)
(*  $@E@(Jp1$@$,4^$^$l$F$$$k$+$I$&$+$rD4$Y$k4X?t!#(J                                   *)
(*  $@E@(Jp1$@$,4^$^$l$F$$$k;~(J  [0,p1[[1]],p1[[2]],p1[[3]]] $@$rJV$9!#(J                 *)
(*  $@E@(Jp1$@$,4^$^$l$F$J$$;~(J  [2,p1[[1]],p1[[2]],p1[[3]]] $@$rJV$9!#(J                 *)
(*******************************************************************************)
CheckIn[c1_,p1_] :=
	Block[{r,csub},
		r = c1[[1]]^2 + c1[[2]]^2 + c1[[3]]^2 - 1;
		csub = c1;
		If[N[Abs[csub[[1]]]] < 0.000000001,csub[[1]] = 0.0];
		If[N[Abs[csub[[2]]]] < 0.000000001,csub[[2]] = 0.0];
		If[N[Abs[csub[[3]]]] < 0.000000001,csub[[3]] = 0.0];
		If[N[(csub[[1]]-p1[[1]])^2 + (csub[[2]]-p1[[2]])^2 + (csub[[3]]-p1[[3]])^2]>r,
		   Return[{0,csub[[1]],csub[[2]],csub[[3]]}]
			,Return[{2,csub[[1]],csub[[2]],csub[[3]]}]];
	]

(**********************  CircleCent[p1z,p2z] ***********************************)
(* $@$3$N4X?t$O%]%"%s%+%l5e>e$N#2E@!JJ#AG?t!K$rDL$kD>@~!J1_8L!K$NCf?4:BI8$r5a$a$k(J*)
(* p1z p2z $@$O$H$b$KJ#AG?t!#4X?t$,JV$9CM$O:BI8$G$"$k!#(J                          *)
(*******************************************************************************)
CircleCent[p1z_,p2z_] :=
	Block[{p1,p2,p3,p3z,c1,s,t,dp1,dp2,mp12,ans,k},
		p1 = CompToPoint[p1z];
		p2 = CompToPoint[p2z];
		dp1 = p1[[1]]^2 + p1[[2]]^2 + p1[[3]]^2;
		dp2 = p2[[1]]^2 + p2[[2]]^2 + p2[[3]]^2;
		mp12 = p1[[1]] p2[[1]] + p1[[2]] p2[[2]] + p1[[3]] p2[[3]];
		ans = {s,t} /. Solve[{mp12 s +  dp2 (t-1),dp1 (s-1) + mp12 t} == {0,0},{s,t}][[1]];
		c1 = ans[[1]] p1 + ans[[2]] p2;
		k = 1 - Sqrt[(c1[[1]]-p2[[1]])^2 + (c1[[2]]-p2[[2]])^2 + (c1[[3]]-p2[[3]])^2]/Sqrt[
                         c1[[1]]^2 + c1[[2]]^2 + c1[[3]]^2];
		p3 = k c1;
		p3z = PointToComp[p3];

		Return[p3z];
	]
(**********************  MakeCircle[p1z,p2z] ***********************************)
(* $@$3$N4X?t$O%]%"%s%+%l5e>e$N#2E@!JJ#AG?t!K$rDL$kD>@~!J1_8L!K$NCf?4:BI8$r5a$a$k(J*)
(* p1z p2z $@$O$H$b$KJ#AG?t!#4X?t$,JV$9CM$O:BI8$G$"$k!#(J                          *)
(*******************************************************************************)
MakeCircle[p1z_,p2z_] :=
	Block[{p1,p2,p3,p3z,c1,c1z,s,t,dp1,dp2,mp12,ans,k},
		p1 = CompToPoint[p1z];
		p2 = CompToPoint[p2z];
		dp1 = p1[[1]]^2 + p1[[2]]^2 + p1[[3]]^2;
		dp2 = p2[[1]]^2 + p2[[2]]^2 + p2[[3]]^2;
		mp12 = p1[[1]] p2[[1]] + p1[[2]] p2[[2]] + p1[[3]] p2[[3]];
		ans = {s,t} /. Solve[{mp12 s +  dp2 (t-1),dp1 (s-1) + mp12 t} == {0,0},{s,t}][[1]];
		c1 = ans[[1]] p1 + ans[[2]] p2;
		Return[c1];
	]

(**********************  CrossCircle[c1,c2,p1z,p2z]*****************************)
(* $@$3$N4X?t$O(Jc1 $@$rCf?4$H$7C<E@$r(Jp1z,p2z$@$K;}$D1_8L$H(Jc2$@$rCf?4$H$9$k5e$H$N8rE@(J    *)
(* $@$r5a$a$k(J                                                                    *)
(*******************************************************************************)
CrossCircle[c1_,c2_,p1z_,p2z_] :=
	Block[{p1,p2,px,siki1,siki2,ans,ans1,ans2,s,t,px1,px2,l1},
		p1 = CompToPoint[p1z];
		p2 = CompToPoint[p2z];
		px = s p1 + t p2;
		siki1 = px[[1]]^2 + px[[2]]^2 + px[[3]]^2 - 2 (px[[1]] c1[[1]] + px[[2]] c1[[2]] + 
						px[[3]] c1[[3]]) + 1;
		siki2 = px[[1]]^2 + px[[2]]^2 + px[[3]]^2 - 2 (px[[1]] c2[[1]] + px[[2]] c2[[2]] + 
						px[[3]] c2[[3]]) + 1;
		ans = Solve[{siki1,siki2} == {0,0},{s,t}];
		ans1 = {s,t} /. ans[[1]];
		ans2 = {s,t} /. ans[[2]];
		px1 = N[ans1[[1]] p1 + ans1[[2]] p2];
		px2 = N[ans2[[1]] p1 + ans2[[2]] p2];
		l1 = px1[[1]]^2 + px1[[2]]^2 + px1[[3]]^2;
		If[Abs[l1] > 1,px1 = px2];
		Return[px1];
	]

(**********************  CrossPlane[p1,p2] *************************************)
(* $@$3$N4X?t$O(Jp1,p2 $@$rCf?4$H$9$k5e$N8r@~$H(J(0,0,0)$@$rDL$kJ?LL$NCf?4:BI8$r5a$a$k!#(J *)
(* $@$?$@$7(J p1 $@$r4^$`$h$&$K$9$k!#(J                                                *)
(*******************************************************************************)
CrossPlane[p1_,p2_] :=
	Block[{a,b,c,dis},
		a = p2[[2]] - p1[[2]];
		b = p2[[3]] - p1[[3]];
		c = p2[[4]] - p1[[4]];
		dis = Sqrt[a^2 + b^2 + c^2];
		dis = 200/dis;
		Return[N[dis {a,b,c}]];
	]

(**********************  HypDistance[p1,p2] * *************************************)
(* $@$3$N4X?t$O(Jp1,p2 $@$N4V$N5wN%$r5a$a$k4X?t!#(J                                    *)
(*******************************************************************************)
HypDistance[p1_,p2_] :=
	Block[{u1,u2,q1,q2,cos1,sin1,k},
		If[N[Abs[p1[[1]]]] > 0.00000000001 || N[Abs[p1[[2]]]] > 0.00000000001,
			cos1 = p1[[2]]/Sqrt[p1[[1]]^2 + p1[[2]]^2];
			sin1 = p1[[1]]/Sqrt[p1[[1]]^2 + p1[[2]]^2];
			q1 = {0,Sqrt[p1[[1]]^2 + p1[[2]]^2],p1[[3]]};
			q2 = {cos1 p2[[1]] - sin1 p2[[2]],sin1 p2[[1]] + cos1 p2[[2]],p2[[3]]},
			q1 = {0,0,p1[[3]]};
			q2 = p2];
		If[N[Abs[q1[[2]]]] > 0.00000000001 || N[Abs[q1[[3]]]] > 0.00000000001,		
			cos1 = q1[[3]]/Sqrt[q1[[2]]^2 + q1[[3]]^2];
			sin1 = q1[[2]]/Sqrt[q1[[2]]^2 + q1[[3]]^2];
			q1 = {0,0,Sqrt[q1[[2]]^2 + q1[[3]]^2]};
			q2 = {q2[[1]],cos1 q2[[2]] - sin1 q2[[3]],sin1 q2[[2]] + cos1 q2[[3]]},
			q1 = {0,0,0};
			q2 = p2];
		u1 = PointToUp[q1];
		u2 = PointToUp[q2];
		u2 = u2 / u1[[3]];
		u1 = u1 / u1[[3]];
		q1 = UpToPoint[u1];
		q2 = UpToPoint[u2];
		dis = Sqrt[q2[[1]]^2 + q2[[2]]^2 + q2[[3]]^2];
		If[N[Abs[dis]] < 0.0000000001,Return[Infinity],
			dis = Log[(1+dis)/(1-dis)];
			Return[dis]];
	]	

(**********************  TakeCross[c1,c2,c3] ***********************************)
(* $@$3$l$O%]%"%s%+%l%G%#%9%/>e$N#3J?LL$N8rE@$r5a$a$k4X?t!#(J                      *)
(* $@>e$N5wN%$r5a$a$k4X?t$N#2E@$r5a$a$k$H$-$J$I$K;H$&!#(J                          *)
(* $@0z?t$OJ?LL$r7h$a$k5e$NCf?4:BI8(J $@$?$@$7(J (flg,x,y,z) {flg $@$O(JHcad3d$@MQ$NFb30H=Dj(J *)
(* $@$N%U%i%0(J }$@$G$bNI$$!#(J                                                        *)
(*******************************************************************************)
TakeCross[c1_,c2_,c3_] :=
	Block[{x,y,z,s1,s2,s3,ans,ck1,ck2,ck3,ret},
		If[Length[c1] == 4,
			ck1 = {c1[[2]],c1[[3]],c1[[4]]},
			ck1 = c1];
		If[Length[c2] == 4,
			ck2 = {c2[[2]],c2[[3]],c2[[4]]},
			ck2 = c2];
		If[Length[c3] == 4,
			ck3 = {c3[[2]],c3[[3]],c3[[4]]},
			ck3 = c3];

		s1 = (ck1[[1]]-ck2[[1]]) x + (ck1[[2]]-ck2[[2]]) y + (ck1[[3]]-ck2[[3]]) z;
		s2 = (ck2[[1]]-ck3[[1]]) x + (ck2[[2]]-ck3[[2]]) y + (ck2[[3]]-ck3[[3]]) z;
		ans = Solve[{s1,s2} == {0,0},{y,z}];
		y = y /. ans[[1]];
		z = z /. ans[[1]];
		s3 = x^2 + y^2 + z^2 -2 x ck1[[1]] -2 y ck1[[2]] -2 z ck1[[3]] + 1;
		x = x /. Solve[{s3} == {0},{x}][[1]];
		If[x^2 + y^2 + z^2 > 1.0,
			Clear[x];
			Clear[y];
			Clear[z];
			y = y /. ans[[1]];
			z = z /. ans[[1]];
			x = x /. Solve[{s3} == {0},{x}][[2]];
		];
		Return[{x,y,z}]
	]

(**********************  ChangeForm[pnt] ***************************************)
(* $@%U%!%$%k$K=PNO$9$k$?$a$K%G!<%?$rJQ7A$9$k!#(J                                  *)
(*******************************************************************************)

ChangeForm[pnt_] :=
	Block[{str,ap},
		ap = pnt;
		If[N[Abs[ap[[1]]]]<0.000001,ap[[1]] = 0];
		If[N[Abs[ap[[2]]]]<0.000001,ap[[2]] = 0];
		If[N[Abs[ap[[3]]]]<0.000001,ap[[3]] = 0];

		If[Length[ap] == 4,
			If[N[Abs[ap[[4]]]]<0.000001,ap[[4]] = 0];
			str = StringJoin[ToString[ap[[1]]]," (",
				ToString[ap[[2]]],",",ToString[ap[[3]]],
				",",ToString[ap[[4]]],")"],
			str = StringJoin["0 (",
				ToString[ap[[1]]],",",ToString[ap[[2]]],
				",",ToString[ap[[3]]],")"]];
		Return[str];
	]
(***************************GetAngle[p1,p2]*************************************)
(* $@#2$D$NJ?LL$NLL3Q$r5a$a$k!#(J p1,p2 $@$OJ?LL$r7h$a$k5e$NCf?4:BI8(J                 *)
(*******************************************************************************)

GetAngle[p1_,p2_]:=
	Block[{r1,r2,r12,theta,q1,q2},
		If[Length[p1] == 4,
			q1 = {p1[[2]],p1[[3]],p1[[4]]},
			q1 = p1];
		If[Length[p2] == 4,
			q2 = {p2[[2]],p2[[3]],p2[[4]]},
			q2 = p2];
			r1 = N[Sqrt[q1[[1]]^2 + q1[[2]]^2 + q1[[3]]^2 - 1.0]];
			r2 = N[Sqrt[q2[[1]]^2 + q2[[2]]^2 + q2[[3]]^2 - 1.0]];
		r12 =N[Sqrt[(q1[[1]]-q2[[1]])^2 + (q1[[2]]-q2[[2]])^2 + 
			(q1[[3]]- q2[[3]])^2]];
		theta = ArcCos[-(r1^2 + r2^2 - r12^2)/(2 r1 r2)];
		theta = N[(180 theta)/Pi];
		If[Length[p1] == 4 && p1[[1]] == 2,
			theta = 180 - theta];
		If[Length[p2] == 4 && p2[[1]] == 2,
			theta = 180 - theta];
		Return[theta];
	]

(***************************GetAngle2[p1,p2]************************************)
(* $@#2$D$NJ?LL$NLL3Q$r5a$a$k!#(J p2$@$OJ?LL$NK!@~%Y%/%H%k(J                           *)
(*  p1 $@$OJ?LL$r7h$a$k5e$NCf?4:BI8(J                                              *)
(*******************************************************************************)
GetAngle2[p1_,p2_]:=
	Block[{r1,theta,q1,q2,len},
		If[Length[p1] == 4,
			q1 = {p1[[2]],p1[[3]],p1[[4]]},
			q1 = p1];
		If[Length[p2] == 4,
			q2 = {p2[[2]],p2[[3]],p2[[4]]},
			q2 = p2];
		len = N[Abs[q1[[1]] q2[[1]] + q1[[2]] q2[[2]] + q1[[3]] q2[[3]]]/Sqrt[
			q2[[1]]^2 + q2[[2]]^2 + q2[[3]]^2]];		
			r1 = N[Sqrt[q1[[1]]^2 + q1[[2]]^2 + q1[[3]]^2 - 1.0]];
		theta = ArcSin[len/r1];
		theta = N[90 - (180 theta)/Pi];
		Return[theta];
	]
CentFromFruc[frc_] :=
	Block[{pt1z,pt2z,gh1,gh2,gh3,tz,t1z,t2z,t3z,kpans,lpz,rpz,taz,tbz,ap,bp,t3p,t4p,ans},
		lpz = PointToComp[{-1,0,0}];
		rpz = PointToComp[{1,0,0}];
		gh1 = {0,I,I,0};
		pt1z = If[N[Abs[lpz]]<Infinity,(frc[[1]] lpz + frc[[2]])/(frc[[3]] lpz + frc[[4]])
				,frc[[1]]/frc[[3]]];
		pt2z = If[N[Abs[rpz]]<Infinity,(frc[[1]] rpz + frc[[2]])/(frc[[3]] rpz + frc[[4]])
				,frc[[1]]/frc[[3]]];
		(* pt1z,pt2z$@$r8GDj$5$;$k0l<!J,?tJQ49$r5a$a$k(J       *)
		gh2 = N[FracFuncLast[pt1z,pt2z,pt1z,pt2z]];
		If[gh2 == False,Return[False]];
		(* gh1 $@$H(J gh2 $@$h$j(J gh3 $@$r:n$k!#(J                    *)
		gh3 = MatA[gh2,gh1];
		Clear[tz];
		Clear[t1z];
		Clear[t2z];

		(* gh3 $@$K$h$kITF0E@$r5a$a$k(J                        *)
		kpans = Solve[gh3[[1]] tz + gh3[[2]] - (gh3[[3]] tz + gh3[[4]]) tz == 0,tz];
		t1z = tz /. kpans[[1]];
		t2z = tz /. kpans[[2]];
		If[Abs[Im[t1z]] > Abs[Im[t2z]],t3z = t2z;t2z = t1z;t1z = t3z];
		(* t1z$@$H(Jt2z$@$r7k$V1_$NCf?4:BI8$r5a$a$k(J *)
		t3p = MakeCircle[t1z,t2z];
		(* t1z$@$H(Jt2z$@$r7k$V1_8L$H(Jx$@<4$H$N8rE@$r5a$a$k!#(J        *)
		Clear[tz];
		kpans = Solve[tz^2 - 2 t3p[[1]] tz + 1 == 0,tz];
		taz = tz /. kpans[[1]];
		tbz = tz /. kpans[[2]];
		If[Abs[taz] > 1,taz = tbz];
		ap = {taz,0,0};
		(* pt1z,pt2z $@$r7k$V1_$NCf?4:BI8$r5a$a$k(J             *)
		t4p = MakeCircle[pt1z,pt2z];
		(* t1z$@$H(Jt2z$@$r7k$V1_8L$H(Jpt1z,pt2z $@$r7k$V1_8L$N8rE@$N(J *)
		(* $@:BI8$r5a$a$k(J                                     *)
		bp = CrossCircle[t3p,t4p,pt1z,pt2z];
		(* tp1 $@$H(J tp2 $@$N?bD>FsEyJ,LL$N5e$N:BI8$r5a$a$k(J ca   *)
		ans = TakeCenter[ap,bp];
		(* ca $@$rCf?4$H$9$k5e$N30B&$+FbB&$N$I$A$i$K(Jtp1$@$,4^$^$l$F$$$k$+(J *)
		(* $@D4$Y$k!#(J                                                   *)
		ans = CheckIn[ans,ap];
		Return[ans];
	]

(***************************MakeCenter[frc_,cntz_]******************************)
(* $@$3$l$OE@(Jcntz $@$r0l<!J,?tJQ49(J frc $@$G(J dpmz $@$K0\$7$F$=$NE@$H$N?bD>FsEyJ,LL(J      *)
(*  $@$r$b$H$a$k4X?t!#(J                                                           *)
(*******************************************************************************)
MakeCenter[frc_,cntz_] :=
	Block[{cnt,dpmz,dpm,ans},
		cnt = UpToPoint[cntz];
		(* (0,0,0)$@$r(Jfrc$@$G0\$7$?E@!JJ#AG?t!K$r(Jdpmz $@$H$9$k!#(J *)
		dpmz = MoveByFruc[cntz,frc];
		(* dpmz $@$r:BI8$K$J$*$9!#(J*)
		dpm = UpToPoint[dpmz];
		(* (0,0,0) $@$H(J dpm $@$NFsEyJ,LL$N5e$NCf?4:BI8$r(J cm1 $@$H$9$k(J.*)
		ans = TakeCenter[dpm,cnt];
		(* cm1 $@$rCf?4$H$9$k5e$N30B&$+FbB&$N$I$A$i$K(J(0,0,0)$@$,4^$^$l$F$$$k$+(J *)
		(* $@D4$Y$k!#(J                                                        *)
		ans = CheckIn[ans,cnt];
		Return[ans]]


LineDistance[frc_] :=
	Block[{pt1z,pt2z,gh1,gh2,gh3,tz,t1z,t2z,t3z,kpans,lpz,rpz,taz,tbz,ap,bp,t3p,t4p,ans},
		lpz = PointToComp[{-1,0,0}];
		rpz = PointToComp[{1,0,0}];
		gh1 = {0,I,I,0};
		pt1z = If[N[Abs[lpz]]<Infinity,(frc[[1]] lpz + frc[[2]])/(frc[[3]] lpz + frc[[4]])
				,frc[[1]]/frc[[3]]];
		pt2z = If[N[Abs[rpz]]<Infinity,(frc[[1]] rpz + frc[[2]])/(frc[[3]] rpz + frc[[4]])
				,frc[[1]]/frc[[3]]];
		(* pt1z,pt2z$@$r8GDj$5$;$k0l<!J,?tJQ49$r5a$a$k(J       *)

		gh2 = N[FracFuncLast[pt1z,pt2z,pt1z,pt2z]];
		If[gh2 == False || gh2 == {0,0,0,0},Return[False]];
		(* gh1 $@$H(J gh2 $@$h$j(J gh3 $@$r:n$k!#(J                    *)
		gh3 = MatA[gh2,gh1];
		Clear[tz];
		Clear[t1z];
		Clear[t2z];

		(* gh3 $@$K$h$kITF0E@$r5a$a$k(J                        *)
		kpans = Solve[gh3[[1]] tz + gh3[[2]] - (gh3[[3]] tz + gh3[[4]]) tz == 0,tz];
		t1z = tz /. kpans[[1]];
		t2z = tz /. kpans[[2]];
		If[Abs[Im[t1z]] > Abs[Im[t2z]],t3z = t2z;t2z = t1z;t1z = t3z];
		(* t1z$@$H(Jt2z$@$r7k$V1_$NCf?4:BI8$r5a$a$k(J *)
		t3p = MakeCircle[t1z,t2z];
		(* t1z$@$H(Jt2z$@$r7k$V1_8L$H(Jx$@<4$H$N8rE@$r5a$a$k!#(J        *)
		Clear[tz];
		kpans = Solve[tz^2 - 2 t3p[[1]] tz + 1 == 0,tz];
		taz = tz /. kpans[[1]];
		tbz = tz /. kpans[[2]];
		If[Abs[taz] > 1,taz = tbz];
		ap = {taz,0,0};
		(* pt1z,pt2z $@$r7k$V1_$NCf?4:BI8$r5a$a$k(J             *)
		t4p = MakeCircle[pt1z,pt2z];
		(* t1z$@$H(Jt2z$@$r7k$V1_8L$H(Jpt1z,pt2z $@$r7k$V1_8L$N8rE@$N(J *)
		(* $@:BI8$r5a$a$k(J                                     *)
		bp = CrossCircle[t3p,t4p,pt1z,pt2z];
		(* tp1 $@$H(J tp2 $@$N?bD>FsEyJ,LL$N5e$N:BI8$r5a$a$k(J ca   *)
		Return[HypDistance[ap,bp]]
	]

CheckFruc[frc_] :=
	Block[{j1,j2,dis1,dis2},
		j1 = {0.3,0.4,0.5};
		j2 = {0.2,0.6,0.4};
		dis1 = HypDistance[j1,j2];
		j1 = PointToUp[j1];
		j2 = PointToUp[j2];
		j1 = MoveByFruc[j1,frc];
		j2 = MoveByFruc[j2,frc];
		j1 = UpToPoint[j1];
		j2 = UpToPoint[j2];
		dis2 = HypDistance[j1,j2];
		Print["Fruc Check ",N[Abs[dis1-dis2]]];
	]
		
ChangeLst1[x_] :=
		Block[{i,j,len,ret},
			ret = x;
			For[i = 1,i<Length[ret],i++,
				If[ret[[i]] == -ret[[i+1]],
					ret = Join[Drop[ret,-(Length[ret]-i+1)],Drop[ret,i+1]];
					i = 0]];
			Return[ret]]


MakeList[num_,max_,kw_,kwr_,klst_] :=
	Block[{length,i,j,list,flst,tlst,flg,kp,knm,cent,dist,ylis},
		flst = {1,2,3,-1,-2,-3};
		tlst = {};
		ylis = {};
		For[length = 1,length <= num,length++,
			For[i=1,i<=6^length,i++,
				list = {1};
				For[j = 1,j<length,j++,
					list = Append[list,1]];
				For[j = 1,j<=length,j++,
					If[j != length,list[[j]] = flst[[Mod[Quotient[i-1,
									6^(length-j)],6]+1]],
						       list[[j]] = flst[[Mod[i-1,6]+1]]]];
				list = ChangeLst1[list];
Print["list ",list];
				flg = True;
				If[Length[list] != length,flg = False,
					kp = kw;
					For[j = 1,j<=Length[list],j++,
						If[list[[j]] > 0,knm = list[[j]],knm = 3-list[[j]]];
						kp = MatA[kp,klst[[knm]]];
					];
					kp = MatA[kp,kwr];
					dist = LineDistance[kp];
					If[dist <= max,
						list = Append[list,dist];
						cent = CentFromFruc[kp];
						If[cent == False,flg = False];
						For[j = 1,j<=Length[tlst],j++,
							If[CheckSame[cent,tlst[[j]]] == True,flg 
											= False]];
						If[flg == True,tlst = Join[tlst,{cent}];
								Print["TOTAL ",Length[tlst]];
								ylis = Join[ylis,{list}]]]]]];
		Return[{tlst,ylis}]]

MakeMatList[num_,max_,kw_,kwr_,klst_] :=
	Block[{length,i,j,list,flst,tlst,flg,kp,knm,cent,dist,ylis},
		flst = {1,2,3,-1,-2,-3};
		tlst = {};
		ylis = {};
		For[length = 1,length <= num,length++,
			For[i=1,i<=6^length,i++,
				list = {1};
				For[j = 1,j<length,j++,
					list = Append[list,1]];
				For[j = 1,j<=length,j++,
					If[j != length,list[[j]] = flst[[Mod[Quotient[i-1,
									6^(length-j)],6]+1]],
						       list[[j]] = flst[[Mod[i-1,6]+1]]]];
				list = ChangeLst1[list];
Print["list ",list];
				flg = True;
				If[Length[list] == 0,flg = False,
					kp = kw;
					For[j = 1,j<=Length[list],j++,
						If[list[[j]] > 0,knm = list[[j]],knm = 3-list[[j]]];
						kp = MatA[kp,klst[[knm]]];
					];
					kp = MatA[kp,kwr];
					dist = LineDistance[kp];
					If[dist <= max,
						list = Append[list,dist];
						cent = CentFromFruc[kp];
						If[cent == False,flg = False];
						Print["cent  ",cent];
						For[j = 1,j<=Length[tlst],j++,
							Print["num ",j,"tlst ",tlst[[j]]];
							If[CheckSame[cent,tlst[[j]]] == True,flg 
											= False];
							Print["flg ",flg]];
						If[flg == True,tlst = Join[tlst,{cent}];
								ylis = Join[ylis,{kp}]]]]]];
		Return[{tlst,ylis}]]

MakeSubList[num_,max_,kw_,kwr_,klst_] :=
	Block[{length,i,j,list,flst,tlst,flg,kp,knm,cent,dist,ylis},
		flst = {1,2,3,-1,-2,-3};
		tlst = {};
		ylis = {};
		For[length = 1,length <= num,length++,
				list = {1};
				For[j = 1,j<length,j++,
					list = Append[list,1]];
Print["list ",list];
				flg = True;
				If[Length[list] == 0,flg = False,
					kp = kw;
					For[j = 1,j<=Length[list],j++,
						If[list[[j]] > 0,knm = list[[j]],knm = 3-list[[j]]];
						kp = MatA[kp,klst[[knm]]];
					];
					kp = MatA[kp,kwr];
					dist = LineDistance[kp];
					list = Append[list,dist];
					cent = CentFromFruc[kp];
					If[cent == False,flg = False];
					Print["cent  ",cent];
					For[j = 1,j<=Length[tlst],j++,
						Print["num ",j,"tlst ",tlst[[j]]];
						If[CheckSame[cent,tlst[[j]]] == True,flg 
										= False];
						Print["flg ",flg]];
					If[flg == True,tlst = Join[tlst,{cent}];
								ylis = Join[ylis,{list}]]]];
		Return[{tlst,ylis}]]


	
CheckSame[p1_,p2_] :=
	Block[{dis,ans},
		dis = Sqrt[(p1[[1]] - p2[[1]])^2 + (p1[[2]] - p2[[2]])^2 + 
			(p1[[3]] - p2[[3]])^2];
		If[dis < 0.00001,Return[True],Return[False]]]


MoveTest[p_,frc_] :=
	Block[{z1},
		z1 = PointToUp[p];
		z1 = MoveByFruc[z1,frc];
		Return[UpToPoint[z1]]]

Distance[p1_,p2_] :=
	Block[{dis},
		dis = N[Sqrt[(p1[[1]]-p2[[1]])^2 + (p1[[2]]-p2[[2]])^2 
				+ (p1[[3]]-p2[[3]])^2]];
		Return[dis]]
SubDistance[p1_,p2_] :=
	Block[{dis},
		dis = N[Sqrt[(p1[[2]]-p2[[1]])^2 + (p1[[3]]-p2[[2]])^2 
				+ (p1[[4]]-p2[[3]])^2]];
		Return[dis]]

