/***************************************************************************
* This is a simple program to create Julia set images of  
*   Z^2+C
*   C*SINZ
*   C*COSZ
*   C*EXPZ
*
*
*   Mandelbrot set 
*   Spider 
*   Phoenix  
*   Glass
*   Noel1
*   Noel2
*   Newton Power
*   Tetrate
*   Barnsley1
*   Barnsley2
*   Barnsley3
*
*   The output file is in GIF format....
*                           (C)1993 Massimo Casal
*                        email:casal@udmi5400.cineca.it
***************************************************************************/


#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <malloc.h>

#include "gifcompr.c"
#include "gifencod.c"
#include "complex.c"

int width,height; /*resolution*/

double xmin,xmax,ymin,ymax;  /* x and y limits*/ 

complex constant;        /* for Mandelbrot set
                           it represents the 
                           perturbation */

int dg;   /* degree for newton fractal type*/

char *file,*pal;  /* output and palette file names */
char *fractalname;   /*fractal type name*/

int fractaltype;     /* it stores the fractal type u choose*/  

#include "read.c"
#include "pal.c"

#include "mandel.c"
#include "julia.c"
#include "jsin.c"
#include "jcos.c"
#include "jexp.c"
#include "spider.c"
#include "phoenix.c"
#include "glass.c"
#include "noel1.c"
#include "noel2.c"
#include "newton.c"
#include "tetrate.c"
#include "barnsley1.c"
#include "barnsley2.c"
#include "barnsley3.c"

datafile()
{  
   FILE *fdata;
   char *c,d='g'; 
   c=strrchr(file,d);
   strcpy(c,"dat");
   fdata = fopen(file,"w");
   fprintf(fdata,"%s\n",fractalname);
   fprintf(fdata,"Resolution = %d * %d\n\n",width,height);
   if (fractaltype == 10) fprintf(fdata,"Degree = %d\n",dg);
   if (fractaltype == 0 || fractaltype == 5 || fractaltype == 6 || fractaltype == 11)
        { 
           fprintf(fdata,"Real perturbation of z(0) = %f\n",constant.r);
           fprintf(fdata,"Imaginary perturbation of z(0) = %f\n \n",constant.i);
         }
    else
         {
           fprintf(fdata,"Real part of c = %f\n",constant.r);
           fprintf(fdata,"Imaginary part of c = %f\n \n",constant.i);
         }  
   fprintf(fdata,"Top Left Corner\n");
   fprintf(fdata,"X=%f\n",xmin);
   fprintf(fdata,"Y=%f\n\n",ymax);
   fprintf(fdata,"Bottom Right Corner\n"); 
   fprintf(fdata,"X=%f\n",xmax); 
   fprintf(fdata,"Y=%f\n",ymin);
  } 

calc(xp,yp) 
int xp,yp;
{
 complex point;
 point.r = xmin + ((xmax-xmin)*xp)/width;
 point.i = ymin + ((ymax-ymin)*yp)/height; 
 switch(fractaltype)  { 
      case 0:
             return(mandel(point)); 
      case 1:
             return(julia(point));
      case 2:
             return(jsin(point));
      case 3:
             return(jcos(point));
      case 4:
             return(jexp(point));
      case 5:
             return(spider(point));
      case 6:
             return(phoenix(point));
      case 7:  
             return(glass(point));
      case 8:
             return(noel1(point)); 
      case 9:
             return(noel2(point));
      case 10:
             return(newton(point));
      case 11:
             return(tetrate(point));
      case 12:
             return(barnsley1(point));
      case 13:
             return(barnsley2(point));
      case 14:
             return(barnsley3(point));
  }  
}

main(argc,argv)   
int argc;
char *argv[];
{
   int backgr,interlaced,bites;
   int r[256],g[256],b[256];
   int ck1,ck2; /*checks*/

   file=malloc(20);
   pal=malloc(20);
   fractalname=malloc(20); 
   ck1=rd(argc,argv,file,pal,&width,&height,&constant,&dg,&xmin,&xmax,&ymin,&ymax,&fractaltype,fractalname);
   ck2=createpalette(r,g,b,pal);
   if (ck1==3 && ck2!=-1) 
   {backgr = 0;
   interlaced=0; /*1 if u want an interlaced GIF*/   
   bites=8;
   GIFEncode(file,width,height,interlaced,backgr,bites,r,g,b,calc); 
   datafile(); 
   }
  else 
   {printf("Usage:%s {-m -j -s -c -e -sp -ph -g -n1 -n2 -nw -t -b1 -b2 -b3 }  \n",argv[0]);
    printf("         -x width -y height [-r] [-i] [-deg]\n");
    printf("         [-x1] [-x2] [-y1] [-y2] \n");     
    printf("         [-o] [-p]\n");
    printf("Params in [] are optional \n");}
    if (ck2==-1) printf("\nError:palette file not found!\n");
    printf("\n");
 }
 
